/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.common;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.dada.smart.common.ReflectUtils;
import com.dada.smart.common.Utils;
import com.orhanobut.logger.Logger;
import java.util.ArrayList;
import java.util.List;

public class WindowMagician {
    public static List<ViewRootData> getFocusWindowRootView(WindowManager windowManager, boolean forceGetTop) {
        ArrayList<ViewRootData> list = new ArrayList<ViewRootData>();
        if (windowManager == null) {
            return list;
        }
        try {
            WindowManager.LayoutParams[] params;
            View[] viewsObject;
            Object globalWindowManager = Build.VERSION.SDK_INT <= 16 ? ReflectUtils.reflect(windowManager).field("mWindowManager").get() : ReflectUtils.reflect(windowManager).field("mGlobal").get();
            Object rootObjects = ReflectUtils.reflect(globalWindowManager).field("mViews").get();
            Object paramsObject = ReflectUtils.reflect(globalWindowManager).field("mParams").get();
            if (Build.VERSION.SDK_INT >= 19) {
                List viewList = (List)rootObjects;
                viewsObject = viewList.toArray(new View[viewList.size()]);
                List paramsList = (List)paramsObject;
                params = paramsList.toArray(new WindowManager.LayoutParams[paramsList.size()]);
            } else {
                viewsObject = (View[])rootObjects;
                params = (WindowManager.LayoutParams[])paramsObject;
            }
            if (forceGetTop) {
                list.add(new ViewRootData(viewsObject[viewsObject.length - 1], null, params[viewsObject.length - 1]));
            } else {
                for (int i = 0; i < viewsObject.length; ++i) {
                    Object attachInfo = ReflectUtils.reflect(viewsObject[i]).field("mAttachInfo").get();
                    Boolean hasFocus = (Boolean)ReflectUtils.reflect(attachInfo).field("mHasWindowFocus").get();
                    if (!hasFocus.booleanValue()) continue;
                    list.add(new ViewRootData(viewsObject[i], null, params[i]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void printViewTree(Object view, int index) {
        StringBuilder builder = new StringBuilder("--");
        for (int a = 0; a < index; ++a) {
            builder.append(" -- ");
        }
        builder.append(Utils.simpleName(view));
        Logger.d((Object)builder.toString());
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int count = viewGroup.getChildCount();
            ++index;
            for (int i = 0; i < count; ++i) {
                WindowMagician.printViewTree(viewGroup.getChildAt(i), index);
            }
        }
    }

    public static class ViewRootData {
        final View view;
        private final Rect winFrame;
        private final WindowManager.LayoutParams layoutParams;

        public ViewRootData(View view, Rect winFrame, WindowManager.LayoutParams layoutParams) {
            this.view = view;
            this.winFrame = winFrame;
            this.layoutParams = layoutParams;
        }

        public View getView() {
            return this.view;
        }

        public Rect getWinFrame() {
            return this.winFrame;
        }

        public WindowManager.LayoutParams getLayoutParams() {
            return this.layoutParams;
        }

        public boolean isDialogType() {
            return this.layoutParams.type == 2;
        }

        public boolean isActivityType() {
            return this.layoutParams.type == 1;
        }

        public Context context() {
            return this.view.getContext();
        }
    }
}

