package com.dada.smart.common.expression;

import com.dada.smart.common.ReflectUtils;
import com.dada.smart.common.Utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/**
 * Smart-Expression 表达式语言解析器
 */
public class SmartExpression {
    public static final String CONSTRUCTOR_METHOD = "constructor";
    public static final String THIS = "$this";
    public static final String TEXT = "$text";

    private final static Pattern digitPattern = Pattern.compile("^[0-9]*$");
    private String[] expressions;
    private Extra extra;

    public SmartExpression(String expressions, Extra extra) {
        this.expressions = expressions.replaceAll("\n", "").split(";");
        this.extra = extra;
    }

    private Result getResult(Object base, String expression) {
        Result result = new Result(expression);
        if (result.isParseOk())
            valueGet(base, result);
        return result;
    }

    private void valueGet(Object base, Result result) {
        try {
            Object value = base;
            //enable=<android.support.v4.app.NotificationManagerCompat>from(this).areNotificationsEnabled()

            for (String exp : result.right.split("\\.")) {
                if (exp.contains("(") && exp.contains(")")) {
                    value = methodGet(value, result.getBaseClassName(), exp);
                } else {
                    value = propertyGet(value, result.getBaseClassName(), exp);
                }
            }
            result.success = true;
            result.value = value.toString();
        } catch (Throwable e) {
            e.printStackTrace();
            result.success = false;
            result.value = e.getMessage();
        }
        //        System.out.println(result);
    }

    public List<Result> getResult(Object base) {
        List<Result> results = new ArrayList<>();
        for (String expression : expressions) {
            if (!Utils.isEmpty(expression) && base != null)
                results.add(getResult(base, expression));
        }
        return results;
    }


    private Object propertyGet(Object base, String className, String property) {
        ReflectUtils reflectUtils;
        int posKey = Expressions.convert(property);
        if (posKey > 0) {
            return getPosition(posKey);
        } else if (TEXT.equals(property)) {
            return getText();
        } else if (!Utils.isEmpty(className)) {//自定义执行的目标对象
            reflectUtils = ReflectUtils.reflect(className);
        } else {//在当前base对象中执行
            reflectUtils = ReflectUtils.reflect(base);
        }
        return reflectUtils.field(property).get();
    }

    private Object methodGet(Object base, String className, String method) {
        String[] array = method.split("\\(");
        String methodName = array[0];
        Object[] args = convertParam(base, array[1].replaceAll("\\)", ""));

        ReflectUtils reflectUtils;
        if (!Utils.isEmpty(className)) {//自定义执行的目标对象
            reflectUtils = ReflectUtils.reflect(className);
        } else {//在当前base对象中执行
            reflectUtils = ReflectUtils.reflect(base);
        }
        //执行构造方法创建对象
        if (CONSTRUCTOR_METHOD.equals(methodName)) {
            return reflectUtils.newInstance(args).get();
        } else {
            return reflectUtils.method(methodName, args).get();
        }
    }

    //<android.support.v4.app.NotificationManagerCompat>from(this).areNotificationsEnabled()
    //    private Object methodGet(Object base, String className, String method) {
    //        return ReflectUtils.reflect(className).method().getPosition();
    //    }

    private Object[] convertParam(Object base, String paramsString) {
        if (Utils.isEmpty(paramsString))
            return new Object[0];
        String[] params = paramsString.split(",");
        //        System.out.println(params.length);
        Object[] args = new Object[params.length];
        for (int i = 0; i < params.length; i++) {
            String param = params[i];
            int posKey = Expressions.convert(param);
            if (posKey > 0) {//位置参数
                args[i] = getPosition(posKey);
            } else if (digitPattern.matcher(param).matches()) {//如果是数字则转化为整数
                args[i] = Integer.parseInt(param);
            } else if ("this".equals(param) || THIS.equals(param)) {// this表示当前对象
                args[i] = base;
            } else {//其他都认为是字符串类型
                args[i] = param;
            }
        }
        return args;
    }

    private Integer getPosition(int posKey) {
        if (extra != null)
            return extra.getPosition(posKey);
        return -1;
    }

    private String getText() {
        if (extra != null)
            return extra.getText();
        return "";
    }

}
