package com.dada.smart.common.expression;

import android.util.SparseBooleanArray;

import com.dada.smart.common.R;
import com.dada.smart.common.Utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class Expressions {
    /**
     * LinearLayout
     */
    public static final String POSITION_LINEAR = "$pos";
    /**
     * ListView
     */
    public static final String POSITION_LIST = "$lPos";
    /**
     * RecyclerView
     */
    public static final String POSITION_RECYCLER = "$rPos";

    public static List<Result> fetchResult(Object base, String expressions, Extra extra) {
        if (Utils.isEmpty(expressions) || base == null)
            return new ArrayList<>();
        return new SmartExpression(expressions, extra).getResult(base);
    }

    public static JSONArray fetchAsArray(Object base, String expressions, Extra extra) {
        List<Result> results = fetchResult(base, expressions, extra);
        JSONArray array = new JSONArray();
        for (Result result : results) {
            JSONObject object = new JSONObject();
            try {
                object.put("expression", result.getExpression());
                object.put("success", result.isSuccess());
                if (result.isTypeEqual()) {
                    object.put("value", result.isSuccess() ? String.valueOf(result.getLeft().equals(result.getValue())) : result.getValue());
                } else if (result.isTypeAssign()) {
                    object.put("value", result.getValue());
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
            array.put(object);
        }
        return array;
    }

    /**
     * 将服务端返回的string类型的posKey转化为int
     *
     * @param posKey
     * @return
     */
    public static int convert(String posKey) {
        if (POSITION_LIST.equals(posKey)) {
            return R.id.tag_list_pos_index;
        } else if (POSITION_RECYCLER.equals(posKey)) {
            return R.id.tag_recycler_pos_index;
        } else if (POSITION_LINEAR.equals(posKey)) {
            return R.id.tag_pos_index;
        }
        return -1;
    }

    public static SparseBooleanArray findPosition(String expressions) {
        SparseBooleanArray positions = new SparseBooleanArray(2);
        if (expressions.contains(POSITION_LINEAR)) {
            positions.append(R.id.tag_pos_index, true);
        }
        if (expressions.contains(POSITION_LIST)) {
            positions.append(R.id.tag_list_pos_index, true);
        }
        if (expressions.contains(POSITION_RECYCLER)) {
            positions.append(R.id.tag_recycler_pos_index, true);
        }
        return positions;
    }
}
