package com.dada.smart.common;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;

import com.orhanobut.logger.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * 处理恶心的window相关工具类
 * Created by lakers on 18/8/21.
 */

public class WindowMagician {

    /**
     * 获取屏幕上正北focus的根View合集
     *
     * @param windowManager
     * @param forceGetTop  强制取最顶层呢个window
     * @return
     */
    public static List<ViewRootData> getFocusWindowRootView(WindowManager windowManager, boolean forceGetTop) {
        List<ViewRootData> list = new ArrayList<>();

        if(windowManager==null)
            return list;
        try {
            Object globalWindowManager;
            // for openSource
            if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.JELLY_BEAN) {
                globalWindowManager = ReflectUtils.reflect(windowManager).field("mWindowManager").get();
            } else {
                globalWindowManager = ReflectUtils.reflect(windowManager).field("mGlobal").get();
            }
            //所有的views

            //所有的DecorView
            Object rootObjects = ReflectUtils.reflect(globalWindowManager).field("mViews").get();
            //所有view对应的params
            Object paramsObject = ReflectUtils.reflect(globalWindowManager).field("mParams").get();

            View[] viewsObject;
            WindowManager.LayoutParams[] params;

            //面向开源
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                List<View> viewList = (List<View>) rootObjects;
                viewsObject = viewList.toArray(new View[viewList.size()]);
                List<WindowManager.LayoutParams> paramsList = (List<WindowManager.LayoutParams>) paramsObject;
                params = paramsList.toArray(new WindowManager.LayoutParams[paramsList.size()]);
            } else {
                viewsObject = (View[]) rootObjects;
                params = (WindowManager.LayoutParams[]) paramsObject;
            }


            if(forceGetTop){
                list.add(new ViewRootData(viewsObject[viewsObject.length - 1], null, params[viewsObject.length - 1]));
            } else {
                for (int i = 0; i < viewsObject.length; i++) {
                    Object attachInfo = ReflectUtils.reflect(viewsObject[i]).field("mAttachInfo").get();
                    Boolean hasFocus = ReflectUtils.reflect(attachInfo).field("mHasWindowFocus").get();
                    if (hasFocus) {
                        list.add(new ViewRootData(viewsObject[i], null, params[i]));
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    /**
     * 打印视图树
     *
     * @param view  根View
     * @param index 根布局传0即可
     */
    public static void printViewTree(Object view, int index) {
        StringBuilder builder = new StringBuilder("--");
        for (int a = 0; a < index; a++) {
            builder.append(" -- ");
        }
        builder.append(Utils.simpleName(view));
        Logger.d(builder.toString());
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup) view;
            int count = viewGroup.getChildCount();
            index++;
            for (int i = 0; i < count; i++) {
                printViewTree(viewGroup.getChildAt(i), index);
            }
        }
    }


    /**
     * 根View所在的窗口大小以及位置
     */
    public static class ViewRootData {
        final View view;
        private final Rect winFrame;
        private final WindowManager.LayoutParams layoutParams;

        public ViewRootData(View view, Rect winFrame, WindowManager.LayoutParams layoutParams) {
            this.view = view;
            this.winFrame = winFrame;
            this.layoutParams = layoutParams;
        }

        public View getView() {
            return view;
        }

        public Rect getWinFrame() {
            return winFrame;
        }

        public WindowManager.LayoutParams getLayoutParams() {
            return layoutParams;
        }

        public boolean isDialogType() {
            return layoutParams.type == WindowManager.LayoutParams.TYPE_APPLICATION;
        }

        public boolean isActivityType() {
            return layoutParams.type == WindowManager.LayoutParams.TYPE_BASE_APPLICATION;
        }

        public Context context() {
            return view.getContext();
        }
    }

}
