/*
 * Decompiled with CFR 0.152.
 */
package com.dada.smart.common;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.dada.smart.common.ResourceIds;
import com.dada.smart.common.ResourceReader;
import com.dada.smart.common.UIThreadObject;
import com.dada.smart.common.Utils;
import java.util.ArrayList;
import java.util.List;

public abstract class ActivityMonitor
implements Application.ActivityLifecycleCallbacks {
    private UIThreadObject<Activity> uiThreadObject;
    private List<String> classes = new ArrayList<String>();
    private ResourceIds mResourceIds;
    private Context context;
    private boolean debug;

    public ActivityMonitor(Context context, boolean debug) {
        this.debug = debug;
        this.context = context.getApplicationContext();
        this.mResourceIds = new ResourceReader.Ids(context.getPackageName(), context);
        this.uiThreadObject = new UIThreadObject();
        Application app = (Application)this.context;
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ResourceIds getResourceIds() {
        return this.mResourceIds;
    }

    public Context getContext() {
        return this.context;
    }

    protected UIThreadObject<Activity> uiThreadObject() {
        return this.uiThreadObject;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.uiThreadObject.set(activity);
        this.classes.add(Utils.canonicalName(activity));
        if (this.classes.size() > 2) {
            this.classes.remove(0);
        }
    }

    public String getLastPageClass() {
        return this.classes.size() == 2 ? this.classes.get(0) : "";
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        this.uiThreadObject.set(activity);
    }

    public void onActivityPaused(Activity activity) {
        this.uiThreadObject.set(null);
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

