/*
 * Decompiled with CFR 0.152.
 */
package com.dada.response.watcher.watcher;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.dada.response.watcher.util.ResponseWatchDebug;
import com.dada.response.watcher.watcher.ResponseConfig;
import com.dada.response.watcher.watcher.ResponseHelper;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ResponseLoop {
    private static final String TAG = "ResponseLoop";
    private static final int Response_WHAT = 1;
    private static boolean isStopResponseLoop = false;
    private HandlerThread mHandlerThread;
    private Handler responseHandler;
    private SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private static ResponseLoop instance;

    public static ResponseLoop getInstance() {
        if (null == instance) {
            instance = new ResponseLoop();
        }
        return instance;
    }

    public void init() {
        try {
            ResponseWatchDebug.d("whh", "ResponseLoop init");
            if (null == this.mHandlerThread) {
                this.mHandlerThread = new HandlerThread(TAG);
            }
            this.mHandlerThread.start();
            this.responseHandler = new Handler(this.mHandlerThread.getLooper()){

                public void handleMessage(Message msg) {
                    try {
                        super.handleMessage(msg);
                        if (isStopResponseLoop) {
                            return;
                        }
                        if (1 == msg.what) {
                            ResponseWatchDebug.d("whh", "ResponseLoop \u6267\u884c\u4e86 at " + ResponseLoop.this.sim.format(System.currentTimeMillis()));
                            ResponseLoop.this.executor.execute(() -> ResponseHelper.getInstance().saveAndUpload());
                            ResponseLoop.this.startResponseLoop();
                        }
                    }
                    catch (Exception e) {
                        ResponseWatchDebug.d(ResponseLoop.TAG, "handleMessage Exception " + e.getMessage());
                    }
                }
            };
        }
        catch (Exception e) {
            ResponseWatchDebug.d(TAG, "init Exception " + e.getMessage());
        }
    }

    public void startResponseLoop() {
        ResponseWatchDebug.d("whh", "ResponseLoop startResponseLoop");
        if (null == this.mHandlerThread || null == this.responseHandler) {
            return;
        }
        ResponseWatchDebug.d("whh", "ResponseLoop real startResponseLoop");
        this.responseHandler.sendEmptyMessageDelayed(1, (long)(ResponseConfig.TRAVEL_TIME * 1000));
    }

    public void stopResponseLoop() {
        isStopResponseLoop = true;
        ResponseWatchDebug.d("whh", "stopResponseLoop ok");
    }
}

