/*
 * Decompiled with CFR 0.152.
 */
package com.dada.response.watcher.interceptor;

import android.text.TextUtils;
import com.dada.response.watcher.util.ArrayUtils;
import com.dada.response.watcher.util.StringUtil;
import com.dada.response.watcher.watcher.ResponseConfig;
import com.dada.response.watcher.watcher.ResponseHelper;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ResponseInterceptor
implements Interceptor {
    private static final ResponseInterceptor instance = new ResponseInterceptor();

    public static ResponseInterceptor getInstance() {
        return instance;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        long startNs = System.nanoTime();
        Request request = chain.request();
        String uri = request.url().url().getPath();
        if (!this.isMatchFilterUrl(uri)) {
            return chain.proceed(request);
        }
        Response response = null;
        String status = "";
        String domain = request.url().host();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            if (e instanceof InterruptedIOException) {
                status = "TimeoutException";
            }
            if (e instanceof UnknownHostException) {
                status = "UnknownHostException";
            }
            if (e instanceof SSLException) {
                status = "SSLException";
            }
            if (e instanceof ConnectException) {
                status = "ConnectException";
            }
            if (!StringUtil.isEmpty(domain)) {
                long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
                ResponseHelper.getInstance().addWatchedData(domain, uri, status, tookMs);
            }
            throw e;
        }
        if (!StringUtil.isEmpty(domain)) {
            long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            status = String.valueOf(response.code());
            if (!TextUtils.isEmpty((CharSequence)status) && !"0".equals(status)) {
                ResponseHelper.getInstance().addWatchedData(domain, uri, status, tookMs);
            }
        }
        return response;
    }

    private boolean isMatchFilterUrl(String urlPathToMatch) {
        List<String> filterList;
        String matchPath = urlPathToMatch;
        if (!urlPathToMatch.endsWith("/")) {
            matchPath = urlPathToMatch + "/";
        }
        if (ArrayUtils.isEmpty(filterList = ResponseConfig.WATCHED_PATHS)) {
            return false;
        }
        for (String s : filterList) {
            if (!s.endsWith("/")) {
                s = s + "/";
            }
            if (!s.equals(matchPath)) continue;
            return true;
        }
        return false;
    }
}

