package com.dada.response.watcher.interceptor;

import android.text.TextUtils;

import com.dada.response.watcher.util.ArrayUtils;
import com.dada.response.watcher.util.StringUtil;
import com.dada.response.watcher.watcher.ResponseConfig;
import com.dada.response.watcher.watcher.ResponseHelper;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.net.ssl.SSLException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * Created by whh on 2019/6/20
 */
public class ResponseInterceptor implements Interceptor {
    private static final ResponseInterceptor instance = new ResponseInterceptor();

    public static ResponseInterceptor getInstance() {
        return instance;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        long startNs = System.nanoTime();
        Request request = chain.request();
        String uri = request.url().url().getPath();

        if (!isMatchFilterUrl(uri)) {
            return chain.proceed(request);
        }

        //是我们要监听的接口 List
        Response response = null;
        String status = "";
        String domain = request.url().host();

        try {
            response = chain.proceed(request);
        } catch (Exception e) {
            //这几个 Exception 是互斥的
            if (e instanceof InterruptedIOException) {//socketTimeout 和 connectTime, 属于 timeout 类
                status = "TimeoutException";
            }

            if (e instanceof UnknownHostException) {//属于 UnknownHostException
                status = "UnknownHostException";
            }

            if (e instanceof SSLException) {//属于 ssl 异常，包括握手连接等
                status = "SSLException";
            }

            if (e instanceof ConnectException) {//断网
                status = "ConnectException";
            }

            if (!StringUtil.isEmpty(domain)) {
                long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
                //加入监听
                ResponseHelper.getInstance().addWatchedData(domain, uri, status, tookMs);
            }

            throw e;
        }

        if (!StringUtil.isEmpty(domain)) {
            long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            status = String.valueOf(response.code());
            //ios 端出现很多 0 的 status
            if (!TextUtils.isEmpty(status) && !("0".equals(status))) {
                //加入监听
                ResponseHelper.getInstance().addWatchedData(domain, uri, status, tookMs);
            }
        }
        return response;
    }

    private boolean isMatchFilterUrl(final String urlPathToMatch) {
        String matchPath = urlPathToMatch;
        if (!urlPathToMatch.endsWith("/")) {
            matchPath = urlPathToMatch + "/";
        }

        List<String> filterList = ResponseConfig.WATCHED_PATHS;
        if (ArrayUtils.isEmpty(filterList))
            return false;

        for (String s : filterList) {
            if (!s.endsWith("/")) {
                s += "/";
            }

            if (s.equals(matchPath))
                return true;
        }
        return false;
    }
}
