package com.dada.response.watcher.entity;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by whh on 2019/5/31
 */

public class NetStatusCache implements Cloneable {

    public Map<String, Fields> statusMap = new HashMap<>();

    public static class Fields implements Cloneable {
        private long count;
        private long sum;

        public long getCount() {
            return count;
        }

        public NetStatusCache.Fields setCount(long count) {
            this.count = count;
            return this;
        }

        public long getSum() {
            return sum;
        }

        public NetStatusCache.Fields setSum(long sum) {
            this.sum = sum;
            return this;
        }

        @Override
        public String toString() {
            return " count: " + count + " Sum: " + sum;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NetStatusCache statusCache = (NetStatusCache) super.clone();

        Map<String, Fields> statusCopy = new HashMap<>();
        for (Map.Entry<String, Fields> status : statusMap.entrySet()) {
            Fields fields = (Fields) status.getValue().clone();
            statusCopy.put(status.getKey(), fields);
        }
        statusCache.statusMap = statusCopy;
        return statusCache;
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder();

        for (String key : statusMap.keySet()) {
            output.append("\n[").append(key).append("->").append(statusMap.get(key)).append("]");
        }

        return output.toString();
    }
}
