package com.dada.response.watcher.watcher;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;

import com.dada.response.watcher.util.ResponseWatchDebug;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import static com.dada.response.watcher.watcher.ResponseConfig.TRAVEL_TIME;

/**
 * Created by whh on 2019/9/12
 * 用于 HandlerThread 的轮询
 * 初始化需要在 Application 中
 */
public class ResponseLoop {
    private static final String TAG = "ResponseLoop";
    private static final int Response_WHAT = 1;
    private static boolean isStopResponseLoop = false;

    private HandlerThread mHandlerThread;
    private Handler responseHandler;//执行发送请求的 handler
    private SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    private static ResponseLoop instance;

    public static ResponseLoop getInstance() {
        if (null == instance) {
            instance = new ResponseLoop();
        }
        return instance;
    }

    /**
     * 初始化需要在 Application 中
     */
    public void init() {
        try {
            ResponseWatchDebug.d("whh", "ResponseLoop init");
            if (null == mHandlerThread) {
                this.mHandlerThread = new HandlerThread("ResponseLoop");
            }
            mHandlerThread.start();
            responseHandler = new Handler(mHandlerThread.getLooper()) {
                @Override
                public void handleMessage(Message msg) {
                    try {
                        super.handleMessage(msg);
                        if (isStopResponseLoop)
                            return;

                        if (Response_WHAT == msg.what) {
                            ResponseWatchDebug.d("whh", "ResponseLoop 执行了 at " + sim.format(System.currentTimeMillis()));
                            executor.execute(() -> ResponseHelper.getInstance().saveAndUpload());
                            startResponseLoop();
                        }
                    } catch (Exception e) {
                        ResponseWatchDebug.d(TAG, "handleMessage Exception " + e.getMessage());
                    }
                }
            };
        } catch (Exception e) {
            ResponseWatchDebug.d(TAG, "init Exception " + e.getMessage());
        }
    }

    public void startResponseLoop() {
        ResponseWatchDebug.d("whh", "ResponseLoop startResponseLoop");
        if (null == mHandlerThread || null == responseHandler)
            return;
        ResponseWatchDebug.d("whh", "ResponseLoop real startResponseLoop");
        responseHandler.sendEmptyMessageDelayed(Response_WHAT, TRAVEL_TIME * 1000);
    }

    /**
     * 停止 worker
     */
    public void stopResponseLoop() {
        isStopResponseLoop = true;
        ResponseWatchDebug.d("whh", "stopResponseLoop ok");
    }
}
