/*
 * Decompiled with CFR 0.152.
 */
package com.dada.response.watcher.watcher;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.work.ListenableWorker;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.dada.response.watcher.util.ResponseWatchDebug;
import com.dada.response.watcher.watcher.ResponseConfig;
import com.dada.response.watcher.watcher.ResponseHelper;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class ResponseWorker
extends Worker {
    private static final String WORKMANAGER_TAG = "response_tag";
    public static boolean isStopWork = false;
    private static Context context;

    public ResponseWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    @NonNull
    public ListenableWorker.Result doWork() {
        try {
            SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
            ResponseWatchDebug.d("whh", "ResponseWorker \u6267\u884c\u4e86 at " + sim.format(System.currentTimeMillis()));
            ResponseHelper.getInstance().saveAndUpload();
            Thread.sleep(ResponseConfig.TRAVEL_TIME * 1000);
            if (!isStopWork) {
                ResponseWorker.startResponseWatchWorker(context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ResponseWatchDebug.d("whh", "doWork " + e.getMessage());
        }
        return ListenableWorker.Result.success();
    }

    public static void startResponseWatchWorker(Context context) {
        if (null == context) {
            return;
        }
        isStopWork = false;
        ResponseWorker.context = context;
        try {
            WorkManager workManager = WorkManager.getInstance((Context)context);
            OneTimeWorkRequest responseRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(ResponseWorker.class).addTag(WORKMANAGER_TAG)).build();
            workManager.enqueue((WorkRequest)responseRequest);
            ResponseWatchDebug.d("whh", "startResponseWatchWorker ok");
        }
        catch (Exception e) {
            e.printStackTrace();
            ResponseWatchDebug.d("whh", "startResponseWatchWorker " + e.getMessage());
        }
    }

    public static void stopResponseWatchWorker() {
        isStopWork = true;
        ResponseWatchDebug.d("whh", "stopResponseWatchWorker ok");
    }
}

