/*
 * Decompiled with CFR 0.152.
 */
package com.dc.spannablehelper.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJP\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J2\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/dc/spannablehelper/span/CenterVerticalImageSpan;", "Landroid/text/style/ImageSpan;", "drawable", "Landroid/graphics/drawable/Drawable;", "verticalAlignment", "", "marginLeft", "", "marginRight", "(Landroid/graphics/drawable/Drawable;IFF)V", "draw", "", "canvas", "Landroid/graphics/Canvas;", "text", "", "start", "end", "x", "top", "y", "bottom", "paint", "Landroid/graphics/Paint;", "getSize", "fontMetricsInt", "Landroid/graphics/Paint$FontMetricsInt;", "spannablehelper_release"})
public final class CenterVerticalImageSpan
extends ImageSpan {
    private final float marginLeft;
    private final float marginRight;

    public int getSize(@NotNull Paint paint, @NotNull CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fontMetricsInt) {
        Drawable drawable;
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Drawable drawable2 = drawable = this.getDrawable();
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"drawable");
        Rect rect = drawable2.getBounds();
        if (fontMetricsInt != null) {
            Paint.FontMetricsInt fmPaint = paint.getFontMetricsInt();
            int fontHeight = fmPaint.descent - fmPaint.ascent;
            int drHeight = rect.bottom - rect.top;
            int centerY = fmPaint.ascent + fontHeight / 2;
            fontMetricsInt.top = fontMetricsInt.ascent = centerY - drHeight / 2;
            fontMetricsInt.descent = fontMetricsInt.bottom = centerY + drHeight / 2;
        }
        return (int)((float)rect.right + this.marginLeft + this.marginRight);
    }

    public void draw(@NotNull Canvas canvas, @NotNull CharSequence text, int start, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        Drawable drawable = this.getDrawable();
        canvas.save();
        Paint.FontMetricsInt fmPaint = paint.getFontMetricsInt();
        int fontHeight = fmPaint.descent - fmPaint.ascent;
        int centerY = y + fmPaint.descent - fontHeight / 2;
        Drawable drawable2 = drawable;
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"drawable");
        int transY = centerY - (drawable2.getBounds().bottom - drawable.getBounds().top) / 2;
        canvas.translate(x + this.marginLeft, (float)transY);
        drawable.draw(canvas);
        canvas.restore();
    }

    public CenterVerticalImageSpan(@NotNull Drawable drawable, int verticalAlignment, float marginLeft, float marginRight) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        super(drawable, verticalAlignment);
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
    }
}

