/*
 * Decompiled with CFR 0.152.
 */
package com.daandtu.webscraper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.http.SslCertificate;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.daandtu.webscraper.Element;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;

@SuppressLint(value={"SetJavaScriptEnabled,unused,Deprecation"})
public class WebScraper {
    private Context context;
    private WebView web;
    private String URL;
    private String userAgent;
    private PageLoadedListener pageLoadedListener;
    private WaitForHtml HtmlListener;
    private List<Task> tasks = new ArrayList<Task>();
    public static int MAX = -1;

    public WebScraper(Context context) {
        this.context = context;
        this.web = new WebView(context);
        if (Build.VERSION.SDK_INT >= 21) {
            WebView.enableSlowWholeDocumentDraw();
        }
        this.web.getSettings().setJavaScriptEnabled(true);
        this.web.getSettings().setBlockNetworkImage(true);
        this.web.getSettings().setLoadsImagesAutomatically(false);
        JSInterface jInterface = new JSInterface(context);
        this.web.addJavascriptInterface((Object)jInterface, "HtmlViewer");
        this.userAgent = this.web.getSettings().getUserAgentString();
        this.web.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                if (WebScraper.this.pageLoadedListener != null) {
                    WebScraper.this.URL = url;
                    WebScraper.this.pageLoadedListener.loaded(url);
                    WebScraper.this.pageLoadedListener = null;
                }
                WebScraper.this.web.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                WebScraper.this.web.layout(0, 0, WebScraper.this.web.getMeasuredWidth(), WebScraper.this.web.getMeasuredHeight());
                WebScraper.this.web.setDrawingCacheEnabled(true);
            }
        });
    }

    public View getView() {
        return this.web;
    }

    public void execute(WebTaskListener webTaskListener) {
        Handler handler = new Handler();
        int[] count = new int[]{0};
        Hashtable<String, String> result = new Hashtable<String, String>();
        Log.i((String)"Webscraper", (String)"Starting execution");
        TaskListener taskListener = () -> {
            Log.i((String)"Webscraper", (String)("Task Nr.: " + String.valueOf(count[0])));
            if (count[0] < this.tasks.size() - 1) {
                count[0] = count[0] + 1;
                handler.post((Runnable)this.tasks.get(count[0]));
            } else {
                webTaskListener.finished(result);
            }
        };
        for (Task task : this.tasks) {
            task.set(taskListener, result);
        }
        handler.post((Runnable)this.tasks.get(0));
    }

    protected void addTask(final String javascript, final boolean storeResult, final String key) {
        this.tasks.add(new Task(){

            @Override
            public void run() {
                WebScraper.this.web.evaluateJavascript(javascript, s -> {
                    if (storeResult) {
                        this.result.put(key, s.substring(1, s.length() - 1));
                    }
                    this.taskListener.done();
                });
            }
        });
    }

    protected void addTask(String javascript) {
        this.addTask(javascript, false, null);
    }

    public void waitForElement(Element element, int timeout) {
        final String js = "javascript:document.body.contains(" + element.getElement() + ")";
        for (int i = 0; i < timeout / 300; ++i) {
            this.tasks.add(new Task(){

                @Override
                public void run() {
                    WebScraper.this.web.evaluateJavascript(js, s -> {
                        if (s.equals("false")) {
                            this.waitTime(300);
                        }
                        this.taskListener.done();
                    });
                }
            });
        }
    }

    public void waitTime(final int millis) {
        this.tasks.add(new Task(){

            @Override
            public void run() {
                this.waitTime(millis);
            }
        });
    }

    public void waitForPage() {
        this.tasks.add(new Task(){

            @Override
            public void run() {
                WebScraper.this.pageLoadedListener = url -> this.taskListener.done();
            }
        });
    }

    public void loadURL(final String Url) {
        this.tasks.add(new Task(){

            @Override
            public void run() {
                WebScraper.this.web.loadUrl(Url);
                WebScraper.this.pageLoadedListener = url -> this.taskListener.done();
            }
        });
    }

    public void reload() {
        this.tasks.add(new Task(){

            @Override
            public void run() {
                WebScraper.this.web.reload();
                WebScraper.this.pageLoadedListener = url -> this.taskListener.done();
            }
        });
    }

    public void reload(PageLoadedListener listener) {
        this.web.reload();
        this.pageLoadedListener = listener;
    }

    public void getHtml(WaitForHtml htmlListener) {
        this.web.evaluateJavascript("javascript:window.HtmlViewer.showHTML(document.getElementsByTagName('html')[0].innerHTML);", null);
        this.HtmlListener = htmlListener;
    }

    public void loadURL(String URL, PageLoadedListener listener) {
        this.URL = URL;
        this.web.loadUrl(URL);
        this.pageLoadedListener = listener;
    }

    public String getWebsiteTitle() {
        return this.web.getTitle();
    }

    public String getURL() {
        return this.web.getUrl();
    }

    public Bitmap getFavicon() {
        return this.web.getFavicon();
    }

    public SslCertificate getSslCertificate() {
        return this.web.getCertificate();
    }

    public void setUserAgentToDesktop(boolean desktop) {
        if (desktop) {
            String osString = this.userAgent.substring(this.userAgent.indexOf("("), this.userAgent.indexOf(")") + 1);
            this.web.getSettings().setUserAgentString(this.userAgent.replace(osString, "(X11; Linux x86_64)"));
        } else {
            this.web.getSettings().setUserAgentString(this.userAgent);
        }
    }

    public void setLoadImages(boolean enabled) {
        this.web.getSettings().setBlockNetworkImage(!enabled);
        this.web.getSettings().setLoadsImagesAutomatically(enabled);
    }

    public Bitmap takeScreenshot() {
        return this.takeScreenshot(MAX, MAX);
    }

    public Bitmap takeScreenshot(int width, int height) {
        try {
            if (width < 0 || height < 0) {
                this.web.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            }
            if (width < 0) {
                width = this.web.getMeasuredWidth();
            }
            if (height < 0) {
                height = this.web.getMeasuredHeight();
            }
            this.web.layout(0, 0, width, height);
            this.web.setDrawingCacheEnabled(true);
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return Bitmap.createBitmap((Bitmap)this.web.getDrawingCache());
        }
        catch (NullPointerException ignored) {
            return null;
        }
    }

    public int getMaxHeight() {
        this.web.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        return this.web.getMeasuredHeight();
    }

    public int getMaxWidth() {
        this.web.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        return this.web.getMeasuredWidth();
    }

    public void clearHistory() {
        this.web.clearHistory();
    }

    public void clearCache() {
        this.web.clearCache(true);
    }

    public void clearCookies() {
        if (Build.VERSION.SDK_INT >= 22) {
            CookieManager.getInstance().removeAllCookies(null);
            CookieManager.getInstance().flush();
        } else {
            CookieSyncManager cookieSync = CookieSyncManager.createInstance((Context)this.context);
            cookieSync.startSync();
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.removeAllCookie();
            cookieManager.removeSessionCookie();
            cookieSync.stopSync();
            cookieSync.sync();
        }
    }

    public void clearAll() {
        this.clearHistory();
        this.clearCache();
        this.clearCookies();
    }

    public Element findElementsByClassName(String classname, int id2) {
        return new Element(this, 3, classname, id2);
    }

    public Element findElementByClassName(String classname) {
        return this.findElementsByName(classname, 0);
    }

    public Element findElementById(String id2) {
        return new Element(this, 4, id2, 0);
    }

    public Element findElementsByName(String name, int id2) {
        return new Element(this, 1, name, id2);
    }

    public Element findElementByName(String name) {
        return this.findElementsByName(name, 0);
    }

    public Element findElementByXpath(String xpath) {
        return new Element(this, 2, xpath, 0);
    }

    public Element findElementByCustomJavascript(String javascript) {
        return new Element(this, 0, javascript, 0);
    }

    public Element findElementsByAttribute(String attribute, String value, int count) {
        return new Element(this, 9, attribute + "=" + value, count);
    }

    public Element findElementByAttribute(String attribute, String value) {
        return this.findElementsByAttribute(attribute, value, 0);
    }

    public Element findElementsByValue(String value, int id2) {
        return new Element(this, 5, value, id2);
    }

    public Element findElementByInnerHtml(String innerHtml, String type) {
        return new Element(this, 10, "//" + type + "[contains(text(), '" + innerHtml + "')]", 0);
    }

    public Element findElementByValue(String value) {
        return this.findElementsByValue(value, 0);
    }

    public Element findElementsByTitle(String title, int id2) {
        return new Element(this, 6, title, id2);
    }

    public Element findElementByTitle(String title) {
        return this.findElementsByTitle(title, 0);
    }

    public Element findElementsByTagName(String tagName, int id2) {
        return new Element(this, 7, tagName, id2);
    }

    public Element findElementByTagName(String tagName) {
        return this.findElementsByTagName(tagName, 0);
    }

    public Element findElementsByType(String type, int id2) {
        return new Element(this, 8, type, id2);
    }

    public Element findElementByType(String type) {
        return this.findElementsByType(type, 0);
    }

    private abstract class Task
    implements Runnable {
        TaskListener taskListener;
        Dictionary<String, String> result;

        private Task() {
        }

        public void set(TaskListener taskListener, Dictionary<String, String> result) {
            this.taskListener = taskListener;
            this.result = result;
        }

        public void waitTime(int time) {
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static interface TaskListener {
        public void done();
    }

    public static interface WebTaskListener {
        public void finished(Dictionary<String, String> var1);
    }

    public static interface WaitForHtml {
        public void gotHtml(String var1);
    }

    public static interface PageLoadedListener {
        public void loaded(String var1);
    }

    private class JSInterface {
        private Context ctx;

        JSInterface(Context ctx) {
            this.ctx = ctx;
        }

        @JavascriptInterface
        public void showHTML(String html) {
            if (WebScraper.this.HtmlListener != null) {
                WebScraper.this.HtmlListener.gotHtml(html);
            }
        }
    }
}

