/*
 * Decompiled with CFR 0.152.
 */
package com.daandtu.webscraper;

import com.daandtu.webscraper.WebScraper;

public class Element {
    private String elementLocator;
    private int type;
    private int count;
    private WebScraper web;
    public static final int NAME = 1;
    public static final int XPATH = 2;
    public static final int CLASS = 3;
    public static final int ID = 4;
    public static final int VALUE = 5;
    public static final int TITLE = 6;
    public static final int TAG = 7;
    public static final int TYPE = 8;
    public static final int ATTRIBUTE = 9;
    public static final int HTML = 10;
    public static final int CUSTOM = 0;

    public Element(WebScraper web, int type, String elementLocator, int count) {
        this.web = web;
        this.elementLocator = elementLocator;
        this.type = type;
        this.count = count;
    }

    protected String getElement() {
        switch (this.type) {
            case 1: {
                return "document.getElementsByName(\"" + this.elementLocator + "\")[" + this.count + "]";
            }
            case 2: {
                return "document.evaluate(\"" + this.elementLocator + "\", document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue";
            }
            case 3: {
                return "document.getElementsByClassName(\"" + this.elementLocator + "\")[" + this.count + "]";
            }
            case 4: {
                return "document.getElementById(\"" + this.elementLocator + "\")";
            }
            case 5: {
                return "document.querySelectorAll(\"[value=" + this.elementLocator + "]\")[" + this.count + "]";
            }
            case 6: {
                return "document.querySelectorAll(\"[title=" + this.elementLocator + "]\")[" + this.count + "]";
            }
            case 7: {
                return "document.getElementsByTagName(\"" + this.elementLocator + "\")";
            }
            case 8: {
                return "document.querySelectorAll(\"[type=" + this.elementLocator + "]\")[" + this.count + "]";
            }
            case 9: {
                return "document.querySelectorAll(\"[" + this.elementLocator + "]\")[" + this.count + "]";
            }
            case 10: {
                return "document.evaluate(\"" + this.elementLocator + "\", document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue";
            }
            case 0: {
                return this.elementLocator;
            }
        }
        return null;
    }

    public void setAttribute(String attribute, String value) {
        this.web.addTask("javascript:" + this.getElement() + ".setAttribute(\"" + attribute + "\",\"" + value + "\");void(0);");
    }

    public void setText(String text) {
        this.web.addTask("javascript:" + this.getElement() + ".innerHTML = \"" + text + "\";void(0);");
    }

    public void inputText(String text) {
        this.setAttribute("value", text);
    }

    public void setBackgroundColor(String color) {
        this.web.addTask("javascript:" + this.getElement() + ".style.backgroundColor = \"" + color + "\";void(0);");
    }

    public void click() {
        this.web.addTask("javascript:" + this.getElement() + ".click();void(0);");
    }

    public void getAttribute(String attribute, String key) {
        this.web.addTask(this.getElement() + "." + attribute, true, key);
    }

    public void getName(String key) {
        this.getAttribute("name", key);
    }

    public void getTitle(String key) {
        this.getAttribute("title", key);
    }

    public void getText(String key) {
        this.getAttribute("innerHTML", key);
    }

    public void getValue(String key) {
        this.getAttribute("value", key);
    }
}

