package com.daandtu.webscraper;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;

public class MainTest extends Activity {

    Context context;
    RelativeLayout layout;
    ImageView imageView;
    WebScraper webScraper;

    boolean changed = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main_test);
        context = this;
        layout = findViewById(R.id.layout);
        webScraper = new WebScraper(context);
        webScraper.setLoadImages(true);
        layout.addView(webScraper.getView());

        webScraper.loadURL("https://www.google.com/");
        Element search = webScraper.findElementByName("q");
        search.inputText("Test");
        search.setBackgroundColor("#6895B4");
        Element text = webScraper.findElementById("fsettl");
        Element el = webScraper.findElementByXpath("//a[contains(text(), 'Datenschutzerklärung')]");
        el.setBackgroundColor("black");
        text.setText("Hallo");
        text.getAttribute("href","Link");
        text.setBackgroundColor("red");
        Element element = webScraper.findElementByAttribute("aria-label","Google-Suche");
        //element.click();
        Element btn = webScraper.findElementByAttribute("aria-label","Google");
        webScraper.waitForElement(btn, 5000);
        btn.click();
        webScraper.execute(result -> {
            Log.i("Webscraper", "Done webtask");
            Log.i("Webscraper", result.get("Link"));
        });
    }

    public void button(View v){
        if (changed){
            v.setBackgroundColor(Color.GRAY);
        }else{
            v.setBackgroundColor(Color.BLUE);
        }
        changed = !changed;
    }
}