/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.repo;

import com.d3x.core.repo.Repo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RepoMaster {
    private final Map<Class<?>, Repo> repoMap = new HashMap();

    public RepoMaster(Collection<Repo<?>> repos) {
        repos.forEach(repo -> {
            Class type = repo.getType();
            if (this.repoMap.containsKey(type)) {
                throw new RuntimeException("Duplicate repos for type: " + type);
            }
            this.repoMap.put(type, (Repo)repo);
        });
    }

    public synchronized <T> void registerIfAbsent(Repo<T> repo) {
        Class<T> type = repo.getType();
        Repo existing = this.repoMap.get(type);
        if (existing == null) {
            this.repoMap.put(type, repo);
        }
    }

    public <T> Repo<T> repo(Class<T> type) {
        Repo repo = this.repoMap.get(type);
        if (repo != null) {
            return repo;
        }
        throw new RuntimeException("No Repo register for type: " + type);
    }
}

