/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.db;

import com.d3x.core.db.Database;
import com.d3x.core.db.DatabaseException;
import com.d3x.core.db.DatabaseMapping;
import com.d3x.core.db.DatabaseUtils;
import com.d3x.core.util.IO;
import com.d3x.core.util.Option;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseUpdate<T> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseUpdate.class);
    private Type type;
    private Database db;
    private boolean verbose;
    private Class<T> dataType;
    private Option<String> sql;
    private int batchSize = 1000;
    private Option<DatabaseMapping.Binder<T>> binder;

    DatabaseUpdate(Database db, Class<T> dataType, Type type) {
        this.db = db;
        this.type = type;
        this.dataType = dataType;
        this.sql = Option.empty();
        this.binder = Option.empty();
    }

    public DatabaseUpdate<T> sql(String sql) {
        this.sql = Option.of((Object)sql);
        return this;
    }

    public DatabaseUpdate<T> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public DatabaseUpdate<T> binder(DatabaseMapping.Binder<T> binder) {
        this.binder = Option.of(binder);
        return this;
    }

    public DatabaseUpdate<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public void apply(T record) {
        this.apply(Stream.of(record));
    }

    public int apply(Collection<T> records) {
        return this.execute(records.iterator(), this.resolveSql(), this.resolveBinder());
    }

    public int apply(Iterator<T> records) {
        return this.execute(records, this.resolveSql(), this.resolveBinder());
    }

    public int apply(Stream<T> records) {
        return this.execute(records.iterator(), this.resolveSql(), this.resolveBinder());
    }

    public Future<Integer> applyAsync(T record) {
        return this.applyAsync(Stream.of(record));
    }

    public Future<Integer> applyAsync(Stream<T> records) {
        return this.db.submit(() -> {
            try {
                return this.execute(records.iterator(), this.resolveSql(), this.resolveBinder());
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        });
    }

    private DatabaseMapping.Binder<T> resolveBinder() {
        return (DatabaseMapping.Binder)this.binder.orElse(() -> {
            DatabaseMapping<T> mapping = this.db.mapping(this.dataType);
            switch (this.type) {
                case INSERT: {
                    return mapping.insert();
                }
                case UPDATE: {
                    return mapping.update();
                }
                case DELETE: {
                    return mapping.delete();
                }
            }
            throw new DatabaseException("Unsupported update type: " + this.type);
        });
    }

    private String resolveSql() {
        return (String)this.sql.map(DatabaseUtils::loadSql).orElse(() -> {
            DatabaseMapping<T> mapping = this.db.mapping(this.dataType);
            switch (this.type) {
                case INSERT: {
                    return DatabaseMapping.getInsertSql(mapping);
                }
                case UPDATE: {
                    return DatabaseMapping.getUpdateSql(mapping);
                }
                case DELETE: {
                    return DatabaseMapping.getDeleteSql(mapping);
                }
            }
            throw new DatabaseException("Unsupported update type: " + this.type);
        });
    }

    private int execute(Iterator<T> iterator, String sql, DatabaseMapping.Binder<T> binder) {
        int n;
        long t1;
        PreparedStatement stmt;
        Connection conn;
        int count;
        block10: {
            count = 0;
            conn = null;
            stmt = null;
            t1 = System.currentTimeMillis();
            if (iterator.hasNext()) break block10;
            int n2 = 0;
            IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
            return n2;
        }
        try {
            conn = this.db.getConnection();
            stmt = conn.prepareStatement(sql);
            while (iterator.hasNext()) {
                ++count;
                T record = iterator.next();
                if (this.verbose) {
                    log.info("Binding SQL args from " + record + " to " + sql);
                }
                binder.bind(record, stmt);
                if (this.batchSize <= 0) {
                    stmt.executeUpdate();
                    continue;
                }
                stmt.addBatch();
                if (count % this.batchSize != 0) continue;
                stmt.executeBatch();
                if (!this.verbose && this.batchSize <= 1000) continue;
                long t2 = System.currentTimeMillis();
                log.info("Put " + count + " records into DB in " + (t2 - t1) + " millis");
            }
            if (this.batchSize > 0 && count > 0 && count % this.batchSize != 0) {
                stmt.executeBatch();
                if (this.verbose || this.batchSize > 1000) {
                    long t2 = System.currentTimeMillis();
                    log.info("Put " + count + " records into DB in " + (t2 - t1) + " millis");
                }
            }
            n = count;
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Failed to put one or records in database", ex);
            }
            catch (Throwable throwable) {
                IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
                throw throwable;
            }
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
        return n;
    }

    static enum Type {
        INSERT,
        UPDATE,
        DELETE;

    }
}

