/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.db;

import com.d3x.core.db.Database;
import com.d3x.core.db.DatabaseException;
import com.d3x.core.db.DatabaseMapping;
import com.d3x.core.db.DatabaseOperation;
import com.d3x.core.db.DatabaseUtils;
import com.d3x.core.util.IO;
import com.d3x.core.util.Option;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class DatabaseExecute
extends DatabaseOperation<DatabaseExecute> {
    DatabaseExecute(Database db, String sql) {
        super(db);
        this.sql(sql);
    }

    public Option<Integer> apply() throws DatabaseException {
        return this.apply((Multiple)null);
    }

    public Option<Integer> apply(Single handler) throws DatabaseException {
        return this.apply((int idx, ResultSet rs) -> handler.accept(rs));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<Integer> apply(Multiple handler) throws DatabaseException {
        Option option;
        Connection conn = null;
        PreparedStatement stmt = null;
        List<Object> args = this.getArgs();
        String sql = DatabaseUtils.loadSql((String)this.getSql().get());
        try {
            int records;
            conn = this.getDb().getConnection();
            stmt = DatabaseMapping.bindArgs(conn.prepareStatement(sql), args);
            stmt.setQueryTimeout((int)((Duration)this.getTimeout().orElse((Object)Duration.ofSeconds(30L))).toSeconds());
            stmt.setFetchSize((Integer)this.getFetchSize().orElse((Object)0));
            stmt.setMaxRows((Integer)this.getLimit().orElse((Object)0));
            boolean results = stmt.execute();
            if (results && handler != null) {
                AtomicInteger count = new AtomicInteger();
                ResultSet rs = stmt.getResultSet();
                handler.accept(0, rs);
                IO.close((AutoCloseable[])new AutoCloseable[]{rs});
                while (stmt.getMoreResults()) {
                    rs = stmt.getResultSet();
                    handler.accept(count.incrementAndGet(), rs);
                    IO.close((AutoCloseable[])new AutoCloseable[]{rs});
                }
            }
            option = (records = stmt.getUpdateCount()) < 0 ? Option.empty() : Option.of((Object)records);
        }
        catch (RuntimeException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new DatabaseException("Failed to execute sql: " + sql, ex2);
                }
            }
            catch (Throwable throwable) {
                IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
                throw throwable;
            }
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
        return option;
    }

    public static interface Multiple {
        public void accept(int var1, ResultSet var2) throws SQLException;
    }

    public static interface Single {
        public void accept(ResultSet var1) throws SQLException;
    }
}

