/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.db;

import com.d3x.core.db.DataSourceAdapter;
import com.d3x.core.db.DatabaseConfig;
import com.d3x.core.db.DatabaseException;
import com.d3x.core.db.DatabaseExecute;
import com.d3x.core.db.DatabaseMapping;
import com.d3x.core.db.DatabaseRecord;
import com.d3x.core.db.DatabaseSelect;
import com.d3x.core.db.DatabaseUpdate;
import com.d3x.core.db.DatabaseUtils;
import com.d3x.core.util.Consumers;
import com.d3x.core.util.IO;
import com.d3x.core.util.Lazy;
import com.d3x.core.util.LifeCycle;
import com.d3x.core.util.Option;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Database
extends LifeCycle.Base {
    private static final Logger log = LoggerFactory.getLogger(Database.class);
    private static DataSourceAdapter dataSourceAdapter = new DataSourceAdapter.Apache();
    private static Lazy<ExecutorService> executor = Lazy.of(() -> Executors.newFixedThreadPool(10));
    private DatabaseConfig config;
    private DataSource dataSource;
    private Consumers<Database> onStart = new Consumers();
    private Map<Type, DatabaseMapping<?>> mappingsMap = new HashMap();
    private ThreadLocal<Connection> connectionThreadLocal = new ThreadLocal();

    public Database(DatabaseConfig config) {
        Objects.requireNonNull(config, "The config supplier cannot be null");
        this.config = config;
        this.register(new DatabaseRecord.Mapping());
        this.register(new BasicMapping(-7));
        this.register(new BasicMapping(5));
        this.register(new BasicMapping(4));
        this.register(new BasicMapping(-5));
        this.register(new BasicMapping(6));
        this.register(new BasicMapping(8));
        this.register(new BasicMapping(12));
        this.register(new BasicMapping(91));
        this.register(new BasicMapping(92));
        this.register(new BasicMapping(93));
    }

    public static Database of(DatabaseConfig config) {
        return new Database(config);
    }

    public static Database of(DatabaseConfig config, Consumer<Database> setup) {
        Database database = new Database(config);
        if (setup != null) {
            setup.accept(database);
        }
        return database;
    }

    static Executor getExecutor() {
        return (Executor)executor.get();
    }

    public static void setExecutor(ExecutorService executor) {
        Database.executor = Lazy.of(() -> executor);
    }

    public static void setDataSourceAdapter(DataSourceAdapter dataSourceAdapter) {
        Database.dataSourceAdapter = dataSourceAdapter;
    }

    public DatabaseConfig getConfig() {
        return this.config;
    }

    public DataSource getDataSource() {
        return (DataSource)Option.of((Object)this.dataSource).orThrow("The database has not been started for: " + this.config.getUrl());
    }

    Connection getConnection() throws SQLException {
        Connection conn = this.connectionThreadLocal.get();
        if (conn != null) {
            return conn;
        }
        if (this.dataSource == null) {
            throw new DatabaseException("The database has not been started");
        }
        return this.dataSource.getConnection();
    }

    public Database onStart(Consumer<Database> onStart) {
        this.onStart.attach(onStart);
        return this;
    }

    protected void doStart() throws RuntimeException {
        try {
            log.info("Starting database named " + this.config.getUrl());
            this.dataSource = dataSourceAdapter.create(this.config);
            this.onStart.accept((Object)this);
        }
        catch (Exception ex) {
            throw new DatabaseException("Failed to start database component", ex);
        }
    }

    protected void doStop() throws RuntimeException {
        try {
            log.info("Stopping database named " + this.config.getUrl());
            dataSourceAdapter.close(this.dataSource);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean supports(Class<?> type) {
        return this.mappingsMap.containsKey(type);
    }

    public <T> void register(DatabaseMapping<T> mapping) {
        Objects.requireNonNull(mapping, "The mapper cannot be null");
        this.mappingsMap.put(mapping.type(), mapping);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tableExists(String tableName) {
        boolean bl;
        Connection conn;
        ResultSet rs;
        block6: {
            boolean bl2;
            rs = null;
            conn = null;
            try {
                conn = this.getDataSource().getConnection();
                DatabaseMetaData metaData = conn.getMetaData();
                HashSet<String> nameSet = new HashSet<String>(Arrays.asList(tableName, tableName.toLowerCase(), tableName.toUpperCase()));
                for (String name : nameSet) {
                    rs = metaData.getTables(null, null, name, null);
                    if (!rs.next()) continue;
                    bl = true;
                    break block6;
                }
                bl2 = false;
            }
            catch (SQLException ex) {
                try {
                    throw new DatabaseException(ex.getMessage(), ex);
                }
                catch (Throwable throwable) {
                    IO.close((AutoCloseable[])new AutoCloseable[]{rs, conn});
                    throw throwable;
                }
            }
            IO.close((AutoCloseable[])new AutoCloseable[]{rs, conn});
            return bl2;
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{rs, conn});
        return bl;
    }

    public int count(String sql, Object ... args) {
        int n;
        ResultSet rs = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        TimeZone timeZone = TimeZone.getDefault();
        String sqlExpression = DatabaseUtils.loadSql(sql);
        try {
            conn = this.getDataSource().getConnection();
            stmt = conn.prepareStatement(sqlExpression);
            DatabaseMapping.bindArgs(stmt, timeZone, Arrays.asList(args));
            rs = stmt.executeQuery();
            n = rs.next() ? rs.getInt(1) : 0;
        }
        catch (Exception ex) {
            try {
                throw new DatabaseException("Failed to execute sql: " + sqlExpression, ex);
            }
            catch (Throwable throwable) {
                IO.close((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
                throw throwable;
            }
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
        return n;
    }

    public DatabaseExecute exec(String sql) {
        return new DatabaseExecute(this, sql);
    }

    public Option<Integer> execute(String sql) throws DatabaseException {
        return this.execute(sql, (Option<Consumer<ResultSet>>)Option.empty());
    }

    public Option<Integer> execute(String sql, Option<Consumer<ResultSet>> handler) throws DatabaseException {
        Option option;
        Connection conn = null;
        Statement stmt = null;
        String sqlExpression = DatabaseUtils.loadSql(sql);
        try {
            int count;
            conn = this.getDataSource().getConnection();
            stmt = conn.createStatement();
            boolean results = stmt.execute(sqlExpression);
            if (results && handler.isPresent()) {
                ((Consumer)handler.get()).accept(stmt.getResultSet());
                while (stmt.getMoreResults()) {
                    ((Consumer)handler.get()).accept(stmt.getResultSet());
                }
            }
            option = (count = stmt.getUpdateCount()) < 0 ? Option.empty() : Option.of((Object)count);
        }
        catch (Exception ex) {
            try {
                throw new DatabaseException("Faile d to execute sql: " + sqlExpression, ex);
            }
            catch (Throwable throwable) {
                IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
                throw throwable;
            }
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
        return option;
    }

    public int executeUpdate(String sql, Object ... args) {
        return this.executeUpdate(sql, TimeZone.getDefault(), args);
    }

    public int executeUpdate(String sql, TimeZone timeZone, Object ... args) {
        int n;
        Connection conn = null;
        PreparedStatement stmt = null;
        String sqlExpression = DatabaseUtils.loadSql(sql);
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(sqlExpression);
            DatabaseMapping.bindArgs(stmt, timeZone, Arrays.asList(args));
            n = stmt.executeUpdate();
        }
        catch (Exception ex) {
            try {
                throw new DatabaseException("Failed to execute sql: " + sqlExpression, ex);
            }
            catch (Throwable throwable) {
                IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
                throw throwable;
            }
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
        return n;
    }

    public <R> R withConnection(ConnectionHandler<R> handler) throws DatabaseException {
        R r;
        Connection conn = null;
        try {
            conn = this.getDataSource().getConnection();
            Connection connProxy = this.proxy(conn);
            this.connectionThreadLocal.set(connProxy);
            r = handler.apply(connProxy);
            this.connectionThreadLocal.set(null);
        }
        catch (Exception ex) {
            try {
                throw new DatabaseException(ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                this.connectionThreadLocal.set(null);
                IO.close((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{conn});
        return r;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R withTransaction(ConnectionHandler<R> handler) throws DatabaseException {
        try {
            R r;
            Connection conn = null;
            try {
                conn = this.getDataSource().getConnection();
                conn.setAutoCommit(false);
                Connection connProxy = this.proxy(conn);
                this.connectionThreadLocal.set(connProxy);
                R result = handler.apply(connProxy);
                conn.commit();
                r = result;
                this.connectionThreadLocal.set(null);
            }
            catch (Exception ex) {
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                    throw new DatabaseException(ex.getMessage(), ex);
                }
                catch (Throwable throwable) {
                    this.connectionThreadLocal.set(null);
                    IO.close((AutoCloseable[])new AutoCloseable[]{conn});
                    throw throwable;
                }
            }
            IO.close((AutoCloseable[])new AutoCloseable[]{conn});
            return r;
        }
        catch (SQLException ex2) {
            throw new DatabaseException(ex2.getMessage(), ex2);
        }
    }

    public <T> DatabaseSelect<T> select(Class<T> type) {
        return new DatabaseSelect<T>(this, type);
    }

    public <T> DatabaseUpdate<T> insert(Class<T> type) {
        return new DatabaseUpdate<T>(this, type, DatabaseUpdate.Type.INSERT);
    }

    public <T> DatabaseUpdate<T> update(Class<T> type) {
        return new DatabaseUpdate<T>(this, type, DatabaseUpdate.Type.UPDATE);
    }

    public <T> DatabaseUpdate<T> delete(Class<T> type) {
        return new DatabaseUpdate<T>(this, type, DatabaseUpdate.Type.DELETE);
    }

    <T> DatabaseMapping<T> mapping(Class<T> type) {
        DatabaseMapping<?> mapping = this.mappingsMap.get(type);
        if (mapping == null) {
            throw new DatabaseException("No mapping registered for type: " + type);
        }
        return mapping;
    }

    <R> Future<R> submit(Callable<R> callable) {
        return ((ExecutorService)executor.get()).submit(callable);
    }

    private Connection proxy(Connection connection) {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Class[] interfaces = new Class[]{Connection.class};
        return (Connection)Proxy.newProxyInstance(classLoader, interfaces, (proxy, method, args) -> {
            if (method.getName().equals("close")) {
                return null;
            }
            return method.invoke((Object)connection, args);
        });
    }

    private static class BasicMapping<T>
    implements DatabaseMapping<T> {
        private int sqlType;

        @Override
        public Type type() {
            switch (this.sqlType) {
                case -7: {
                    return Boolean.class;
                }
                case -6: {
                    return Short.class;
                }
                case 5: {
                    return Short.class;
                }
                case 4: {
                    return Integer.class;
                }
                case -5: {
                    return Long.class;
                }
                case 6: {
                    return Float.class;
                }
                case 8: {
                    return Double.class;
                }
                case 3: {
                    return Double.class;
                }
                case 12: {
                    return String.class;
                }
                case 91: {
                    return LocalDate.class;
                }
                case 92: {
                    return LocalTime.class;
                }
                case 93: {
                    return LocalDateTime.class;
                }
            }
            throw new IllegalStateException("Unsupported SQL Type: " + this.sqlType);
        }

        @Override
        public DatabaseMapping.Mapper<T> select() {
            Calendar cal = Calendar.getInstance(TimeZone.getDefault());
            switch (this.sqlType) {
                case -7: {
                    return rs -> DatabaseMapping.readBoolean(rs, 1).orNull();
                }
                case -6: {
                    return rs -> DatabaseMapping.readShort(rs, 1).orNull();
                }
                case 5: {
                    return rs -> DatabaseMapping.readShort(rs, 1).orNull();
                }
                case 4: {
                    return rs -> DatabaseMapping.readInt(rs, 1).orNull();
                }
                case -5: {
                    return rs -> DatabaseMapping.readLong(rs, 1).orNull();
                }
                case 6: {
                    return rs -> DatabaseMapping.readFloat(rs, 1).orNull();
                }
                case 8: {
                    return rs -> DatabaseMapping.readDouble(rs, 1).orNull();
                }
                case 3: {
                    return rs -> DatabaseMapping.readDouble(rs, 1).orNull();
                }
                case 12: {
                    return rs -> rs.getString(1);
                }
                case 91: {
                    return rs -> DatabaseMapping.readDate(rs, 1, cal).map(Date::toLocalDate).orNull();
                }
                case 92: {
                    return rs -> DatabaseMapping.readTime(rs, 1, cal).map(Time::toLocalTime).orNull();
                }
                case 93: {
                    return rs -> DatabaseMapping.readTimestamp(rs, 1, cal).map(Timestamp::toLocalDateTime).orNull();
                }
            }
            throw new IllegalStateException("Unsupported SQL Type: " + this.sqlType);
        }

        @Override
        public DatabaseMapping.Binder<T> insert() {
            return this.binder();
        }

        @Override
        public DatabaseMapping.Binder<T> delete() {
            return this.binder();
        }

        private DatabaseMapping.Binder<T> binder() {
            switch (this.sqlType) {
                case -7: {
                    return (v, stmt) -> stmt.setBoolean(1, (Boolean)v);
                }
                case -6: {
                    return (v, stmt) -> stmt.setShort(1, ((Number)v).shortValue());
                }
                case 5: {
                    return (v, stmt) -> stmt.setShort(1, ((Number)v).shortValue());
                }
                case 4: {
                    return (v, stmt) -> stmt.setInt(1, ((Number)v).intValue());
                }
                case -5: {
                    return (v, stmt) -> stmt.setLong(1, ((Number)v).longValue());
                }
                case 6: {
                    return (v, stmt) -> stmt.setFloat(1, ((Number)v).floatValue());
                }
                case 8: {
                    return (v, stmt) -> stmt.setDouble(1, ((Number)v).doubleValue());
                }
                case 3: {
                    return (v, stmt) -> stmt.setDouble(1, ((Number)v).doubleValue());
                }
                case 12: {
                    return (v, stmt) -> stmt.setString(1, (String)v);
                }
                case 91: {
                    return (v, stmt) -> stmt.setDate(1, Date.valueOf((LocalDate)v));
                }
                case 92: {
                    return (v, stmt) -> stmt.setTime(1, Time.valueOf((LocalTime)v));
                }
                case 93: {
                    return (v, stmt) -> stmt.setTimestamp(1, Timestamp.valueOf((LocalDateTime)v));
                }
            }
            throw new IllegalStateException("Unsupported SQL Type: " + this.sqlType);
        }

        public BasicMapping(int sqlType) {
            this.sqlType = sqlType;
        }
    }

    public static interface ConnectionHandler<R> {
        public R apply(Connection var1) throws SQLException;
    }
}

