/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.db;

import com.d3x.core.db.Database;
import com.d3x.core.db.DatabaseException;
import com.d3x.core.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseUtils {
    private static final Logger log = LoggerFactory.getLogger(DatabaseUtils.class);
    private static final Map<String, String> sqlMap = new HashMap<String, String>();

    public static String loadSql(String resource) {
        try {
            if (!resource.startsWith("/")) {
                return resource;
            }
            if (sqlMap.containsKey(resource)) {
                String sql = sqlMap.get(resource);
                return sql != null ? sql : resource;
            }
            log.debug("Loading SQL expression from " + resource);
            URL url = Database.class.getResource(resource);
            if (url == null) {
                throw new RuntimeException("No classpath resource located for path: " + resource);
            }
            String sql = IO.readText((InputStream)url.openStream());
            sqlMap.put(resource, sql);
            return sql;
        }
        catch (IOException ex) {
            throw new DatabaseException("Failed to load SQL from resource: " + resource, ex);
        }
    }
}

