/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.db;

import java.util.concurrent.Callable;

public class DatabaseTiming {
    private long connectMillis;
    private long queryMillis;
    private long resultSetMillis;

    public DatabaseTiming reset() {
        this.connectMillis = 0L;
        this.queryMillis = 0L;
        this.resultSetMillis = 0L;
        return this;
    }

    <T> T timeConnect(Callable<T> callable) {
        try {
            long t1 = System.currentTimeMillis();
            T result = callable.call();
            long t2 = System.currentTimeMillis();
            this.connectMillis = t2 - t1;
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException("Timing operation failed: " + ex.getMessage(), ex);
        }
    }

    <T> T timeQuery(Callable<T> callable) {
        try {
            long t1 = System.currentTimeMillis();
            T result = callable.call();
            long t2 = System.currentTimeMillis();
            this.queryMillis = t2 - t1;
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException("Timing operation failed: " + ex.getMessage(), ex);
        }
    }

    <T> T timeResultSet(Callable<T> callable) {
        try {
            long t1 = System.currentTimeMillis();
            T result = callable.call();
            long t2 = System.currentTimeMillis();
            this.resultSetMillis = t2 - t1;
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException("Timing operation failed: " + ex.getMessage(), ex);
        }
    }

    public String toString() {
        String template = "DB Timing, connect: %s millis, query: %s millis, resultSet: %s millis";
        return String.format(template, this.connectMillis, this.queryMillis, this.resultSetMillis);
    }
}

