/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.db;

import com.d3x.core.db.Database;
import com.d3x.core.db.DatabaseException;
import com.d3x.core.db.DatabaseIterator;
import com.d3x.core.db.DatabaseMapping;
import com.d3x.core.db.DatabaseTiming;
import com.d3x.core.db.DatabaseUtils;
import com.d3x.core.util.IO;
import com.d3x.core.util.Option;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;

public class DatabaseSelect<T> {
    private Database db;
    private Class<T> type;
    private List<Object> args;
    private Option<String> sql;
    private Option<Integer> limit;
    private Option<Duration> timeout;
    private Option<Integer> fetchSize;
    private DatabaseTiming timing;

    DatabaseSelect(Database db, Class<T> type) {
        this.db = db;
        this.type = type;
        this.sql = Option.empty();
        this.limit = Option.empty();
        this.timeout = Option.empty();
        this.args = new ArrayList<Object>();
        this.timing = new DatabaseTiming();
        this.fetchSize = db.getConfig().getFetchSize();
    }

    public DatabaseSelect<T> sql(String sql) {
        this.sql = Option.of((Object)sql);
        return this;
    }

    public DatabaseSelect<T> args(Object ... args) {
        this.args = Arrays.asList(args);
        return this;
    }

    public DatabaseSelect<T> args(Collection<?> args) {
        this.args = new ArrayList(args);
        return this;
    }

    public DatabaseSelect<T> timeout(Duration duration) {
        this.timeout = Option.of((Object)duration);
        return this;
    }

    public DatabaseSelect<T> fetchSize(int fetchSize) {
        this.fetchSize = fetchSize > 0 ? Option.of((Object)fetchSize) : Option.empty();
        return this;
    }

    public DatabaseSelect<T> limit(int limit) {
        this.limit = limit > 0 ? Option.of((Object)limit) : Option.empty();
        return this;
    }

    private DatabaseMapping.Mapper<T> mapper() {
        return this.db.mapping(this.type).select();
    }

    public Option<T> first() {
        return this.first(this.mapper());
    }

    public Set<T> set() {
        return new HashSet<T>(this.list());
    }

    public List<T> list() {
        return this.list(this.mapper());
    }

    public DatabaseIterator<T> iterator() {
        return this.iterator(this.mapper());
    }

    public DatabaseTiming getTiming() {
        return this.timing;
    }

    private String resolveSql() {
        return (String)this.sql.map(DatabaseUtils::loadSql).orElse(() -> {
            DatabaseMapping<T> mapping = this.db.mapping(this.type);
            return DatabaseMapping.getSelectSql(mapping);
        });
    }

    public Option<T> first(DatabaseMapping.Mapper<T> mapper) {
        Option result2;
        String sql;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            conn = null;
            stmt = null;
            rs = null;
            sql = this.resolveSql();
            conn = this.db.getConnection();
            stmt = DatabaseMapping.bindArgs(conn.prepareStatement(sql), this.args);
            stmt.setQueryTimeout((int)((Duration)this.timeout.orElse((Object)Duration.ofSeconds(30L))).toSeconds());
            stmt.setFetchSize((Integer)this.fetchSize.orElse((Object)0));
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            T result2 = mapper.map(rs);
            Option option = Option.of(result2);
            IO.close((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
            return option;
        }
        try {
            result2 = Option.empty();
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Failed to load first record for sql: " + sql, ex);
            }
            catch (Throwable throwable) {
                IO.close((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
                throw throwable;
            }
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
        return result2;
    }

    public int count() {
        int n;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = this.resolveSql();
        try {
            int count = 0;
            conn = this.db.getConnection();
            stmt = DatabaseMapping.bindArgs(conn.prepareStatement(sql), this.args);
            stmt.setMaxRows((Integer)this.limit.orElse((Object)0));
            stmt.setQueryTimeout((int)((Duration)this.timeout.orElse((Object)Duration.ofSeconds(30L))).toSeconds());
            stmt.setFetchSize((Integer)this.fetchSize.orElse((Object)0));
            rs = stmt.executeQuery();
            while (rs.next()) {
                ++count;
            }
            n = count;
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Failed to load records for sql: " + sql, ex);
            }
            catch (Throwable throwable) {
                IO.close((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
                throw throwable;
            }
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
        return n;
    }

    public void forEach(Consumer<T> consumer) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = this.resolveSql();
        Integer limitValue = (Integer)this.limit.orElse((Object)Integer.MAX_VALUE);
        DatabaseMapping.Mapper<T> mapper = this.mapper();
        try {
            int count = 0;
            conn = this.db.getConnection();
            stmt = DatabaseMapping.bindArgs(conn.prepareStatement(sql), this.args);
            stmt.setMaxRows((Integer)this.limit.orElse((Object)0));
            stmt.setQueryTimeout((int)((Duration)this.timeout.orElse((Object)Duration.ofSeconds(30L))).toSeconds());
            stmt.setFetchSize((Integer)this.fetchSize.orElse((Object)0));
            rs = stmt.executeQuery();
            while (rs.next()) {
                T record = mapper.map(rs);
                consumer.accept(record);
                if (++count < limitValue) continue;
            }
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Failed to load records for sql: " + sql, ex);
            }
            catch (Throwable throwable) {
                IO.close((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
                throw throwable;
            }
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{rs, stmt, conn});
    }

    public List<T> list(DatabaseMapping.Mapper<T> mapper) {
        List list;
        Connection conn = null;
        PreparedStatement stmt = null;
        String sql = this.resolveSql();
        Integer limitValue = (Integer)this.limit.orElse((Object)Integer.MAX_VALUE);
        try {
            conn = this.timing.timeConnect(this.db::getConnection);
            stmt = DatabaseMapping.bindArgs(conn.prepareStatement(sql), this.args);
            stmt.setMaxRows((Integer)this.limit.orElse((Object)0));
            stmt.setQueryTimeout((int)((Duration)this.timeout.orElse((Object)Duration.ofSeconds(30L))).toSeconds());
            stmt.setFetchSize((Integer)this.fetchSize.orElse((Object)0));
            ResultSet rs = this.timing.timeQuery(stmt::executeQuery);
            list = this.timing.timeResultSet(() -> {
                int count = 0;
                ArrayList results = new ArrayList();
                while (rs.next()) {
                    Object record = mapper.map(rs);
                    results.add(record);
                    if (++count < limitValue) continue;
                    break;
                }
                return results;
            });
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Failed to load records for sql: " + sql, ex);
            }
            catch (Throwable throwable) {
                IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
                throw throwable;
            }
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
        return list;
    }

    public DatabaseIterator<T> iterator(DatabaseMapping.Mapper<T> mapper) {
        Connection conn = null;
        PreparedStatement stmt = null;
        String sql = this.resolveSql();
        try {
            conn = this.timing.timeConnect(this.db::getConnection);
            stmt = DatabaseMapping.bindArgs(conn.prepareStatement(sql), this.args);
            stmt.setMaxRows((Integer)this.limit.orElse((Object)0));
            stmt.setQueryTimeout((int)((Duration)this.timeout.orElse((Object)Duration.ofSeconds(30L))).toSeconds());
            stmt.setFetchSize((Integer)this.fetchSize.orElse((Object)0));
            ResultSet rs = this.timing.timeQuery(stmt::executeQuery);
            Integer limitValue = (Integer)this.limit.orElse((Object)Integer.MAX_VALUE);
            return this.iterator(rs, limitValue, mapper, rs, stmt, conn);
        }
        catch (Exception ex) {
            IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
            throw new DatabaseException("Failed to load records for sql: " + sql, ex);
        }
    }

    public T apply(Handler<T> handler) {
        Object object;
        Connection conn = null;
        PreparedStatement stmt = null;
        String sql = this.resolveSql();
        try {
            conn = this.timing.timeConnect(() -> this.db.getConnection());
            stmt = DatabaseMapping.bindArgs(conn.prepareStatement(sql), this.args);
            stmt.setMaxRows((Integer)this.limit.orElse((Object)0));
            stmt.setQueryTimeout((int)((Duration)this.timeout.orElse((Object)Duration.ofSeconds(30L))).toSeconds());
            stmt.setFetchSize((Integer)this.fetchSize.orElse((Object)0));
            ResultSet rs = this.timing.timeQuery(stmt::executeQuery);
            object = this.timing.timeResultSet(() -> handler.accept(rs));
        }
        catch (Exception ex) {
            try {
                throw new DatabaseException("Failed to load records for sql: " + sql, ex);
            }
            catch (Throwable throwable) {
                IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
                throw throwable;
            }
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{stmt, conn});
        return (T)object;
    }

    private DatabaseIterator<T> iterator(final ResultSet rs, final int limit, final DatabaseMapping.Mapper<T> mapper, final AutoCloseable ... closeables) {
        return new DatabaseIterator<T>(){
            private int count;
            private Boolean hasNext;

            @Override
            public void close() {
                IO.close((AutoCloseable[])new AutoCloseable[]{rs});
                IO.close((AutoCloseable[])closeables);
            }

            @Override
            public boolean hasNext() {
                try {
                    if (this.hasNext != null) {
                        return this.hasNext;
                    }
                    if (this.count >= limit) {
                        this.close();
                        return false;
                    }
                    this.hasNext = rs.next();
                    if (!this.hasNext.booleanValue()) {
                        this.close();
                        return false;
                    }
                    return true;
                }
                catch (Throwable t) {
                    this.close();
                    throw new DatabaseException(t.getMessage(), t);
                }
            }

            @Override
            public T next() {
                try {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("Database Iterator has been exhausted");
                    }
                    Object record = mapper.map(rs);
                    this.hasNext = null;
                    ++this.count;
                    return record;
                }
                catch (Throwable t) {
                    this.close();
                    throw new DatabaseException(t.getMessage(), t);
                }
            }
        };
    }

    public static interface Handler<T> {
        public T accept(ResultSet var1) throws SQLException;
    }
}

