/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.db;

import com.d3x.core.db.DatabaseMapping;
import com.d3x.core.util.Option;
import java.lang.reflect.Type;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class DatabaseRecord {
    private Map<String, Object> values;

    private DatabaseRecord(Map<String, Object> values) {
        this.values = values;
    }

    public static DatabaseRecord of(Consumer<Map<String, Object>> consumer) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        consumer.accept(values);
        return new DatabaseRecord(values);
    }

    public int size() {
        return this.values.size();
    }

    public Set<String> names() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.values.values());
    }

    public <T> Option<T> getValue(String name) {
        return Option.of((Object)this.values.get(name));
    }

    public <T> T getValueOrFail(String name) {
        Object value = this.values.get(name);
        if (value != null) {
            return (T)value;
        }
        throw new IllegalArgumentException("No field entry in record for: " + name);
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    static class Mapping
    implements DatabaseMapping<DatabaseRecord> {
        Mapping() {
        }

        @Override
        public Type type() {
            return DatabaseRecord.class;
        }

        @Override
        public DatabaseMapping.Mapper<DatabaseRecord> select() {
            int[] types = new int[100];
            String[] names = new String[100];
            AtomicInteger count = new AtomicInteger();
            return rs -> {
                int i;
                if (count.get() == 0) {
                    ResultSetMetaData metaData = rs.getMetaData();
                    int colCount = metaData.getColumnCount();
                    count.set(metaData.getColumnCount());
                    for (i = 0; i < colCount; ++i) {
                        types[i] = metaData.getColumnType(i + 1);
                        names[i] = metaData.getColumnName(i + 1);
                    }
                }
                int colCount = count.get();
                LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(colCount);
                block11: for (i = 0; i < colCount; ++i) {
                    int typeCode = types[i];
                    String name = names[i];
                    switch (typeCode) {
                        case 16: {
                            values.put(name, DatabaseMapping.readBoolean(rs, i + 1).orNull());
                            continue block11;
                        }
                        case 4: {
                            values.put(name, DatabaseMapping.readInt(rs, i + 1).orNull());
                            continue block11;
                        }
                        case 6: {
                            values.put(name, DatabaseMapping.readFloat(rs, i + 1).orNull());
                            continue block11;
                        }
                        case -5: {
                            values.put(name, DatabaseMapping.readLong(rs, i + 1).orNull());
                            continue block11;
                        }
                        case 8: {
                            values.put(name, DatabaseMapping.readDouble(rs, i + 1).orNull());
                            continue block11;
                        }
                        case 91: {
                            values.put(name, DatabaseMapping.readLocalDate(rs, i + 1).orNull());
                            continue block11;
                        }
                        case 93: {
                            values.put(name, DatabaseMapping.readLocalDateTime(rs, i + 1).orNull());
                            continue block11;
                        }
                        case 12: {
                            values.put(name, DatabaseMapping.readString(rs, i + 1).orNull());
                            continue block11;
                        }
                        default: {
                            values.put(name, rs.getObject(i + 1));
                        }
                    }
                }
                return new DatabaseRecord(values);
            };
        }

        @Override
        public DatabaseMapping.Binder<DatabaseRecord> insert() {
            return (record, stmt) -> DatabaseMapping.bindArgs(stmt, new ArrayList<Object>(record.values()));
        }
    }
}

