/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.db;

import com.d3x.core.db.Database;
import com.d3x.core.util.Option;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class DatabaseOperation<T> {
    private Database db;
    private List<Object> args;
    private Option<String> sql;
    private Option<Duration> timeout;
    private Option<Integer> fetchSize;
    private Option<Integer> limit;

    DatabaseOperation(Database db) {
        this.db = db;
        this.sql = Option.empty();
        this.args = new ArrayList<Object>();
        this.timeout = Option.empty();
        this.limit = Option.empty();
        this.fetchSize = db.getConfig().getFetchSize();
    }

    public T sql(String sql) {
        this.sql = Option.of((Object)sql);
        return (T)this;
    }

    public T args(Object ... args) {
        this.args = Arrays.asList(args);
        return (T)this;
    }

    public T timeout(Duration timeout) {
        this.timeout = Option.of((Object)timeout);
        return (T)this;
    }

    public T fetchSize(int fetchSize) {
        this.fetchSize = fetchSize > 0 ? Option.of((Object)fetchSize) : Option.empty();
        return (T)this;
    }

    public T limit(int limit) {
        this.limit = limit > 0 ? Option.of((Object)limit) : Option.empty();
        return (T)this;
    }

    Database getDb() {
        return this.db;
    }

    List<Object> getArgs() {
        return this.args;
    }

    Option<String> getSql() {
        return this.sql;
    }

    Option<Duration> getTimeout() {
        return this.timeout;
    }

    Option<Integer> getFetchSize() {
        return this.fetchSize;
    }

    Option<Integer> getLimit() {
        return this.limit;
    }
}

