/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.db;

import com.d3x.core.db.DatabaseException;
import com.d3x.core.db.DatabaseSql;
import com.d3x.core.db.DatabaseUtils;
import com.d3x.core.util.Option;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;

public interface DatabaseMapping<T> {
    public Type type();

    default public Mapper<T> select() {
        throw new UnsupportedOperationException("The select operation is not supported for type: " + this.type());
    }

    default public Binder<T> insert() {
        throw new UnsupportedOperationException("The insert operation is not supported for type: " + this.type());
    }

    default public Binder<T> update() {
        throw new UnsupportedOperationException("The update operation is not supported for type: " + this.type());
    }

    default public Binder<T> delete() {
        throw new UnsupportedOperationException("The delete operation is not supported for type: " + this.type());
    }

    public static Option<Boolean> readBoolean(ResultSet rs, int column) throws SQLException {
        boolean value = rs.getBoolean(column);
        return rs.wasNull() ? Option.empty() : Option.of((Object)value);
    }

    public static Option<Boolean> readBoolean(ResultSet rs, String column) throws SQLException {
        boolean value = rs.getBoolean(column);
        return rs.wasNull() ? Option.empty() : Option.of((Object)value);
    }

    public static Option<Short> readShort(ResultSet rs, int column) throws SQLException {
        short value = rs.getShort(column);
        return rs.wasNull() ? Option.empty() : Option.of((Object)value);
    }

    public static Option<Short> readShort(ResultSet rs, String column) throws SQLException {
        short value = rs.getShort(column);
        return rs.wasNull() ? Option.empty() : Option.of((Object)value);
    }

    public static Option<Integer> readInt(ResultSet rs, int column) throws SQLException {
        int value = rs.getInt(column);
        return rs.wasNull() ? Option.empty() : Option.of((Object)value);
    }

    public static Option<Integer> readInt(ResultSet rs, String column) throws SQLException {
        int value = rs.getInt(column);
        return rs.wasNull() ? Option.empty() : Option.of((Object)value);
    }

    public static Option<Long> readLong(ResultSet rs, int column) throws SQLException {
        long value = rs.getLong(column);
        return rs.wasNull() ? Option.empty() : Option.of((Object)value);
    }

    public static Option<Long> readLong(ResultSet rs, String column) throws SQLException {
        long value = rs.getLong(column);
        return rs.wasNull() ? Option.empty() : Option.of((Object)value);
    }

    public static Option<Float> readFloat(ResultSet rs, int column) throws SQLException {
        float value = rs.getFloat(column);
        return rs.wasNull() ? Option.empty() : Option.of((Object)Float.valueOf(value));
    }

    public static Option<Float> readFloat(ResultSet rs, String column) throws SQLException {
        float value = rs.getFloat(column);
        return rs.wasNull() ? Option.empty() : Option.of((Object)Float.valueOf(value));
    }

    public static Option<Double> readDouble(ResultSet rs, int column) throws SQLException {
        double value = rs.getDouble(column);
        return rs.wasNull() ? Option.empty() : Option.of((Object)value);
    }

    public static Option<Double> readDouble(ResultSet rs, String column) throws SQLException {
        double value = rs.getDouble(column);
        return rs.wasNull() ? Option.empty() : Option.of((Object)value);
    }

    public static Option<String> readString(ResultSet rs, int column) throws SQLException {
        return Option.of((Object)rs.getString(column));
    }

    public static Option<String> readString(ResultSet rs, String column) throws SQLException {
        return Option.of((Object)rs.getString(column));
    }

    public static Option<Date> readDate(ResultSet rs, int column) throws SQLException {
        return Option.of((Object)rs.getDate(column));
    }

    public static Option<Date> readDate(ResultSet rs, String column) throws SQLException {
        return Option.of((Object)rs.getDate(column));
    }

    public static Option<Date> readDate(ResultSet rs, int column, Calendar calendar) throws SQLException {
        return Option.of((Object)rs.getDate(column, calendar));
    }

    public static Option<Date> readDate(ResultSet rs, String column, Calendar calendar) throws SQLException {
        return Option.of((Object)rs.getDate(column, calendar));
    }

    public static Option<LocalDate> readLocalDate(ResultSet rs, int column) throws SQLException {
        return Option.of((Object)rs.getDate(column)).map(Date::toLocalDate);
    }

    public static Option<LocalDate> readLocalDate(ResultSet rs, String column) throws SQLException {
        return Option.of((Object)rs.getDate(column)).map(Date::toLocalDate);
    }

    public static Option<Time> readTime(ResultSet rs, int column) throws SQLException {
        return Option.of((Object)rs.getTime(column));
    }

    public static Option<Time> readTime(ResultSet rs, String column) throws SQLException {
        return Option.of((Object)rs.getTime(column));
    }

    public static Option<Time> readTime(ResultSet rs, int column, Calendar calendar) throws SQLException {
        return Option.of((Object)rs.getTime(column, calendar));
    }

    public static Option<Time> readTime(ResultSet rs, String column, Calendar calendar) throws SQLException {
        return Option.of((Object)rs.getTime(column, calendar));
    }

    public static Option<Timestamp> readTimestamp(ResultSet rs, int column) throws SQLException {
        return Option.of((Object)rs.getTimestamp(column));
    }

    public static Option<Timestamp> readTimestamp(ResultSet rs, String column, Calendar calendar) throws SQLException {
        return Option.of((Object)rs.getTimestamp(column, calendar));
    }

    public static Option<Timestamp> readTimestamp(ResultSet rs, int column, Calendar calendar) throws SQLException {
        return Option.of((Object)rs.getTimestamp(column, calendar));
    }

    public static Option<Timestamp> readTimestamp(ResultSet rs, String column) throws SQLException {
        return Option.of((Object)rs.getTimestamp(column));
    }

    public static Option<LocalDateTime> readLocalDateTime(ResultSet rs, int column) throws SQLException {
        return Option.of((Object)rs.getTimestamp(column)).map(Timestamp::toLocalDateTime);
    }

    public static Option<LocalDateTime> readLocalDateTime(ResultSet rs, String column) throws SQLException {
        return Option.of((Object)rs.getTimestamp(column)).map(Timestamp::toLocalDateTime);
    }

    public static void applyBoolean(PreparedStatement stmt, int paramIndex, Boolean value) throws SQLException {
        if (value == null) {
            stmt.setNull(paramIndex, 4);
        } else {
            stmt.setBoolean(paramIndex, value);
        }
    }

    public static void applyInt(PreparedStatement stmt, int paramIndex, Integer value) throws SQLException {
        if (value == null) {
            stmt.setNull(paramIndex, 4);
        } else {
            stmt.setInt(paramIndex, value);
        }
    }

    public static void applyLong(PreparedStatement stmt, int paramIndex, Long value) throws SQLException {
        if (value == null) {
            stmt.setNull(paramIndex, -5);
        } else {
            stmt.setLong(paramIndex, value);
        }
    }

    public static void applyDouble(PreparedStatement stmt, int paramIndex, Double value) throws SQLException {
        if (value == null || Double.isNaN(value)) {
            stmt.setNull(paramIndex, 8);
        } else {
            stmt.setDouble(paramIndex, value);
        }
    }

    public static void applyFloat(PreparedStatement stmt, int paramIndex, Float value) throws SQLException {
        if (value == null || Float.isNaN(value.floatValue())) {
            stmt.setNull(paramIndex, 6);
        } else {
            stmt.setFloat(paramIndex, value.floatValue());
        }
    }

    public static void applyString(PreparedStatement stmt, int paramIndex, String value) throws SQLException {
        if (value == null) {
            stmt.setNull(paramIndex, 12);
        } else {
            stmt.setString(paramIndex, value);
        }
    }

    public static void applyDate(PreparedStatement stmt, int paramIndex, Date value) throws SQLException {
        if (value == null) {
            stmt.setNull(paramIndex, 91);
        } else {
            stmt.setDate(paramIndex, value);
        }
    }

    public static void applyDate(PreparedStatement stmt, int paramIndex, Date value, Calendar calendar) throws SQLException {
        if (value == null) {
            stmt.setNull(paramIndex, 91);
        } else {
            stmt.setDate(paramIndex, value, calendar);
        }
    }

    default public Set<T> toSet(ResultSet rs) throws SQLException {
        HashSet<T> result = new HashSet<T>();
        Mapper<T> mapper = this.select();
        while (rs.next()) {
            T record = mapper.map(rs);
            result.add(record);
        }
        return result;
    }

    default public List<T> toList(ResultSet rs) throws SQLException {
        ArrayList<T> result = new ArrayList<T>();
        Mapper<T> mapper = this.select();
        while (rs.next()) {
            T record = mapper.map(rs);
            result.add(record);
        }
        return result;
    }

    default public Iterator<T> toIterator(ResultSet rs) {
        return DatabaseMapping.iterator(rs, this.select());
    }

    public static String in(Collection<?> values) {
        return DatabaseMapping.in(values, (Option<ZoneId>)Option.empty());
    }

    public static String in(Collection<?> values, Option<ZoneId> zoneId) {
        if (values.isEmpty()) {
            return "()";
        }
        StringBuilder in = new StringBuilder("(");
        for (Object value : values) {
            String text;
            in.append(in.length() > 1 ? ", " : "");
            if (value instanceof String) {
                in.append("'").append(value).append("'");
                continue;
            }
            if (value instanceof Number) {
                in.append(value);
                continue;
            }
            if (value instanceof Boolean) {
                boolean entry = (Boolean)value;
                in.append(entry ? "1" : "0");
                continue;
            }
            if (value instanceof Currency) {
                Currency entry = (Currency)value;
                text = entry.getCurrencyCode();
                in.append("'").append(text).append("'");
                continue;
            }
            if (value instanceof LocalDate) {
                LocalDate entry = (LocalDate)value;
                text = DateTimeFormatter.ISO_LOCAL_DATE.format(entry);
                in.append("'").append(text).append("'");
                continue;
            }
            if (value instanceof LocalTime) {
                LocalTime entry = (LocalTime)value;
                text = DateTimeFormatter.ISO_LOCAL_TIME.format(entry);
                in.append("'").append(text).append("'");
                continue;
            }
            if (value instanceof LocalDateTime) {
                LocalDateTime entry = (LocalDateTime)value;
                LocalDateTime dateTime = (LocalDateTime)zoneId.map(entry::atZone).map(ZonedDateTime::toLocalDateTime).orElse((Object)entry);
                String text2 = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(dateTime);
                in.append("'").append(text2).append("'");
                continue;
            }
            if (!(value instanceof ZonedDateTime)) continue;
            ZonedDateTime entry = (ZonedDateTime)value;
            text = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(entry);
            in.append("'").append(text).append("'");
        }
        return in.append(")").toString();
    }

    public static PreparedStatement bindArgs(PreparedStatement stmt, List<Object> args) throws DatabaseException {
        return DatabaseMapping.bindArgs(stmt, TimeZone.getDefault(), args);
    }

    public static PreparedStatement bindArgs(PreparedStatement stmt, TimeZone timeZone, List<Object> args) throws DatabaseException {
        try {
            TimeZone tz = timeZone != null ? timeZone : TimeZone.getDefault();
            for (int i = 0; i < args.size(); ++i) {
                Calendar calendar;
                int paramIndex = i + 1;
                Object arg = args.get(i);
                if (arg instanceof String) {
                    stmt.setString(paramIndex, (String)arg);
                    continue;
                }
                if (arg instanceof Boolean) {
                    stmt.setBoolean(paramIndex, (Boolean)arg);
                    continue;
                }
                if (arg instanceof Integer) {
                    stmt.setInt(paramIndex, (Integer)arg);
                    continue;
                }
                if (arg instanceof Long) {
                    stmt.setLong(paramIndex, (Long)arg);
                    continue;
                }
                if (arg instanceof Double) {
                    Double doubleValue = (Double)arg;
                    if (Double.isNaN(doubleValue)) {
                        stmt.setNull(paramIndex, 8);
                        continue;
                    }
                    stmt.setDouble(paramIndex, (Double)arg);
                    continue;
                }
                if (arg instanceof Enum) {
                    stmt.setString(paramIndex, ((Enum)arg).name());
                    continue;
                }
                if (arg instanceof Reader) {
                    stmt.setCharacterStream(paramIndex, (Reader)arg);
                    continue;
                }
                if (arg instanceof InputStream) {
                    stmt.setBinaryStream(paramIndex, (InputStream)arg);
                    continue;
                }
                if (arg instanceof LocalTime) {
                    stmt.setTime(paramIndex, Time.valueOf((LocalTime)arg));
                    continue;
                }
                if (arg instanceof java.util.Date) {
                    calendar = Calendar.getInstance(tz);
                    stmt.setDate(paramIndex, new Date(((java.util.Date)arg).getTime()), calendar);
                    continue;
                }
                if (arg instanceof LocalDate) {
                    calendar = Calendar.getInstance(tz);
                    stmt.setDate(paramIndex, Date.valueOf((LocalDate)arg), calendar);
                    continue;
                }
                if (arg instanceof Instant) {
                    calendar = Calendar.getInstance(tz);
                    stmt.setTimestamp(paramIndex, new Timestamp(((Instant)arg).toEpochMilli()), calendar);
                    continue;
                }
                if (arg instanceof LocalDateTime) {
                    ZoneId zoneId = ZoneId.of(tz.getID());
                    Calendar calendar2 = Calendar.getInstance(tz);
                    LocalDateTime localDateTime = (LocalDateTime)arg;
                    ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
                    stmt.setTimestamp(paramIndex, new Timestamp(zonedDateTime.toInstant().toEpochMilli()), calendar2);
                    continue;
                }
                if (arg instanceof ZonedDateTime) {
                    ZonedDateTime dateTime = (ZonedDateTime)arg;
                    ZoneId zoneId = dateTime.getZone();
                    Calendar calendar3 = Calendar.getInstance(TimeZone.getTimeZone(zoneId.getId()));
                    stmt.setTimestamp(paramIndex, new Timestamp(dateTime.toInstant().toEpochMilli()), calendar3);
                    continue;
                }
                throw new RuntimeException("Cannot bind arg to PreparedStatement, unsupported arg type:" + arg);
            }
            return stmt;
        }
        catch (SQLException ex) {
            throw new DatabaseException("Failed to bind SQL args to PreparedStatement", ex);
        }
    }

    public static <T> String getSelectSql(DatabaseMapping<T> mapping) {
        return DatabaseMapping.getSql(mapping, "select");
    }

    public static <T> String getInsertSql(DatabaseMapping<T> mapping) {
        return DatabaseMapping.getSql(mapping, "insert");
    }

    public static <T> String getUpdateSql(DatabaseMapping<T> mapping) {
        return DatabaseMapping.getSql(mapping, "update");
    }

    public static <T> String getDeleteSql(DatabaseMapping<T> mapping) {
        return DatabaseMapping.getSql(mapping, "delete");
    }

    public static <T> List<T> list(ResultSet rs, Mapper<T> mapper) {
        try {
            ArrayList<T> results = new ArrayList<T>();
            while (rs.next()) {
                T record = mapper.map(rs);
                results.add(record);
            }
            return results;
        }
        catch (SQLException ex) {
            throw new DatabaseException("Failed to extract records from ResultSet", ex);
        }
    }

    public static <T> Set<T> set(ResultSet rs, Mapper<T> mapper) {
        try {
            HashSet<T> results = new HashSet<T>();
            while (rs.next()) {
                T record = mapper.map(rs);
                results.add(record);
            }
            return results;
        }
        catch (SQLException ex) {
            throw new DatabaseException("Failed to extract records from ResultSet", ex);
        }
    }

    public static <T> Iterator<T> iterator(final ResultSet rs, final Mapper<T> mapper) {
        return new Iterator<T>(){
            private AtomicBoolean next = new AtomicBoolean(false);

            @Override
            public boolean hasNext() {
                try {
                    if (this.next.get()) {
                        return this.next.get();
                    }
                    this.next.set(rs.next());
                    return this.next.get();
                }
                catch (SQLException ex) {
                    throw new DatabaseException(ex.getMessage(), ex);
                }
            }

            @Override
            public T next() {
                try {
                    Object result = mapper.map(rs);
                    this.next.set(false);
                    return result;
                }
                catch (SQLException ex) {
                    throw new DatabaseException("Failed to map record from SQL result set", ex);
                }
            }
        };
    }

    public static String getSql(DatabaseMapping<?> mapping, String methodName) {
        try {
            Class<?> clazz = mapping.getClass();
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            DatabaseSql annotation = method.getAnnotation(DatabaseSql.class);
            if (annotation == null) {
                throw new DatabaseException("No 'DatabaseSql' annotation on insert method for: " + clazz);
            }
            String value = annotation.value();
            return value.startsWith("/") ? DatabaseUtils.loadSql(value) : value;
        }
        catch (NoSuchMethodException ex) {
            throw new DatabaseException("Unable to resolve SQL from insert mapping", ex);
        }
    }

    @FunctionalInterface
    public static interface Binder<T> {
        public void bind(T var1, PreparedStatement var2) throws SQLException;
    }

    @FunctionalInterface
    public static interface Mapper<T> {
        public T map(ResultSet var1) throws SQLException;
    }
}

