/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.db;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;

public class DatabaseDriver {
    private static final Map<String, DatabaseDriver> driverMap = new HashMap<String, DatabaseDriver>();
    public static final DatabaseDriver H2 = new DatabaseDriver(Type.H2, "org.h2.Driver");
    public static final DatabaseDriver MYSQL = new DatabaseDriver(Type.MYSQL, "com.mysql.jdbc.Driver");
    public static final DatabaseDriver MARIADB = new DatabaseDriver(Type.MARIADB, "com.mariadb.jdbc.Driver");
    public static final DatabaseDriver POSTGRES = new DatabaseDriver(Type.POSTGRES, "org.postgresql.Driver");
    public static final DatabaseDriver MSSQL = new DatabaseDriver(Type.MSSQL, "com.microsoft.sqlserver.jdbc.SQLServerDriver");
    public static final DatabaseDriver SYBASE = new DatabaseDriver(Type.SYBASE, "net.sourceforge.jtds.jdbc.Driver");
    public static final DatabaseDriver ORACLE = new DatabaseDriver(Type.ORACLE, "oracle.jdbc.OracleDriver");
    @NonNull
    private Type type;
    @NonNull
    private String driverClassName;

    public DatabaseDriver(Type type, String driverClassName) {
        Objects.requireNonNull(type, "The database type cannot be null");
        Objects.requireNonNull(driverClassName, "The driver class name cannot be null");
        this.type = type;
        this.driverClassName = driverClassName;
        driverMap.put(driverClassName.toLowerCase(), this);
    }

    public static DatabaseDriver of(String driverClassName) {
        Objects.requireNonNull(driverClassName, "The driver class name cannot be null");
        DatabaseDriver driver = driverMap.get(driverClassName.toLowerCase());
        if (driver != null) {
            return driver;
        }
        return new DatabaseDriver(Type.GENERIC, driverClassName);
    }

    public boolean isAvailable() {
        try {
            Class.forName(this.driverClassName);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String toString() {
        return "DatabaseDriver(type=" + this.getType() + ", driverClassName=" + this.getDriverClassName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseDriver)) {
            return false;
        }
        DatabaseDriver other = (DatabaseDriver)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        return !(this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseDriver;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        return result;
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    @NonNull
    public String getDriverClassName() {
        return this.driverClassName;
    }

    public static enum Type {
        H2,
        MYSQL,
        MARIADB,
        POSTGRES,
        MSSQL,
        SYBASE,
        ORACLE,
        GENERIC;

    }
}

