/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.db;

import com.d3x.core.db.DatabaseDriver;
import com.d3x.core.db.DatabaseException;
import com.d3x.core.json.Json;
import com.d3x.core.json.JsonEngine;
import com.d3x.core.json.JsonSchema;
import com.d3x.core.util.Crypto;
import com.d3x.core.util.IO;
import com.d3x.core.util.Option;
import com.d3x.core.util.Secret;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConfig {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConfig.class);
    public static final JsonSchema schema = JsonSchema.of(DatabaseConfig.class, (String)"db-config", (int)1);
    @NonNull
    private DatabaseDriver driver;
    @NonNull
    private String url;
    @NonNull
    private Option<String> user;
    @NonNull
    private Option<Secret> password;
    @NonNull
    private Option<Integer> initialPoolSize;
    @NonNull
    private Option<Integer> maxPoolSize;
    @NonNull
    private Option<Integer> maxPoolIdleSize;
    @NonNull
    private Option<Boolean> readOnly;
    @NonNull
    private Option<Boolean> autoCommit;
    @NonNull
    private Option<Integer> queryTimeOutSeconds;
    @NonNull
    private Option<Integer> maxWaitTimeMillis;
    @NonNull
    private Option<Integer> fetchSize;
    @NonNull
    private Map<String, String> properties;

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public static DatabaseConfig h2(File dbFile, String user, String password) {
        return DatabaseConfig.of(config -> {
            config.driver(DatabaseDriver.H2);
            config.url("jdbc:h2:file:" + dbFile.getAbsolutePath());
            config.user((Option<String>)Option.of((Object)user));
            config.password((Option<Secret>)Option.of((Object)Secret.of((String)password)));
            config.properties(new HashMap<String, String>());
        });
    }

    public static DatabaseConfig mysql(String url, String username, Secret password) {
        return DatabaseConfig.of(config -> {
            config.driver(DatabaseDriver.MYSQL);
            config.url(url);
            config.user((Option<String>)Option.of((Object)username));
            config.password((Option<Secret>)Option.of((Object)password));
            config.properties(new HashMap<String, String>());
        });
    }

    public static DatabaseConfig of(DatabaseDriver driver, String url, String user, Secret password) {
        return DatabaseConfig.of(config -> {
            config.driver(driver);
            config.url(url);
            config.user((Option<String>)Option.of((Object)user));
            config.password((Option<Secret>)Option.of((Object)password));
            config.properties(new HashMap<String, String>());
        });
    }

    public static DatabaseConfig fromJson(URL url, Option<Crypto> crypto) throws IOException {
        return (DatabaseConfig)DatabaseConfig.gson(crypto).fromJson((Reader)new InputStreamReader(url.openStream()), DatabaseConfig.class);
    }

    public static DatabaseConfig fromJson(String resource) throws DatabaseException {
        try {
            URL url = DatabaseConfig.class.getResource(resource);
            if (url == null) {
                throw new RuntimeException("No config resource for path: " + resource);
            }
            File home = new File(System.getProperty("user.home"));
            String keyPath = new File(home, ".d3x/keys/db.key").getAbsolutePath();
            File keyFile = new File(System.getProperty("db.key", keyPath));
            if (!keyFile.exists()) {
                throw new RuntimeException("Missing cryptographic secret key at: " + keyFile.getAbsolutePath());
            }
            URL keyUrl = keyFile.toURI().toURL();
            Crypto crypto = Crypto.withSecretKey((String)"AES", (URL)keyUrl);
            log.info("Loading database config from: " + resource);
            return DatabaseConfig.fromJson(url, (Option<Crypto>)Option.of((Object)crypto));
        }
        catch (Exception ex) {
            throw new DatabaseException("Failed to initialise database from config: " + resource, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toJson(Option<Crypto> crypto, OutputStream os) throws IOException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), StandardCharsets.UTF_8);
            DatabaseConfig.gson(crypto).toJson((Object)this, (Appendable)writer);
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    public static DatabaseConfig of(Consumer<DatabaseConfigBuilder> consumer) {
        DatabaseConfigBuilder builder = DatabaseConfig.builder();
        builder.readOnly((Option<Boolean>)Option.of((Object)false));
        builder.autoCommit((Option<Boolean>)Option.of((Object)true));
        builder.queryTimeOutSeconds((Option<Integer>)Option.of((Object)60));
        builder.initialPoolSize((Option<Integer>)Option.of((Object)5));
        builder.maxPoolSize((Option<Integer>)Option.of((Object)10));
        builder.maxWaitTimeMillis((Option<Integer>)Option.of((Object)5000));
        builder.maxPoolIdleSize((Option<Integer>)Option.of((Object)10));
        builder.fetchSize((Option<Integer>)Option.empty());
        consumer.accept(builder);
        return builder.build();
    }

    public static Gson gson(Option<Crypto> crypto) {
        JsonEngine engine = new JsonEngine();
        engine.register(schema, (JsonSerializer)new Serializer());
        engine.register(schema, (JsonDeserializer)new Deserializer());
        if (crypto.isEmpty()) {
            return engine.getGson(1);
        }
        engine.crypto((Crypto)crypto.get());
        return engine.getGson(1);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseConfig verify() {
        DatabaseConfig databaseConfig;
        Connection conn = null;
        String className = this.driver.getDriverClassName();
        try {
            log.info("Connecting to " + this.url);
            Class.forName(className);
            String pass = (String)this.password.map(p -> new String(p.getValue())).orNull();
            conn = DriverManager.getConnection(this.url, (String)this.user.orNull(), pass);
            log.info("Connection successful to " + this.url);
            databaseConfig = this;
        }
        catch (ClassNotFoundException ex) {
            try {
                throw new DatabaseException("Failed to load JDBC driver class " + className, ex);
                catch (SQLException ex2) {
                    throw new DatabaseException("Failed to connect to database with " + this.url, ex2);
                }
            }
            catch (Throwable throwable) {
                IO.close((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        IO.close((AutoCloseable[])new AutoCloseable[]{conn});
        return databaseConfig;
    }

    public static DatabaseConfigBuilder builder() {
        return new DatabaseConfigBuilder();
    }

    public DatabaseConfigBuilder toBuilder() {
        return new DatabaseConfigBuilder().driver(this.driver).url(this.url).user(this.user).password(this.password).initialPoolSize(this.initialPoolSize).maxPoolSize(this.maxPoolSize).maxPoolIdleSize(this.maxPoolIdleSize).readOnly(this.readOnly).autoCommit(this.autoCommit).queryTimeOutSeconds(this.queryTimeOutSeconds).maxWaitTimeMillis(this.maxWaitTimeMillis).fetchSize(this.fetchSize).properties(this.properties);
    }

    public String toString() {
        return "DatabaseConfig(driver=" + this.getDriver() + ", url=" + this.getUrl() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", initialPoolSize=" + this.getInitialPoolSize() + ", maxPoolSize=" + this.getMaxPoolSize() + ", maxPoolIdleSize=" + this.getMaxPoolIdleSize() + ", readOnly=" + this.getReadOnly() + ", autoCommit=" + this.getAutoCommit() + ", queryTimeOutSeconds=" + this.getQueryTimeOutSeconds() + ", maxWaitTimeMillis=" + this.getMaxWaitTimeMillis() + ", fetchSize=" + this.getFetchSize() + ", properties=" + this.getProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseConfig)) {
            return false;
        }
        DatabaseConfig other = (DatabaseConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DatabaseDriver this$driver = this.getDriver();
        DatabaseDriver other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !((Object)this$driver).equals(other$driver)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Option<String> this$user = this.getUser();
        Option<String> other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        Option<Secret> this$password = this.getPassword();
        Option<Secret> other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Option<Integer> this$initialPoolSize = this.getInitialPoolSize();
        Option<Integer> other$initialPoolSize = other.getInitialPoolSize();
        if (this$initialPoolSize == null ? other$initialPoolSize != null : !this$initialPoolSize.equals(other$initialPoolSize)) {
            return false;
        }
        Option<Integer> this$maxPoolSize = this.getMaxPoolSize();
        Option<Integer> other$maxPoolSize = other.getMaxPoolSize();
        if (this$maxPoolSize == null ? other$maxPoolSize != null : !this$maxPoolSize.equals(other$maxPoolSize)) {
            return false;
        }
        Option<Integer> this$maxPoolIdleSize = this.getMaxPoolIdleSize();
        Option<Integer> other$maxPoolIdleSize = other.getMaxPoolIdleSize();
        if (this$maxPoolIdleSize == null ? other$maxPoolIdleSize != null : !this$maxPoolIdleSize.equals(other$maxPoolIdleSize)) {
            return false;
        }
        Option<Boolean> this$readOnly = this.getReadOnly();
        Option<Boolean> other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !this$readOnly.equals(other$readOnly)) {
            return false;
        }
        Option<Boolean> this$autoCommit = this.getAutoCommit();
        Option<Boolean> other$autoCommit = other.getAutoCommit();
        if (this$autoCommit == null ? other$autoCommit != null : !this$autoCommit.equals(other$autoCommit)) {
            return false;
        }
        Option<Integer> this$queryTimeOutSeconds = this.getQueryTimeOutSeconds();
        Option<Integer> other$queryTimeOutSeconds = other.getQueryTimeOutSeconds();
        if (this$queryTimeOutSeconds == null ? other$queryTimeOutSeconds != null : !this$queryTimeOutSeconds.equals(other$queryTimeOutSeconds)) {
            return false;
        }
        Option<Integer> this$maxWaitTimeMillis = this.getMaxWaitTimeMillis();
        Option<Integer> other$maxWaitTimeMillis = other.getMaxWaitTimeMillis();
        if (this$maxWaitTimeMillis == null ? other$maxWaitTimeMillis != null : !this$maxWaitTimeMillis.equals(other$maxWaitTimeMillis)) {
            return false;
        }
        Option<Integer> this$fetchSize = this.getFetchSize();
        Option<Integer> other$fetchSize = other.getFetchSize();
        if (this$fetchSize == null ? other$fetchSize != null : !this$fetchSize.equals(other$fetchSize)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DatabaseDriver $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : ((Object)$driver).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Option<String> $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        Option<Secret> $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Option<Integer> $initialPoolSize = this.getInitialPoolSize();
        result = result * 59 + ($initialPoolSize == null ? 43 : $initialPoolSize.hashCode());
        Option<Integer> $maxPoolSize = this.getMaxPoolSize();
        result = result * 59 + ($maxPoolSize == null ? 43 : $maxPoolSize.hashCode());
        Option<Integer> $maxPoolIdleSize = this.getMaxPoolIdleSize();
        result = result * 59 + ($maxPoolIdleSize == null ? 43 : $maxPoolIdleSize.hashCode());
        Option<Boolean> $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : $readOnly.hashCode());
        Option<Boolean> $autoCommit = this.getAutoCommit();
        result = result * 59 + ($autoCommit == null ? 43 : $autoCommit.hashCode());
        Option<Integer> $queryTimeOutSeconds = this.getQueryTimeOutSeconds();
        result = result * 59 + ($queryTimeOutSeconds == null ? 43 : $queryTimeOutSeconds.hashCode());
        Option<Integer> $maxWaitTimeMillis = this.getMaxWaitTimeMillis();
        result = result * 59 + ($maxWaitTimeMillis == null ? 43 : $maxWaitTimeMillis.hashCode());
        Option<Integer> $fetchSize = this.getFetchSize();
        result = result * 59 + ($fetchSize == null ? 43 : $fetchSize.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public DatabaseConfig(@NonNull DatabaseDriver driver, @NonNull String url, @NonNull Option<String> user, @NonNull Option<Secret> password, @NonNull Option<Integer> initialPoolSize, @NonNull Option<Integer> maxPoolSize, @NonNull Option<Integer> maxPoolIdleSize, @NonNull Option<Boolean> readOnly, @NonNull Option<Boolean> autoCommit, @NonNull Option<Integer> queryTimeOutSeconds, @NonNull Option<Integer> maxWaitTimeMillis, @NonNull Option<Integer> fetchSize, @NonNull Map<String, String> properties) {
        if (driver == null) {
            throw new NullPointerException("driver is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (initialPoolSize == null) {
            throw new NullPointerException("initialPoolSize is marked non-null but is null");
        }
        if (maxPoolSize == null) {
            throw new NullPointerException("maxPoolSize is marked non-null but is null");
        }
        if (maxPoolIdleSize == null) {
            throw new NullPointerException("maxPoolIdleSize is marked non-null but is null");
        }
        if (readOnly == null) {
            throw new NullPointerException("readOnly is marked non-null but is null");
        }
        if (autoCommit == null) {
            throw new NullPointerException("autoCommit is marked non-null but is null");
        }
        if (queryTimeOutSeconds == null) {
            throw new NullPointerException("queryTimeOutSeconds is marked non-null but is null");
        }
        if (maxWaitTimeMillis == null) {
            throw new NullPointerException("maxWaitTimeMillis is marked non-null but is null");
        }
        if (fetchSize == null) {
            throw new NullPointerException("fetchSize is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
        this.initialPoolSize = initialPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.maxPoolIdleSize = maxPoolIdleSize;
        this.readOnly = readOnly;
        this.autoCommit = autoCommit;
        this.queryTimeOutSeconds = queryTimeOutSeconds;
        this.maxWaitTimeMillis = maxWaitTimeMillis;
        this.fetchSize = fetchSize;
        this.properties = properties;
    }

    @NonNull
    public DatabaseDriver getDriver() {
        return this.driver;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public Option<String> getUser() {
        return this.user;
    }

    @NonNull
    public Option<Secret> getPassword() {
        return this.password;
    }

    @NonNull
    public Option<Integer> getInitialPoolSize() {
        return this.initialPoolSize;
    }

    @NonNull
    public Option<Integer> getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @NonNull
    public Option<Integer> getMaxPoolIdleSize() {
        return this.maxPoolIdleSize;
    }

    @NonNull
    public Option<Boolean> getReadOnly() {
        return this.readOnly;
    }

    @NonNull
    public Option<Boolean> getAutoCommit() {
        return this.autoCommit;
    }

    @NonNull
    public Option<Integer> getQueryTimeOutSeconds() {
        return this.queryTimeOutSeconds;
    }

    @NonNull
    public Option<Integer> getMaxWaitTimeMillis() {
        return this.maxWaitTimeMillis;
    }

    @NonNull
    public Option<Integer> getFetchSize() {
        return this.fetchSize;
    }

    public static class DatabaseConfigBuilder {
        private DatabaseDriver driver;
        private String url;
        private Option<String> user;
        private Option<Secret> password;
        private Option<Integer> initialPoolSize;
        private Option<Integer> maxPoolSize;
        private Option<Integer> maxPoolIdleSize;
        private Option<Boolean> readOnly;
        private Option<Boolean> autoCommit;
        private Option<Integer> queryTimeOutSeconds;
        private Option<Integer> maxWaitTimeMillis;
        private Option<Integer> fetchSize;
        private Map<String, String> properties;

        DatabaseConfigBuilder() {
        }

        public DatabaseConfigBuilder driver(@NonNull DatabaseDriver driver) {
            if (driver == null) {
                throw new NullPointerException("driver is marked non-null but is null");
            }
            this.driver = driver;
            return this;
        }

        public DatabaseConfigBuilder url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        public DatabaseConfigBuilder user(@NonNull Option<String> user) {
            if (user == null) {
                throw new NullPointerException("user is marked non-null but is null");
            }
            this.user = user;
            return this;
        }

        public DatabaseConfigBuilder password(@NonNull Option<Secret> password) {
            if (password == null) {
                throw new NullPointerException("password is marked non-null but is null");
            }
            this.password = password;
            return this;
        }

        public DatabaseConfigBuilder initialPoolSize(@NonNull Option<Integer> initialPoolSize) {
            if (initialPoolSize == null) {
                throw new NullPointerException("initialPoolSize is marked non-null but is null");
            }
            this.initialPoolSize = initialPoolSize;
            return this;
        }

        public DatabaseConfigBuilder maxPoolSize(@NonNull Option<Integer> maxPoolSize) {
            if (maxPoolSize == null) {
                throw new NullPointerException("maxPoolSize is marked non-null but is null");
            }
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public DatabaseConfigBuilder maxPoolIdleSize(@NonNull Option<Integer> maxPoolIdleSize) {
            if (maxPoolIdleSize == null) {
                throw new NullPointerException("maxPoolIdleSize is marked non-null but is null");
            }
            this.maxPoolIdleSize = maxPoolIdleSize;
            return this;
        }

        public DatabaseConfigBuilder readOnly(@NonNull Option<Boolean> readOnly) {
            if (readOnly == null) {
                throw new NullPointerException("readOnly is marked non-null but is null");
            }
            this.readOnly = readOnly;
            return this;
        }

        public DatabaseConfigBuilder autoCommit(@NonNull Option<Boolean> autoCommit) {
            if (autoCommit == null) {
                throw new NullPointerException("autoCommit is marked non-null but is null");
            }
            this.autoCommit = autoCommit;
            return this;
        }

        public DatabaseConfigBuilder queryTimeOutSeconds(@NonNull Option<Integer> queryTimeOutSeconds) {
            if (queryTimeOutSeconds == null) {
                throw new NullPointerException("queryTimeOutSeconds is marked non-null but is null");
            }
            this.queryTimeOutSeconds = queryTimeOutSeconds;
            return this;
        }

        public DatabaseConfigBuilder maxWaitTimeMillis(@NonNull Option<Integer> maxWaitTimeMillis) {
            if (maxWaitTimeMillis == null) {
                throw new NullPointerException("maxWaitTimeMillis is marked non-null but is null");
            }
            this.maxWaitTimeMillis = maxWaitTimeMillis;
            return this;
        }

        public DatabaseConfigBuilder fetchSize(@NonNull Option<Integer> fetchSize) {
            if (fetchSize == null) {
                throw new NullPointerException("fetchSize is marked non-null but is null");
            }
            this.fetchSize = fetchSize;
            return this;
        }

        public DatabaseConfigBuilder properties(@NonNull Map<String, String> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties;
            return this;
        }

        public DatabaseConfig build() {
            return new DatabaseConfig(this.driver, this.url, this.user, this.password, this.initialPoolSize, this.maxPoolSize, this.maxPoolIdleSize, this.readOnly, this.autoCommit, this.queryTimeOutSeconds, this.maxWaitTimeMillis, this.fetchSize, this.properties);
        }

        public String toString() {
            return "DatabaseConfig.DatabaseConfigBuilder(driver=" + this.driver + ", url=" + this.url + ", user=" + this.user + ", password=" + this.password + ", initialPoolSize=" + this.initialPoolSize + ", maxPoolSize=" + this.maxPoolSize + ", maxPoolIdleSize=" + this.maxPoolIdleSize + ", readOnly=" + this.readOnly + ", autoCommit=" + this.autoCommit + ", queryTimeOutSeconds=" + this.queryTimeOutSeconds + ", maxWaitTimeMillis=" + this.maxWaitTimeMillis + ", fetchSize=" + this.fetchSize + ", properties=" + this.properties + ")";
        }
    }

    public static class Deserializer
    implements JsonDeserializer<DatabaseConfig> {
        public DatabaseConfig deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (json == null || json == JsonNull.INSTANCE) {
                return null;
            }
            JsonObject object = json.getAsJsonObject();
            HashMap<String, String> properties = new HashMap<String, String>();
            JsonObject propObject = (JsonObject)Json.getObject((JsonObject)object, (String)"properties").orElse((Object)new JsonObject());
            propObject.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                String value = ((JsonElement)entry.getValue()).getAsString();
                if (value != null) {
                    properties.put(key, value);
                }
            });
            return DatabaseConfig.builder().driver(DatabaseDriver.of(Json.getStringOrFail((JsonObject)object, (String)"driver"))).url(Json.getStringOrFail((JsonObject)object, (String)"url")).user((Option<String>)Json.getString((JsonObject)object, (String)"user")).password((Option<Secret>)Json.getElement((JsonObject)object, (String)"password").map(e -> (Secret)context.deserialize(e, Secret.class))).initialPoolSize((Option<Integer>)Json.getInt((JsonObject)object, (String)"initialPoolSize")).maxPoolSize((Option<Integer>)Json.getInt((JsonObject)object, (String)"maxPoolSize")).maxPoolIdleSize((Option<Integer>)Json.getInt((JsonObject)object, (String)"maxPoolIdleSize")).readOnly((Option<Boolean>)Json.getBoolean((JsonObject)object, (String)"readOnly")).autoCommit((Option<Boolean>)Json.getBoolean((JsonObject)object, (String)"autoCommit")).queryTimeOutSeconds((Option<Integer>)Json.getInt((JsonObject)object, (String)"queryTimeOutSeconds")).maxWaitTimeMillis((Option<Integer>)Json.getInt((JsonObject)object, (String)"maxWaitTimeMills")).fetchSize((Option<Integer>)Json.getInt((JsonObject)object, (String)"fetchSize")).properties(properties).build();
        }
    }

    public static class Serializer
    implements JsonSerializer<DatabaseConfig> {
        public JsonElement serialize(DatabaseConfig record, Type type, JsonSerializationContext context) {
            if (record == null) {
                return JsonNull.INSTANCE;
            }
            return Json.object(object -> {
                object.addProperty("driver", record.getDriver().getDriverClassName());
                object.addProperty("url", record.getUrl());
                object.addProperty("user", (String)record.getUser().orNull());
                object.add("password", context.serialize(record.getPassword().orNull(), Secret.class));
                object.addProperty("initialPoolSize", (Number)record.initialPoolSize.orNull());
                object.addProperty("maxPoolSize", (Number)record.maxPoolSize.orNull());
                object.addProperty("maxPoolIdleSize", (Number)record.maxPoolIdleSize.orNull());
                object.addProperty("readOnly", (Boolean)record.readOnly.orNull());
                object.addProperty("autoCommit", (Boolean)record.autoCommit.orNull());
                object.addProperty("queryTimeOutSeconds", (Number)record.queryTimeOutSeconds.orNull());
                object.addProperty("maxWaitTimeMills", (Number)record.maxWaitTimeMillis.orNull());
                object.addProperty("fetchSize", (Number)record.fetchSize.orNull());
                object.add("properties", (JsonElement)Json.object(props -> {
                    Stream keys = record.properties.keySet().stream().sorted();
                    keys.forEach(key -> {
                        String value = record.properties.get(key);
                        if (value != null) {
                            props.addProperty(key, value);
                        }
                    });
                }));
            });
        }
    }
}

