/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.core.db;

import com.d3x.core.db.DatabaseConfig;
import com.d3x.core.db.DatabaseException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DataSourceAdapter {
    public void close(DataSource var1);

    public DataSource create(DatabaseConfig var1) throws DatabaseException;

    public static class Apache
    implements DataSourceAdapter {
        private static final Logger log = LoggerFactory.getLogger(Apache.class);

        @Override
        public DataSource create(DatabaseConfig config) throws DatabaseException {
            log.info("Creating DataSource with " + config);
            BasicDataSource dataSource = new BasicDataSource();
            dataSource.setDriverClassName(config.getDriver().getDriverClassName());
            dataSource.setUrl(config.getUrl());
            dataSource.setUsername((String)config.getUser().orNull());
            dataSource.setPassword((String)config.getPassword().map(p -> new String(p.getValue())).orNull());
            dataSource.setInitialSize(((Integer)config.getInitialPoolSize().orElse((Object)5)).intValue());
            dataSource.setMaxTotal(((Integer)config.getMaxPoolSize().orElse((Object)5)).intValue());
            dataSource.setMaxIdle(((Integer)config.getMaxPoolIdleSize().orElse((Object)5)).intValue());
            dataSource.setDefaultReadOnly((Boolean)config.getReadOnly().orElse((Object)false));
            dataSource.setDefaultQueryTimeout((Integer)config.getQueryTimeOutSeconds().orElse((Object)60));
            dataSource.setMaxWaitMillis((long)((Integer)config.getMaxWaitTimeMillis().orElse((Object)5000)).intValue());
            config.getProperties().keySet().stream().sorted().forEach(key -> {
                String value = config.getProperties().get(key);
                log.info(String.format("Setting connection property %s = %s for %s", key, value, config.getUrl()));
                dataSource.addConnectionProperty(key, value);
            });
            return dataSource;
        }

        @Override
        public void close(DataSource source) {
            try {
                if (source instanceof BasicDataSource) {
                    ((BasicDataSource)source).close();
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

