/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.arrays;

import com.datastax.driver.core.CodecUtils;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.extras.codecs.arrays.AbstractArrayCodec;
import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

public abstract class AbstractPrimitiveArrayCodec<T>
extends AbstractArrayCodec<T> {
    public AbstractPrimitiveArrayCodec(DataType.CollectionType cqlType, Class<T> javaClass) {
        super(cqlType, javaClass);
        Preconditions.checkArgument(javaClass.getComponentType().isPrimitive(), "Expecting primitive array component type, got %s", new Object[]{javaClass.getComponentType()});
    }

    @Override
    public ByteBuffer serialize(T array, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (array == null) {
            return null;
        }
        boolean isProtocolV3OrAbove = protocolVersion.compareTo(ProtocolVersion.V2) > 0;
        int length = Array.getLength(array);
        Preconditions.checkArgument(isProtocolV3OrAbove || length < 65536, "Native protocol version %d supports up to 65535 elements in any collection - but collection contains %d elements", new Object[]{protocolVersion.toInt(), length});
        int sizeOfSize = isProtocolV3OrAbove ? 4 : 2;
        int sizeOfElement = sizeOfSize + this.sizeOfComponentType();
        int totalSize = sizeOfSize + length * sizeOfElement;
        ByteBuffer output = ByteBuffer.allocate(totalSize);
        CodecUtils.writeSize(output, length, protocolVersion);
        for (int i = 0; i < length; ++i) {
            CodecUtils.writeSize(output, this.sizeOfComponentType(), protocolVersion);
            this.serializeElement(output, array, i, protocolVersion);
        }
        output.flip();
        return output;
    }

    @Override
    public T deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (bytes == null || bytes.remaining() == 0) {
            return this.newInstance(0);
        }
        boolean isProtocolV3OrAbove = protocolVersion.compareTo(ProtocolVersion.V2) > 0;
        int sizeOfSize = isProtocolV3OrAbove ? 4 : 2;
        ByteBuffer input = bytes.duplicate();
        int size = CodecUtils.readSize(input, protocolVersion);
        Object array = this.newInstance(size);
        for (int i = 0; i < size; ++i) {
            input.position(input.position() + sizeOfSize);
            this.deserializeElement(input, array, i, protocolVersion);
        }
        return array;
    }

    protected abstract int sizeOfComponentType();

    protected abstract void serializeElement(ByteBuffer var1, T var2, int var3, ProtocolVersion var4);

    protected abstract void deserializeElement(ByteBuffer var1, T var2, int var3, ProtocolVersion var4);
}

