/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.schemabuilder.SchemaStatement;
import com.datastax.driver.core.schemabuilder.StatementStart;
import com.google.common.base.Optional;

public class CreateIndex
implements StatementStart {
    private String indexName;
    private boolean ifNotExists = false;
    private Optional<String> keyspaceName = Optional.absent();
    private String tableName;
    private String columnName;
    private boolean keys;

    CreateIndex(String indexName) {
        SchemaStatement.validateNotEmpty(indexName, "Index name");
        SchemaStatement.validateNotKeyWord(indexName, String.format("The index name '%s' is not allowed because it is a reserved keyword", indexName));
        this.indexName = indexName;
    }

    public CreateIndex ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    public CreateIndexOn onTable(String keyspaceName, String tableName) {
        SchemaStatement.validateNotEmpty(keyspaceName, "Keyspace name");
        SchemaStatement.validateNotEmpty(tableName, "Table name");
        SchemaStatement.validateNotKeyWord(keyspaceName, String.format("The keyspace name '%s' is not allowed because it is a reserved keyword", keyspaceName));
        SchemaStatement.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.keyspaceName = Optional.fromNullable(keyspaceName);
        this.tableName = tableName;
        return new CreateIndexOn();
    }

    public CreateIndexOn onTable(String tableName) {
        SchemaStatement.validateNotEmpty(tableName, "Table name");
        SchemaStatement.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.tableName = tableName;
        return new CreateIndexOn();
    }

    @Override
    public String buildInternal() {
        StringBuilder createStatement = new StringBuilder("\n\t").append("CREATE INDEX ");
        if (this.ifNotExists) {
            createStatement.append("IF NOT EXISTS ");
        }
        createStatement.append(this.indexName).append(" ON ");
        if (this.keyspaceName.isPresent()) {
            createStatement.append(this.keyspaceName.get()).append(".");
        }
        createStatement.append(this.tableName);
        createStatement.append("(");
        if (this.keys) {
            createStatement.append("KEYS(");
        }
        createStatement.append(this.columnName);
        if (this.keys) {
            createStatement.append(")");
        }
        createStatement.append(")");
        return createStatement.toString();
    }

    public class CreateIndexOn {
        public SchemaStatement andColumn(String columnName) {
            SchemaStatement.validateNotEmpty(columnName, "Column name");
            SchemaStatement.validateNotKeyWord(columnName, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName));
            CreateIndex.this.columnName = columnName;
            return SchemaStatement.fromQueryString(CreateIndex.this.buildInternal());
        }

        public SchemaStatement andKeysOfColumn(String columnName) {
            SchemaStatement.validateNotEmpty(columnName, "Column name");
            SchemaStatement.validateNotKeyWord(columnName, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName));
            CreateIndex.this.columnName = columnName;
            CreateIndex.this.keys = true;
            return SchemaStatement.fromQueryString(CreateIndex.this.buildInternal());
        }
    }
}

