/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.mysql;

import com.d0x7.utils.config.ConfigUtils;
import com.d0x7.utils.database.Database;
import com.d0x7.utils.mysql.MySQLConfiguration;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class MySQL {
    private static Connection connection;
    private static boolean initialized;

    public static ListenableFuture<Boolean> setup() {
        if (ConfigUtils.get(MySQLConfiguration.class) == null) {
            try {
                ConfigUtils.loadConfigurationFile(new File(System.getProperty("user.home"), "mysql.database.json"), MySQLConfiguration.class);
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return Futures.immediateFailedFuture(e);
            }
        }
        return MySQL.setup(ConfigUtils.get(MySQLConfiguration.class));
    }

    public static ListenableFuture<Boolean> setup(MySQLConfiguration mySQLConfiguration) {
        if (initialized) {
            return Futures.immediateFuture(true);
        }
        initialized = true;
        return Database.getExecutorService().submit(() -> {
            connection = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s?useUnicode=true&characterEncoding=utf8", mySQLConfiguration.getHostname(), mySQLConfiguration.getPort(), mySQLConfiguration.getDatabase()), mySQLConfiguration.getUsername(), mySQLConfiguration.getPassword());
            return !connection.isClosed();
        });
    }

    public static void shutdown() {
        try {
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static boolean isConnected() {
        try {
            return connection.isValid(3);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public static Connection getConnection() {
        return connection;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        initialized = false;
    }
}

