/*
 * Decompiled with CFR 0.152.
 */
package com.d_codepages.sarathkumar.vectray;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.TextView;
import com.d_codepages.sarathkumar.vectray.Icon;
import com.d_codepages.sarathkumar.vectray.IconDrawable;
import com.d_codepages.sarathkumar.vectray.ParseUtil;
import com.d_codepages.sarathkumar.vectray.R;
import com.d_codepages.sarathkumar.vectray.VectrayDrawable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;

public class VectRay {
    public static final String FONTAWSOME = "fontawesome-webfont.ttf";
    private Object target;
    private Context context;
    private String pck_name;
    private TextView IconTextView;
    private List<String> descriptions;
    private HashMap<String, String> Custom_fontsets = new HashMap();

    public VectRay(Context con, String package_name) {
        this.context = con;
        this.pck_name = package_name;
        this.annotationProcess();
    }

    public void LoadCustomTypeface(String Key, String TypeFace) {
        this.Custom_fontsets.put(Key, TypeFace);
    }

    private void annotationProcess() {
        Field[] fields;
        for (Field field : fields = this.context.getClass().getFields()) {
            VectrayDrawable vDrawble = field.getAnnotation(VectrayDrawable.class);
            if (vDrawble == null || field.getType() != Drawable.class && field.getType() != IconDrawable.class) continue;
            IconDrawable icn = new IconDrawable(this.context, this.get_icon(vDrawble.Icon()));
            icn.color(vDrawble.Color());
            icn.sizeDp(vDrawble.Dp());
            this.target = this.context;
            try {
                field.set(this.target, (Object)icn);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public void initIcons(ViewGroup view) {
        for (int i = view.getChildCount() - 1; i >= 0; --i) {
            View child = view.getChildAt(i);
            if (child instanceof ViewGroup) {
                this.initIcons((ViewGroup)child);
                continue;
            }
            if (child == null || !(child instanceof TextView)) continue;
            this.IconTextView = (TextView)child;
            String data = this.IconTextView.getText().toString().trim();
            Icon icon = this.get_icon(data);
            if (icon == null) continue;
            this.SetString(icon.getString());
            this.TypeFaceSet(icon.getTypeface());
            if (!icon.isAnimated()) continue;
            this.IconTextView.startAnimation(icon.getAnimation());
        }
    }

    private void SetString(String string) {
        this.IconTextView.setText((CharSequence)string);
    }

    private void TypeFaceSet(Typeface typeface) {
        this.IconTextView.setTypeface(typeface);
    }

    public Icon get_icon(String data) {
        Icon icon = new Icon();
        if (!data.isEmpty() && data.startsWith("{")) {
            this.descriptions = ParseUtil.descriptor(data);
            if (!this.descriptions.isEmpty() && this.descriptions.size() > 1) {
                switch (this.descriptions.get(0)) {
                    case "fa": {
                        icon.setTypeface(this.getTypeface(FONTAWSOME));
                        break;
                    }
                    default: {
                        String type;
                        String key = this.descriptions.get(0);
                        if (!this.Custom_fontsets.containsKey(key) || (type = this.Custom_fontsets.get(key)).isEmpty() && !type.equals("")) break;
                        icon.setTypeface(this.getTypeface(type));
                    }
                }
                String key_to_string = this.descriptions.get(1);
                if (!key_to_string.isEmpty()) {
                    icon.setString(this.context.getString(this.get_string_id(key_to_string)));
                }
                if (this.descriptions.size() > 2) {
                    switch (this.descriptions.get(2)) {
                        case "spin": {
                            icon.setIsAnimated(true);
                            icon.setAnimation(AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.rotate));
                        }
                    }
                }
                return icon;
            }
        }
        return null;
    }

    private int get_string_id(String key) {
        try {
            Class<?> res = Class.forName(this.pck_name + ".R$string");
            Field field = res.getField(key);
            return field.getInt(null);
        }
        catch (Exception e) {
            Log.e((String)"Vectray", (String)"Failure to get String id Check String.xml.", (Throwable)e);
            return 0;
        }
    }

    private Typeface getTypeface(String font) {
        AssetManager assetManager = this.context.getAssets();
        return Typeface.createFromAsset((AssetManager)assetManager, (String)font);
    }
}

