/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.presentation;

import android.os.Build;
import android.util.JsonReader;
import android.util.JsonWriter;
import android.util.Log;
import android.view.Display;
import android.view.ViewGroup;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import org.chromium.base.ThreadUtils;
import org.xwalk.core.internal.extension.XWalkExtension;
import org.xwalk.core.internal.extension.XWalkExtensionContext;
import org.xwalk.core.internal.extension.api.XWalkDisplayManager;
import org.xwalk.core.internal.extension.api.presentation.PresentationView;
import org.xwalk.core.internal.extension.api.presentation.XWalkPresentationContent;

public class PresentationExtension
extends XWalkExtension {
    public static final String JS_API_PATH = "jsapi/presentation_api.js";
    private static final String NAME = "navigator.presentation";
    private static final String TAG = "PresentationExtension";
    private static final String TAG_BASE_URL = "baseUrl";
    private static final String TAG_CMD = "cmd";
    private static final String TAG_DATA = "data";
    private static final String TAG_REQUEST_ID = "requestId";
    private static final String TAG_URL = "url";
    private static final String CMD_DISPLAY_AVAILABLE_CHANGE = "DisplayAvailableChange";
    private static final String CMD_QUERY_DISPLAY_AVAILABILITY = "QueryDisplayAvailability";
    private static final String CMD_REQUEST_SHOW = "RequestShow";
    private static final String CMD_SHOW_SUCCEEDED = "ShowSucceeded";
    private static final String CMD_SHOW_FAILED = "ShowFailed";
    private static final String ERROR_INVALID_ACCESS = "InvalidAccessError";
    private static final String ERROR_INVALID_PARAMETER = "InvalidParameterError";
    private static final String ERROR_INVALID_STATE = "InvalidStateError";
    private static final String ERROR_NOT_FOUND = "NotFoundError";
    private static final String ERROR_NOT_SUPPORTED = "NotSupportedError";
    private XWalkDisplayManager mDisplayManager;
    private int mAvailableDisplayCount = 0;
    private XWalkPresentationContent mPresentationContent;
    private XWalkPresentationContent.PresentationDelegate mPresentationDelegate;
    private PresentationView mPresentationView;
    private final XWalkDisplayManager.DisplayListener mDisplayListener = new XWalkDisplayManager.DisplayListener(){

        public void onDisplayAdded(int displayId) {
            ++PresentationExtension.this.mAvailableDisplayCount;
            if (PresentationExtension.this.mAvailableDisplayCount == 1) {
                PresentationExtension.this.notifyAvailabilityChanged(true);
            }
        }

        public void onDisplayRemoved(int displayId) {
            --PresentationExtension.this.mAvailableDisplayCount;
            if (PresentationExtension.this.mAvailableDisplayCount == 0) {
                PresentationExtension.this.notifyAvailabilityChanged(false);
                PresentationExtension.this.closePresentationContent();
            }
        }

        public void onDisplayChanged(int displayId) {
        }
    };

    public PresentationExtension(String jsApi, XWalkExtensionContext context) {
        super(NAME, jsApi, context);
        this.mDisplayManager = XWalkDisplayManager.getInstance(context.getContext());
        Display[] displays = this.mDisplayManager.getPresentationDisplays();
        this.mAvailableDisplayCount = displays.length;
    }

    private Display getPreferredDisplay() {
        Display[] displays = this.mDisplayManager.getPresentationDisplays();
        if (displays.length > 0) {
            return displays[0];
        }
        return null;
    }

    private void notifyAvailabilityChanged(boolean isAvailable) {
        StringWriter contents = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)contents);
        try {
            writer.beginObject();
            writer.name(TAG_CMD).value(CMD_DISPLAY_AVAILABLE_CHANGE);
            writer.name(TAG_DATA).value(isAvailable);
            writer.endObject();
            writer.close();
            this.broadcastMessage(contents.toString());
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error: " + e.toString()));
        }
    }

    private void notifyRequestShowSucceed(int instanceId, int requestId, int presentationId) {
        StringWriter contents = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)contents);
        try {
            writer.beginObject();
            writer.name(TAG_CMD).value(CMD_SHOW_SUCCEEDED);
            writer.name(TAG_REQUEST_ID).value((long)requestId);
            writer.name(TAG_DATA).value((long)presentationId);
            writer.endObject();
            writer.close();
            this.postMessage(instanceId, contents.toString());
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error: " + e.toString()));
        }
    }

    private void notifyRequestShowFail(int instanceId, int requestId, String errorMessage) {
        StringWriter contents = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)contents);
        try {
            writer.beginObject();
            writer.name(TAG_CMD).value(CMD_SHOW_FAILED);
            writer.name(TAG_REQUEST_ID).value((long)requestId);
            writer.name(TAG_DATA).value(errorMessage);
            writer.endObject();
            writer.close();
            this.postMessage(instanceId, contents.toString());
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error: " + e.toString()));
        }
    }

    public void onMessage(int instanceId, String message) {
        StringReader contents = new StringReader(message);
        JsonReader reader = new JsonReader((Reader)contents);
        int requestId = -1;
        String cmd = null;
        String url = null;
        String baseUrl = null;
        try {
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (name.equals(TAG_CMD)) {
                    cmd = reader.nextString();
                    continue;
                }
                if (name.equals(TAG_REQUEST_ID)) {
                    requestId = reader.nextInt();
                    continue;
                }
                if (name.equals(TAG_URL)) {
                    url = reader.nextString();
                    continue;
                }
                if (name.equals(TAG_BASE_URL)) {
                    baseUrl = reader.nextString();
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            reader.close();
            if (cmd != null && cmd.equals(CMD_REQUEST_SHOW) && requestId >= 0) {
                this.handleRequestShow(instanceId, requestId, url, baseUrl);
            }
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)("Error: " + e));
        }
    }

    private void handleRequestShow(final int instanceId, final int requestId, final String url, final String baseUrl) {
        if (Build.VERSION.SDK_INT < 17) {
            this.notifyRequestShowFail(instanceId, requestId, ERROR_NOT_SUPPORTED);
            return;
        }
        if (this.mAvailableDisplayCount == 0) {
            Log.d((String)TAG, (String)"No available presentation display is found.");
            this.notifyRequestShowFail(instanceId, requestId, ERROR_NOT_FOUND);
            return;
        }
        ThreadUtils.runOnUiThread(new Runnable(){

            public void run() {
                Display preferredDisplay = PresentationExtension.this.getPreferredDisplay();
                if (preferredDisplay == null) {
                    PresentationExtension.this.notifyRequestShowFail(instanceId, requestId, PresentationExtension.ERROR_NOT_FOUND);
                    return;
                }
                if (PresentationExtension.this.mPresentationContent != null) {
                    PresentationExtension.this.notifyRequestShowFail(instanceId, requestId, PresentationExtension.ERROR_INVALID_ACCESS);
                    return;
                }
                String targetUrl = url;
                URI targetUri = null;
                try {
                    targetUri = new URI(url);
                    if (!targetUri.isAbsolute()) {
                        URI baseUri = new URI(baseUrl);
                        targetUrl = baseUri.resolve(targetUri).toString();
                    }
                }
                catch (URISyntaxException e) {
                    Log.e((String)PresentationExtension.TAG, (String)"Invalid url passed to requestShow");
                    PresentationExtension.this.notifyRequestShowFail(instanceId, requestId, PresentationExtension.ERROR_INVALID_PARAMETER);
                    return;
                }
                PresentationExtension.this.mPresentationContent = new XWalkPresentationContent(PresentationExtension.this.mExtensionContext.getContext(), PresentationExtension.this.mExtensionContext.getActivity(), new XWalkPresentationContent.PresentationDelegate(){

                    public void onContentLoaded(XWalkPresentationContent content) {
                        PresentationExtension.this.notifyRequestShowSucceed(instanceId, requestId, content.getPresentationId());
                    }

                    public void onContentClosed(XWalkPresentationContent content) {
                        if (content == PresentationExtension.this.mPresentationContent) {
                            PresentationExtension.this.closePresentationContent();
                            if (PresentationExtension.this.mPresentationView != null) {
                                PresentationExtension.this.mPresentationView.cancel();
                            }
                        }
                    }
                });
                PresentationExtension.this.mPresentationContent.load(targetUrl);
                PresentationExtension.this.updatePresentationView(preferredDisplay);
            }
        });
    }

    public String onSyncMessage(int instanceId, String message) {
        if (message.equals(CMD_QUERY_DISPLAY_AVAILABILITY)) {
            return this.mAvailableDisplayCount != 0 ? "true" : "false";
        }
        Log.e((String)TAG, (String)("Unexpected sync message received: " + message));
        return "";
    }

    public void onResume() {
        Display[] displays = this.mDisplayManager.getPresentationDisplays();
        if (displays.length == 0 && this.mAvailableDisplayCount > 0) {
            this.notifyAvailabilityChanged(false);
            this.mAvailableDisplayCount = 0;
            this.closePresentationContent();
        }
        if (displays.length > 0 && this.mAvailableDisplayCount == 0) {
            this.notifyAvailabilityChanged(true);
            this.mAvailableDisplayCount = displays.length;
        }
        if (displays.length > 0 && this.mAvailableDisplayCount > 0) {
            this.mAvailableDisplayCount = displays.length;
        }
        if (this.mPresentationContent != null) {
            this.mPresentationContent.onResume();
        }
        this.updatePresentationView(this.getPreferredDisplay());
        this.mDisplayManager.registerDisplayListener(this.mDisplayListener);
    }

    private void updatePresentationView(Display preferredDisplay) {
        if (Build.VERSION.SDK_INT < 17 || preferredDisplay == null) {
            return;
        }
        if (this.mPresentationView == null && this.mPresentationContent == null) {
            return;
        }
        if (this.mPresentationView != null && this.mPresentationView.getDisplay() != preferredDisplay) {
            this.dismissPresentationView();
        }
        if (this.mPresentationView == null && this.mPresentationContent != null) {
            ViewGroup parent = (ViewGroup)this.mPresentationContent.getContentView().getParent();
            if (parent != null) {
                parent.removeView(this.mPresentationContent.getContentView());
            }
            this.mPresentationView = PresentationView.createInstance(this.mExtensionContext.getContext(), preferredDisplay);
            this.mPresentationView.setContentView(this.mPresentationContent.getContentView());
            this.mPresentationView.setPresentationListener(new PresentationView.PresentationListener(){

                public void onDismiss(PresentationView view) {
                    if (view == PresentationExtension.this.mPresentationView) {
                        if (PresentationExtension.this.mPresentationContent != null) {
                            PresentationExtension.this.mPresentationContent.onPause();
                        }
                        PresentationExtension.this.mPresentationView = null;
                    }
                }

                public void onShow(PresentationView view) {
                    if (view == PresentationExtension.this.mPresentationView && PresentationExtension.this.mPresentationContent != null) {
                        PresentationExtension.this.mPresentationContent.onResume();
                    }
                }
            });
        }
        this.mPresentationView.show();
    }

    public void onPause() {
        this.dismissPresentationView();
        if (this.mPresentationContent != null) {
            this.mPresentationContent.onPause();
        }
        this.mDisplayManager.unregisterDisplayListener(this.mDisplayListener);
    }

    public void onDestroy() {
        this.closePresentationContent();
    }

    private void dismissPresentationView() {
        if (this.mPresentationView == null) {
            return;
        }
        this.mPresentationView.dismiss();
        this.mPresentationView = null;
    }

    private void closePresentationContent() {
        if (this.mPresentationContent == null) {
            return;
        }
        this.mPresentationContent.close();
        this.mPresentationContent = null;
    }
}

