/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.messaging;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.api.messaging.Messaging;

public class MessagingSmsManager {
    private static final String TAG = "MessagingSmsManager";
    private static final String EXTRA_MSGID = "asyncCallId";
    private static final String EXTRA_MSGTEXT = "message";
    private static final String EXTRA_MSGTO = "to";
    private static final String EXTRA_MSGINSTANCEID = "instanceid";
    private static final String DEFAULT_SERVICE_ID = "sim0";
    private final Activity mMainActivity;
    private final Messaging mMessagingHandler;
    private BroadcastReceiver mSmsSentReceiver;
    private BroadcastReceiver mSmsDeliveredReceiver;
    private BroadcastReceiver mSmsReceiveReceiver;
    private BroadcastReceiver mSmsServiceReceiver;

    MessagingSmsManager(Activity activity, Messaging messaging) {
        this.mMainActivity = activity;
        this.mMessagingHandler = messaging;
    }

    private boolean checkService(String serviceID) {
        TelephonyManager tm = (TelephonyManager)this.mMainActivity.getSystemService("phone");
        return 5 == tm.getSimState();
    }

    public void onSmsSend(int instanceID, JSONObject jsonMsg) {
        if (!this.checkService(DEFAULT_SERVICE_ID)) {
            Log.e((String)TAG, (String)"No Sim Card");
        }
        String asyncCallId = null;
        JSONObject eventBody = null;
        String phone = null;
        String smsMessage = null;
        try {
            asyncCallId = jsonMsg.getString(EXTRA_MSGID);
            eventBody = jsonMsg.getJSONObject("data");
            phone = eventBody.getString("phone");
            smsMessage = eventBody.getString(EXTRA_MSGTEXT);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        SmsManager sms = SmsManager.getDefault();
        Intent intentSmsSent = new Intent("SMS_SENT");
        intentSmsSent.putExtra(EXTRA_MSGID, asyncCallId);
        intentSmsSent.putExtra(EXTRA_MSGTEXT, smsMessage);
        intentSmsSent.putExtra(EXTRA_MSGTO, phone);
        String instanceIDString = Integer.toString(instanceID);
        intentSmsSent.putExtra(EXTRA_MSGINSTANCEID, instanceIDString);
        int promiseIdInt = Integer.valueOf(asyncCallId);
        PendingIntent piSent = PendingIntent.getBroadcast((Context)this.mMainActivity, (int)promiseIdInt, (Intent)intentSmsSent, (int)0x40000000);
        Intent intentSmsDelivered = new Intent("SMS_DELIVERED");
        intentSmsDelivered.putExtra(EXTRA_MSGID, asyncCallId);
        intentSmsDelivered.putExtra(EXTRA_MSGTEXT, smsMessage);
        intentSmsDelivered.putExtra(EXTRA_MSGINSTANCEID, instanceIDString);
        PendingIntent piDelivered = PendingIntent.getBroadcast((Context)this.mMainActivity, (int)(-promiseIdInt), (Intent)intentSmsDelivered, (int)0x40000000);
        try {
            sms.sendTextMessage(phone, null, smsMessage, piSent, piDelivered);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to send SMS message.", (Throwable)e);
        }
    }

    public void onSmsClear(int instanceID, JSONObject jsonMsg) {
        String asyncCallId = null;
        String cmd = null;
        JSONObject eventBody = null;
        String serviceID = null;
        try {
            asyncCallId = jsonMsg.getString(EXTRA_MSGID);
            cmd = jsonMsg.getString("cmd");
            eventBody = jsonMsg.getJSONObject("data");
            serviceID = eventBody.getString("serviceID");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        ContentResolver cr = this.mMainActivity.getContentResolver();
        cr.delete(Uri.parse((String)"content://sms"), null, null);
        JSONObject jsonMsgRet = null;
        try {
            jsonMsgRet = new JSONObject();
            jsonMsgRet.put(EXTRA_MSGID, (Object)asyncCallId);
            jsonMsgRet.put("cmd", (Object)(cmd + "_ret"));
            JSONObject jsData = new JSONObject();
            jsonMsgRet.put("data", (Object)jsData);
            jsData.put("error", false);
            JSONObject jsBody = new JSONObject();
            jsData.put("body", (Object)jsBody);
            jsBody.put("value", (Object)serviceID);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        this.mMessagingHandler.postMessage(instanceID, jsonMsgRet.toString());
    }

    public void onSmsSegmentInfo(int instanceID, JSONObject jsonMsg) {
        String asyncCallId = null;
        JSONObject eventBody = null;
        String text = null;
        try {
            asyncCallId = jsonMsg.getString(EXTRA_MSGID);
            eventBody = jsonMsg.getJSONObject("data");
            text = eventBody.getString("text");
            if (null == text) {
                Log.e((String)TAG, (String)"No \"text\" attribute.");
                return;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        SmsManager sms = SmsManager.getDefault();
        ArrayList segs = sms.divideMessage(text);
        try {
            JSONObject jsonMsgRet = new JSONObject();
            jsonMsgRet.put("cmd", (Object)"msg_smsSegmentInfo_ret");
            jsonMsgRet.put(EXTRA_MSGID, (Object)asyncCallId);
            JSONObject jsData = new JSONObject();
            jsonMsgRet.put("data", (Object)jsData);
            jsData.put("error", false);
            JSONObject jsBody = new JSONObject();
            jsData.put("body", (Object)jsBody);
            jsBody.put("segments", segs.size());
            jsBody.put("charsPerSegment", ((String)segs.get(0)).length());
            jsBody.put("charsAvailableInLastSegment", ((String)segs.get(segs.size() - 1)).length());
            this.mMessagingHandler.postMessage(instanceID, jsonMsgRet.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
    }

    public void registerIntentFilters() {
        this.mSmsReceiveReceiver = new MessagingReceiver(this.mMessagingHandler){

            public void onReceive(Context context, Intent intent) {
                Bundle bundle = intent.getExtras();
                if (null == bundle) {
                    return;
                }
                Object[] pdus = (Object[])bundle.get("pdus");
                for (int i = 0; i < pdus.length; ++i) {
                    try {
                        JSONObject jsonMsg = new JSONObject();
                        jsonMsg.put("cmd", (Object)"received");
                        SmsMessage msgs = SmsMessage.createFromPdu((byte[])((byte[])pdus[i]));
                        JSONObject jsData = new JSONObject();
                        jsonMsg.put("data", (Object)jsData);
                        JSONObject jsMsg = new JSONObject();
                        jsData.put(MessagingSmsManager.EXTRA_MSGTEXT, (Object)jsMsg);
                        jsMsg.put("messageID", (Object)"");
                        jsMsg.put("type", (Object)"sms");
                        jsMsg.put("serviceID", (Object)MessagingSmsManager.DEFAULT_SERVICE_ID);
                        jsMsg.put("from", (Object)msgs.getOriginatingAddress());
                        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        jsMsg.put("timestamp", (Object)sDateFormat.format(new Date()));
                        jsMsg.put("body", (Object)msgs.getMessageBody().toString());
                        this.mMessaging.broadcastMessage(jsonMsg.toString());
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }
        };
        this.mSmsSentReceiver = new MessagingReceiver(this.mMessagingHandler){

            public void onReceive(Context content, Intent intent) {
                boolean error = this.getResultCode() != -1;
                String asyncCallId = intent.getStringExtra(MessagingSmsManager.EXTRA_MSGID);
                String smsMessage = intent.getStringExtra(MessagingSmsManager.EXTRA_MSGTEXT);
                String to = intent.getStringExtra(MessagingSmsManager.EXTRA_MSGTO);
                int instanceID = Integer.valueOf(intent.getStringExtra(MessagingSmsManager.EXTRA_MSGINSTANCEID));
                try {
                    JSONObject jsSentMsg = new JSONObject();
                    jsSentMsg.put("type", (Object)"sms");
                    jsSentMsg.put("from", (Object)"");
                    jsSentMsg.put("read", true);
                    jsSentMsg.put(MessagingSmsManager.EXTRA_MSGTO, (Object)to);
                    jsSentMsg.put("body", (Object)smsMessage);
                    jsSentMsg.put("messageClass", (Object)"class1");
                    jsSentMsg.put("state", (Object)(error ? "failed" : "sending"));
                    jsSentMsg.put("deliveryStatus", (Object)(error ? "error" : "pending"));
                    JSONObject jsonMsgPromise = new JSONObject();
                    jsonMsgPromise.put(MessagingSmsManager.EXTRA_MSGID, (Object)asyncCallId);
                    jsonMsgPromise.put("cmd", (Object)"msg_smsSend_ret");
                    JSONObject jsData = new JSONObject();
                    jsonMsgPromise.put("data", (Object)jsData);
                    jsData.put("error", error);
                    jsData.put("body", (Object)jsSentMsg);
                    this.mMessaging.postMessage(instanceID, jsonMsgPromise.toString());
                    JSONObject jsonMsgEvent = new JSONObject();
                    jsonMsgEvent.put("cmd", (Object)"sent");
                    jsonMsgEvent.put("data", (Object)jsSentMsg);
                    this.mMessaging.broadcastMessage(jsonMsgEvent.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return;
                }
                ContentValues values = new ContentValues();
                values.put("address", to);
                values.put("body", smsMessage);
                MessagingSmsManager.this.mMainActivity.getContentResolver().insert(Uri.parse((String)"content://sms/sent"), values);
            }
        };
        this.mSmsDeliveredReceiver = new MessagingReceiver(this.mMessagingHandler){

            public void onReceive(Context content, Intent intent) {
                boolean error = this.getResultCode() != -1;
                String asyncCallId = intent.getStringExtra(MessagingSmsManager.EXTRA_MSGID);
                int instanceID = Integer.valueOf(intent.getStringExtra(MessagingSmsManager.EXTRA_MSGINSTANCEID));
                try {
                    JSONObject jsonMsg = new JSONObject();
                    jsonMsg.put(MessagingSmsManager.EXTRA_MSGID, (Object)asyncCallId);
                    jsonMsg.put("cmd", (Object)(error ? "deliveryerror" : "deliverysuccess"));
                    JSONObject jsData = new JSONObject();
                    jsonMsg.put("data", (Object)jsData);
                    JSONObject jsEvent = new JSONObject();
                    jsData.put("event", (Object)jsEvent);
                    jsEvent.put("serviceID", (Object)MessagingSmsManager.DEFAULT_SERVICE_ID);
                    jsEvent.put("messageID", (Object)"");
                    jsEvent.put("recipients", (Object)"");
                    SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    jsEvent.put("deliveryTimestamps", (Object)sDateFormat.format(new Date()));
                    jsData.put("error", error);
                    this.mMessaging.postMessage(instanceID, jsonMsg.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        this.mSmsServiceReceiver = new MessagingReceiver(this.mMessagingHandler){

            public void onReceive(Context content, Intent intent) {
                try {
                    JSONObject jsonMsg = new JSONObject();
                    jsonMsg.put("cmd", (Object)(MessagingSmsManager.this.checkService(MessagingSmsManager.DEFAULT_SERVICE_ID) ? "serviceadded" : "serviceremoved"));
                    JSONObject jsData = new JSONObject();
                    jsonMsg.put("data", (Object)jsData);
                    JSONObject jsEvent = new JSONObject();
                    jsData.put("event", (Object)jsEvent);
                    jsEvent.put("serviceID", (Object)MessagingSmsManager.DEFAULT_SERVICE_ID);
                    this.mMessaging.broadcastMessage(jsonMsg.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        this.mMainActivity.registerReceiver(this.mSmsReceiveReceiver, new IntentFilter("android.provider.Telephony.SMS_RECEIVED"));
        this.mMainActivity.registerReceiver(this.mSmsSentReceiver, new IntentFilter("SMS_SENT"));
        this.mMainActivity.registerReceiver(this.mSmsDeliveredReceiver, new IntentFilter("SMS_DELIVERED"));
        this.mMainActivity.registerReceiver(this.mSmsServiceReceiver, new IntentFilter("android.intent.action.SIM_STATE_CHANGED"));
    }

    public void unregisterIntentFilters() {
        this.mMainActivity.unregisterReceiver(this.mSmsReceiveReceiver);
        this.mMainActivity.unregisterReceiver(this.mSmsSentReceiver);
        this.mMainActivity.unregisterReceiver(this.mSmsDeliveredReceiver);
        this.mMainActivity.unregisterReceiver(this.mSmsServiceReceiver);
    }

    public String getServiceIds() {
        JSONArray serviceIds = new JSONArray();
        serviceIds.put((Object)DEFAULT_SERVICE_ID);
        return serviceIds.toString();
    }

    private abstract class MessagingReceiver
    extends BroadcastReceiver {
        protected Messaging mMessaging;

        public MessagingReceiver(Messaging messaging) {
            this.mMessaging = messaging;
        }
    }
}

