/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.messaging;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.api.messaging.Messaging;
import org.xwalk.core.internal.extension.api.messaging.MessagingHelpers;

public class MessagingManager {
    private static final String TAG = "MessagingManager";
    private final Activity mMainActivity;
    private final Messaging mMessagingHandler;

    MessagingManager(Activity activity, Messaging messaging) {
        this.mMainActivity = activity;
        this.mMessagingHandler = messaging;
    }

    public void onMsgFindMessages(int instanceID, JSONObject jsonMsg) {
        this.queryMessage(instanceID, jsonMsg);
    }

    public void onMsgGetMessage(int instanceID, JSONObject jsonMsg) {
        this.queryMessage(instanceID, jsonMsg);
    }

    public void onMsgDeleteMessage(int instanceID, JSONObject jsonMsg) {
        this.operation(instanceID, jsonMsg);
    }

    public void onMsgDeleteConversation(int instanceID, JSONObject jsonMsg) {
        this.operation(instanceID, jsonMsg);
    }

    public void onMsgMarkMessageRead(int instanceID, JSONObject jsonMsg) {
        this.operation(instanceID, jsonMsg);
    }

    public void onMsgMarkConversationRead(int instanceID, JSONObject jsonMsg) {
        this.operation(instanceID, jsonMsg);
    }

    private Uri getUri(String type) {
        if (type.equals("mms")) {
            return Uri.parse((String)"content://mms");
        }
        return Uri.parse((String)"content://sms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryMessage(int instanceID, JSONObject jsonMsg) {
        String asyncCallId = null;
        String msgType = null;
        String cmd = null;
        String messageID = null;
        JSONObject filter = null;
        JSONObject filterOption = null;
        try {
            asyncCallId = jsonMsg.getString("asyncCallId");
            cmd = jsonMsg.getString("cmd");
            JSONObject eventBody = jsonMsg.getJSONObject("data");
            if (eventBody.has("messageID")) {
                messageID = eventBody.getString("messageID");
            }
            if (eventBody.has("filter")) {
                filter = eventBody.getJSONObject("filter");
            }
            if (eventBody.has("options")) {
                filterOption = eventBody.getJSONObject("options");
            }
            msgType = null != filter ? filter.getString("type") : eventBody.getString("type");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        if (!msgType.equals("sms") && !msgType.equals("mms")) {
            Log.e((String)TAG, (String)("Invalidate message type: " + msgType));
            return;
        }
        ContentResolver cr = this.mMainActivity.getContentResolver();
        Uri contentUri = this.getUri(msgType);
        String sqlString = null;
        String[] sqlArgs = null;
        String sqlOption = null;
        if (cmd.equals("msg_findMessages")) {
            Object[] retValue = MessagingHelpers.buildSqlFilterString(filter);
            sqlString = (String)retValue[0];
            sqlArgs = (String[])retValue[1];
            sqlOption = MessagingHelpers.buildSqlFilterOptionString(filterOption);
        } else {
            sqlString = String.format("%s = ?", "_id");
            sqlArgs = new String[]{messageID};
        }
        Cursor cursor = cr.query(contentUri, null, sqlString, sqlArgs, sqlOption);
        JSONObject jsonMsgRet = null;
        JSONArray results = null;
        try {
            jsonMsgRet = new JSONObject();
            results = new JSONArray();
            jsonMsgRet.put("asyncCallId", (Object)asyncCallId);
            jsonMsgRet.put("cmd", (Object)(cmd + "_ret"));
            JSONObject jsData = new JSONObject();
            jsonMsgRet.put("data", (Object)jsData);
            jsData.put("error", false);
            JSONObject jsBody = new JSONObject();
            jsData.put("body", (Object)jsBody);
            jsBody.put("results", (Object)results);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        try {
            if (msgType.equals("mms")) {
            } else if (cursor.getCount() > 0) {
                while (cursor.moveToNext()) {
                    JSONObject jsonSmsObj = MessagingHelpers.SmsMessageCursor2Json(cursor);
                    if (null == jsonSmsObj) continue;
                    results.put((Object)jsonSmsObj);
                }
            }
        }
        finally {
            cursor.close();
        }
        this.mMessagingHandler.postMessage(instanceID, jsonMsgRet.toString());
    }

    private void operation(int instanceID, JSONObject jsonMsg) {
        JSONObject eventBody = null;
        String asyncCallId = null;
        String msgType = null;
        String id2 = null;
        String cmd = null;
        boolean isRead = false;
        try {
            asyncCallId = jsonMsg.getString("asyncCallId");
            eventBody = jsonMsg.getJSONObject("data");
            id2 = eventBody.has("messageID") ? eventBody.getString("messageID") : eventBody.getString("conversationID");
            cmd = jsonMsg.getString("cmd");
            if (eventBody.has("value")) {
                isRead = eventBody.getBoolean("value");
            }
            msgType = eventBody.getString("type");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        String selString = null;
        selString = eventBody.has("messageID") ? String.format("%s = ?", "_id") : String.format("%s = ?", "thread_id");
        String[] selArgs = new String[]{id2};
        ContentResolver cr = this.mMainActivity.getContentResolver();
        Uri contentUri = this.getUri(msgType);
        if (cmd.equals("msg_deleteMessage") || cmd.equals("msg_deleteConversation")) {
            cr.delete(contentUri, selString, selArgs);
        } else if (cmd.equals("msg_markMessageRead") || cmd.equals("msg_markConversationRead")) {
            ContentValues values = new ContentValues();
            values.put("read", isRead ? "1" : "0");
            cr.update(contentUri, values, selString, selArgs);
        }
        JSONObject jsonMsgRet = null;
        try {
            jsonMsgRet = new JSONObject();
            jsonMsgRet.put("asyncCallId", (Object)asyncCallId);
            JSONObject jsData = new JSONObject();
            jsonMsgRet.put("data", (Object)jsData);
            jsData.put("error", false);
            JSONObject jsBody = new JSONObject();
            jsData.put("body", (Object)jsBody);
            if (eventBody.has("messageID")) {
                jsBody.put("messageID", (Object)id2);
            } else {
                jsBody.put("conversationID", (Object)id2);
            }
            jsonMsgRet.put("cmd", (Object)(cmd + "_ret"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        this.mMessagingHandler.postMessage(instanceID, jsonMsgRet.toString());
    }
}

