/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.messaging;

import android.database.Cursor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.api.messaging.MessagingSmsConstMaps;

public class MessagingHelpers {
    private static String buildSqlClause(boolean hasAnd, String condition, String column) {
        String clause = hasAnd ? " AND " : "";
        clause = clause + String.format(condition, column);
        return clause;
    }

    public static String convertJsDateString2Long(String date) {
        date = date.replace('T', ' ').replace('Z', ' ');
        long time = 0L;
        try {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = sf.parse(date).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return String.valueOf(time);
    }

    public static String convertDateLong2String(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sf.format(new Date(time));
    }

    public static Object[] buildSqlFilterString(JSONObject filter) {
        String filterString = "";
        ArrayList<String> argsStringList = new ArrayList<String>();
        try {
            boolean hasAnd = false;
            if (filter.has("startDate")) {
                filterString = filterString + MessagingHelpers.buildSqlClause(hasAnd, "%s >= ?", "date");
                argsStringList.add(MessagingHelpers.convertJsDateString2Long(filter.getString("startDate")));
                hasAnd = true;
            }
            if (filter.has("endDate")) {
                filterString = filterString + MessagingHelpers.buildSqlClause(hasAnd, "%s <= ?", "date");
                argsStringList.add(MessagingHelpers.convertJsDateString2Long(filter.getString("endDate")));
                hasAnd = true;
            }
            if (filter.has("from")) {
                filterString = filterString + MessagingHelpers.buildSqlClause(hasAnd, "%s = ?", "address");
                argsStringList.add(filter.getString("from"));
                hasAnd = true;
            }
            String msgType = "sms";
            if (filter.has("type")) {
                msgType = filter.getString("type");
            }
            if (filter.has("state") && msgType.equals("sms")) {
                filterString = filterString + MessagingHelpers.buildSqlClause(hasAnd, "%s = ?", "type");
                Integer stateNum = MessagingSmsConstMaps.smsStateDictS2I.get(filter.getString("state"));
                argsStringList.add(String.valueOf(stateNum));
                hasAnd = true;
            }
            if (filter.has("read")) {
                filterString = filterString + MessagingHelpers.buildSqlClause(hasAnd, "%s = ?", "read");
                argsStringList.add(filter.getBoolean("read") ? "1" : "0");
                hasAnd = true;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
        return new Object[]{filterString, argsStringList.toArray(new String[argsStringList.size()])};
    }

    public static String buildSqlFilterOptionString(JSONObject filterOption) {
        String filterOptionString = "";
        try {
            if (filterOption.has("sortBy")) {
                filterOptionString = filterOptionString + " " + MessagingSmsConstMaps.smsTableColumnDict.get(filterOption.getString("sortBy"));
            }
            if (filterOption.has("sortOrder")) {
                filterOptionString = filterOptionString + " " + MessagingSmsConstMaps.sortOrderDict.get(filterOption.getString("sortOrder"));
            }
            if (filterOption.has("limit")) {
                filterOptionString = filterOptionString + " LIMIT " + filterOption.getString("limit");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
        return filterOptionString;
    }

    public static JSONObject SmsMessageCursor2Json(Cursor c) {
        JSONObject jsonMsg = null;
        try {
            jsonMsg = new JSONObject();
            jsonMsg.put("messageID", (Object)c.getString(c.getColumnIndex("_id")));
            jsonMsg.put("conversationID", (Object)c.getString(c.getColumnIndex("thread_id")));
            jsonMsg.put("type", (Object)"sms");
            jsonMsg.put("serviceID", (Object)"");
            jsonMsg.put("from", (Object)c.getString(c.getColumnIndex("address")));
            jsonMsg.put("timestamp", (Object)MessagingHelpers.convertDateLong2String(c.getLong(c.getColumnIndex("date"))));
            jsonMsg.put("read", (Object)c.getString(c.getColumnIndex("read")));
            jsonMsg.put("to", (Object)"");
            jsonMsg.put("body", (Object)c.getString(c.getColumnIndex("body")));
            jsonMsg.put("state", (Object)MessagingSmsConstMaps.smsStateDictI2S.get(c.getInt(c.getColumnIndex("type"))));
            jsonMsg.put("deliveryStatus", (Object)MessagingSmsConstMaps.smsDiliveryStatusDictI2S.get(c.getInt(c.getColumnIndex("status"))));
            jsonMsg.put("deliveryTimestamp", (Object)"");
            jsonMsg.put("messageClass", (Object)"");
            return jsonMsg;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

