/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.messaging;

import java.util.HashMap;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.XWalkExtension;
import org.xwalk.core.internal.extension.XWalkExtensionContext;
import org.xwalk.core.internal.extension.api.messaging.Command;
import org.xwalk.core.internal.extension.api.messaging.MessagingManager;
import org.xwalk.core.internal.extension.api.messaging.MessagingSmsManager;

public class Messaging
extends XWalkExtension {
    public static final String JS_API_PATH = "jsapi/messaging_api.js";
    private static final String NAME = "xwalk.experimental.messaging";
    private static HashMap<String, Command> sMethodMap = new HashMap();
    private MessagingSmsManager mSmsManager;
    private MessagingManager mMessagingManager;

    private void initMethodMap() {
        sMethodMap.put("msg_smsSend", new Command(){

            public void runCommand(int instanceID, JSONObject jsonMsg) {
                Messaging.this.mSmsManager.onSmsSend(instanceID, jsonMsg);
            }
        });
        sMethodMap.put("msg_smsClear", new Command(){

            public void runCommand(int instanceID, JSONObject jsonMsg) {
                Messaging.this.mSmsManager.onSmsClear(instanceID, jsonMsg);
            }
        });
        sMethodMap.put("msg_smsSegmentInfo", new Command(){

            public void runCommand(int instanceID, JSONObject jsonMsg) {
                Messaging.this.mSmsManager.onSmsSegmentInfo(instanceID, jsonMsg);
            }
        });
        sMethodMap.put("msg_findMessages", new Command(){

            public void runCommand(int instanceID, JSONObject jsonMsg) {
                Messaging.this.mMessagingManager.onMsgFindMessages(instanceID, jsonMsg);
            }
        });
        sMethodMap.put("msg_getMessage", new Command(){

            public void runCommand(int instanceID, JSONObject jsonMsg) {
                Messaging.this.mMessagingManager.onMsgGetMessage(instanceID, jsonMsg);
            }
        });
        sMethodMap.put("msg_deleteMessage", new Command(){

            public void runCommand(int instanceID, JSONObject jsonMsg) {
                Messaging.this.mMessagingManager.onMsgDeleteMessage(instanceID, jsonMsg);
            }
        });
        sMethodMap.put("msg_deleteConversation", new Command(){

            public void runCommand(int instanceID, JSONObject jsonMsg) {
                Messaging.this.mMessagingManager.onMsgDeleteConversation(instanceID, jsonMsg);
            }
        });
        sMethodMap.put("msg_markMessageRead", new Command(){

            public void runCommand(int instanceID, JSONObject jsonMsg) {
                Messaging.this.mMessagingManager.onMsgMarkMessageRead(instanceID, jsonMsg);
            }
        });
        sMethodMap.put("msg_markConversationRead", new Command(){

            public void runCommand(int instanceID, JSONObject jsonMsg) {
                Messaging.this.mMessagingManager.onMsgMarkConversationRead(instanceID, jsonMsg);
            }
        });
    }

    private String getCommandString(String message) {
        if (message.isEmpty()) {
            return "";
        }
        try {
            return new JSONObject(message).getString("cmd");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public Messaging(String jsApiContent, XWalkExtensionContext context) {
        super(NAME, jsApiContent, context);
        this.mSmsManager = new MessagingSmsManager(this.mExtensionContext.getActivity(), this);
        this.mSmsManager.registerIntentFilters();
        this.mMessagingManager = new MessagingManager(this.mExtensionContext.getActivity(), this);
        this.initMethodMap();
    }

    public void onDestroy() {
        this.mSmsManager.unregisterIntentFilters();
    }

    public void onMessage(int instanceID, String message) {
        Command command = sMethodMap.get(this.getCommandString(message));
        if (null != command) {
            try {
                command.runCommand(instanceID, new JSONObject(message));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public String onSyncMessage(int instanceID, String message) {
        if (this.getCommandString(message).equals("msg_smsServiceId")) {
            return this.mSmsManager.getServiceIds();
        }
        return "";
    }
}

