/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.device_capabilities;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilities;
import org.xwalk.core.internal.extension.api.device_capabilities.XWalkMediaCodec;

class MediaCodec
extends XWalkMediaCodec {
    public MediaCodec(DeviceCapabilities instance) {
        this.mDeviceCapabilities = instance;
        this.mAudioCodecsSet = new HashSet();
        this.mVideoCodecsSet = new HashSet();
        this.getCodecsList();
    }

    public JSONObject getCodecsInfo() {
        JSONObject outputObject = new JSONObject();
        JSONArray audioCodecsArray = new JSONArray();
        JSONArray videoCodecsArray = new JSONArray();
        try {
            JSONObject codecsObject;
            for (Object codecToAdd : this.mAudioCodecsSet) {
                codecsObject = new JSONObject();
                codecsObject.put("format", (Object)((XWalkMediaCodec.AudioCodecElement)codecToAdd).codecName);
                audioCodecsArray.put((Object)codecsObject);
            }
            for (Object codecToAdd : this.mVideoCodecsSet) {
                codecsObject = new JSONObject();
                codecsObject.put("format", (Object)((XWalkMediaCodec.VideoCodecElement)codecToAdd).codecName);
                codecsObject.put("encode", ((XWalkMediaCodec.VideoCodecElement)codecToAdd).isEncoder);
                codecsObject.put("hwAccel", ((XWalkMediaCodec.VideoCodecElement)codecToAdd).hwAccel);
                videoCodecsArray.put((Object)codecsObject);
            }
            outputObject.put("audioCodecs", (Object)audioCodecsArray);
            outputObject.put("videoCodecs", (Object)videoCodecsArray);
        }
        catch (JSONException e) {
            return this.mDeviceCapabilities.setErrorMessage(e.toString());
        }
        return outputObject;
    }

    public void getCodecsList() {
        int numCodecs = MediaCodecList.getCodecCount();
        block0: for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            String name = codecInfo.getName().toUpperCase();
            boolean hasAdded = false;
            for (String nameListElement : AUDIO_CODEC_NAMES) {
                if (!name.contains(nameListElement)) continue;
                this.mAudioCodecsSet.add(new XWalkMediaCodec.AudioCodecElement(this, nameListElement));
                hasAdded = true;
                break;
            }
            if (hasAdded) continue;
            for (String nameListElement : VIDEO_CODEC_NAMES) {
                if (!name.contains(nameListElement)) continue;
                boolean isEncoder = codecInfo.isEncoder();
                this.mVideoCodecsSet.add(new XWalkMediaCodec.VideoCodecElement(this, nameListElement, isEncoder, false));
                continue block0;
            }
        }
    }
}

