/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.device_capabilities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.SparseArray;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.XWalkExtensionContext;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilities;

class DeviceCapabilitiesStorage {
    private static final String TAG = "DeviceCapabilitiesStorage";
    private DeviceCapabilities mDeviceCapabilities;
    private XWalkExtensionContext mExtensionContext;
    private static int mStorageCount = 0;
    private final SparseArray<StorageUnit> mStorageList = new SparseArray();
    private boolean mIsListening = false;
    private IntentFilter mIntentFilter = new IntentFilter();
    private final BroadcastReceiver mStorageListener = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.MEDIA_MOUNTED".equals(action)) {
                DeviceCapabilitiesStorage.this.notifyAndSaveAttachedStorage();
            }
            if ("android.intent.action.MEDIA_UNMOUNTED".equals(action) || "android.intent.action.MEDIA_REMOVED".equals(action) || "android.intent.action.MEDIA_BAD_REMOVAL".equals(action)) {
                DeviceCapabilitiesStorage.this.notifyAndRemoveDetachedStorage();
            }
        }
    };

    public DeviceCapabilitiesStorage(DeviceCapabilities instance, XWalkExtensionContext context) {
        this.mDeviceCapabilities = instance;
        this.mExtensionContext = context;
        this.registerIntentFilter();
        this.initStorageList();
    }

    public JSONObject getInfo() {
        JSONObject out = new JSONObject();
        JSONArray arr = new JSONArray();
        try {
            for (int i = 0; i < this.mStorageList.size(); ++i) {
                arr.put((Object)((StorageUnit)this.mStorageList.valueAt(i)).convertToJSON());
            }
            out.put("storages", (Object)arr);
        }
        catch (JSONException e) {
            return this.mDeviceCapabilities.setErrorMessage(e.toString());
        }
        return out;
    }

    private void initStorageList() {
        this.mStorageList.clear();
        mStorageCount = 0;
        StorageUnit unit = new StorageUnit(mStorageCount, "Internal", "fixed");
        unit.setPath(Environment.getRootDirectory().getAbsolutePath());
        this.mStorageList.put(mStorageCount, (Object)unit);
        int sdcardNum = ++mStorageCount - 1;
        unit = new StorageUnit(mStorageCount, new String("sdcard" + Integer.toString(sdcardNum)), "fixed");
        if (Environment.isExternalStorageRemovable()) {
            unit.setType("removable");
        }
        unit.setPath(Environment.getExternalStorageDirectory().getAbsolutePath());
        if (unit.isValid()) {
            this.mStorageList.put(mStorageCount, (Object)unit);
            ++mStorageCount;
        }
        this.attemptAddExternalStorage();
    }

    private void registerIntentFilter() {
        this.mIntentFilter.addAction("android.intent.action.MEDIA_BAD_REMOVAL");
        this.mIntentFilter.addAction("android.intent.action.MEDIA_MOUNTED");
        this.mIntentFilter.addAction("android.intent.action.MEDIA_REMOVED");
        this.mIntentFilter.addAction("android.intent.action.MEDIA_SCANNER_FINISHED");
        this.mIntentFilter.addAction("android.intent.action.MEDIA_SCANNER_STARTED");
        this.mIntentFilter.addAction("android.intent.action.MEDIA_UNMOUNTED");
        this.mIntentFilter.addDataScheme("file");
    }

    private boolean attemptAddExternalStorage() {
        int sdcardNum = mStorageCount - 1;
        StorageUnit unit = new StorageUnit(mStorageCount, new String("sdcard" + Integer.toString(sdcardNum)), "removable");
        unit.setPath("/storage/sdcard" + Integer.toString(sdcardNum));
        if (!unit.isValid()) {
            return false;
        }
        for (int i = 0; i < this.mStorageList.size(); ++i) {
            if (!unit.isSame((StorageUnit)this.mStorageList.valueAt(i))) continue;
            return false;
        }
        this.mStorageList.put(mStorageCount, (Object)unit);
        ++mStorageCount;
        return true;
    }

    public void registerListener() {
        if (this.mIsListening) {
            return;
        }
        this.mIsListening = true;
        this.mExtensionContext.getActivity().registerReceiver(this.mStorageListener, this.mIntentFilter);
    }

    public void unregisterListener() {
        if (!this.mIsListening) {
            return;
        }
        this.mIsListening = false;
        this.mExtensionContext.getActivity().unregisterReceiver(this.mStorageListener);
    }

    private void notifyAndSaveAttachedStorage() {
        if (!this.attemptAddExternalStorage()) {
            return;
        }
        StorageUnit unit = (StorageUnit)this.mStorageList.valueAt(this.mStorageList.size() - 1);
        JSONObject out = new JSONObject();
        try {
            out.put("reply", (Object)"attachStorage");
            out.put("eventName", (Object)"storageattach");
            out.put("data", (Object)unit.convertToJSON());
            this.mDeviceCapabilities.broadcastMessage(out.toString());
        }
        catch (JSONException e) {
            this.mDeviceCapabilities.printErrorMessage(e);
        }
    }

    private void notifyAndRemoveDetachedStorage() {
        StorageUnit unit = (StorageUnit)this.mStorageList.valueAt(this.mStorageList.size() - 1);
        if (unit.getType() != "removable") {
            return;
        }
        JSONObject out = new JSONObject();
        try {
            out.put("reply", (Object)"detachStorage");
            out.put("eventName", (Object)"storagedetach");
            out.put("data", (Object)unit.convertToJSON());
            this.mDeviceCapabilities.broadcastMessage(out.toString());
            this.mStorageList.remove(unit.getId());
            --mStorageCount;
        }
        catch (JSONException e) {
            this.mDeviceCapabilities.printErrorMessage(e);
        }
    }

    public void onResume() {
        StorageUnit lastUnit = (StorageUnit)this.mStorageList.valueAt(this.mStorageList.size() - 1);
        if (!lastUnit.isValid()) {
            this.notifyAndRemoveDetachedStorage();
        }
        this.notifyAndSaveAttachedStorage();
        this.registerListener();
    }

    public void onPause() {
        this.unregisterListener();
    }

    public void onDestroy() {
    }

    class StorageUnit {
        private int mId;
        private String mName;
        private String mType;
        private long mCapacity;
        private long mAvailCapacity;
        private String mPath;

        public StorageUnit(int id2, String name, String type) {
            this.mId = id2;
            this.mName = name;
            this.mType = type;
            this.mPath = "";
            this.mCapacity = 0L;
            this.mAvailCapacity = 0L;
        }

        public int getId() {
            return this.mId;
        }

        public String getName() {
            return this.mName;
        }

        public String getType() {
            return this.mType;
        }

        public String getPath() {
            return this.mPath;
        }

        public long getCapacity() {
            return this.mCapacity;
        }

        public long getAvailCapacity() {
            return this.mAvailCapacity;
        }

        public void setType(String type) {
            this.mType = type;
        }

        public void setPath(String path) {
            this.mPath = path;
            this.updateCapacity();
        }

        public boolean isSame(StorageUnit unit) {
            return this.mPath == unit.getPath();
        }

        public boolean isValid() {
            if (this.mPath == null || this.mPath.isEmpty()) {
                this.mCapacity = 0L;
                this.mAvailCapacity = 0L;
                return false;
            }
            File file = new File(this.mPath);
            return file.canRead();
        }

        public void updateCapacity() {
            if (!this.isValid()) {
                return;
            }
            StatFs stat = new StatFs(this.mPath);
            if (Build.VERSION.SDK_INT >= 18) {
                long blockSize = stat.getBlockSizeLong();
                this.mCapacity = blockSize * stat.getBlockCountLong();
                this.mAvailCapacity = blockSize * stat.getAvailableBlocksLong();
            } else {
                long blockSize = stat.getBlockSize();
                this.mCapacity = blockSize * (long)stat.getBlockCount();
                this.mAvailCapacity = blockSize * (long)stat.getAvailableBlocks();
            }
        }

        public JSONObject convertToJSON() {
            JSONObject out = new JSONObject();
            try {
                out.put("id", this.mId + 1);
                out.put("name", (Object)this.mName);
                out.put("type", (Object)this.mType);
                out.put("capacity", this.mCapacity);
                out.put("availCapacity", this.mAvailCapacity);
            }
            catch (JSONException e) {
                return DeviceCapabilitiesStorage.this.mDeviceCapabilities.setErrorMessage(e.toString());
            }
            return out;
        }
    }
}

