/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.device_capabilities;

import android.graphics.Point;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.Display;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.XWalkExtensionContext;
import org.xwalk.core.internal.extension.api.XWalkDisplayManager;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilities;

class DeviceCapabilitiesDisplay {
    private static final String TAG = "DeviceCapabilitiesDisplay";
    private DeviceCapabilities mDeviceCapabilities;
    private XWalkDisplayManager mDisplayManager;
    private final SparseArray<Display> mDisplayList = new SparseArray();
    private final XWalkDisplayManager.DisplayListener mDisplayListener = new XWalkDisplayManager.DisplayListener(){

        public void onDisplayAdded(int displayId) {
            DeviceCapabilitiesDisplay.this.notifyAndSaveConnectedDisplay(DeviceCapabilitiesDisplay.this.mDisplayManager.getDisplay(displayId));
        }

        public void onDisplayRemoved(int displayId) {
            Display disp = (Display)DeviceCapabilitiesDisplay.this.mDisplayList.get(displayId);
            if (disp == null) {
                return;
            }
            DeviceCapabilitiesDisplay.this.notifyAndRemoveDisconnectedDisplay(disp);
        }

        public void onDisplayChanged(int displayId) {
        }
    };

    public DeviceCapabilitiesDisplay(DeviceCapabilities instance, XWalkExtensionContext context) {
        this.mDeviceCapabilities = instance;
        this.mDisplayManager = XWalkDisplayManager.getInstance(context.getContext());
        this.initDisplayList();
    }

    public JSONObject getInfo() {
        JSONObject out = new JSONObject();
        JSONArray arr = new JSONArray();
        try {
            for (int i = 0; i < this.mDisplayList.size(); ++i) {
                arr.put((Object)this.convertDisplayToJSON((Display)this.mDisplayList.valueAt(i)));
            }
            out.put("displays", (Object)arr);
        }
        catch (JSONException e) {
            return this.mDeviceCapabilities.setErrorMessage(e.toString());
        }
        return out;
    }

    public JSONObject convertDisplayToJSON(Display disp) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        disp.getRealMetrics(displayMetrics);
        Point realSize = new Point();
        disp.getRealSize(realSize);
        Point availSize = new Point();
        disp.getSize(availSize);
        JSONObject out = new JSONObject();
        try {
            out.put("id", disp.getDisplayId());
            out.put("name", (Object)disp.getName());
            out.put("primary", disp.getDisplayId() == 0);
            out.put("external", disp.getDisplayId() != 0);
            out.put("deviceXDPI", (int)displayMetrics.xdpi);
            out.put("deviceYDPI", (int)displayMetrics.ydpi);
            out.put("width", realSize.x);
            out.put("height", realSize.y);
            out.put("availWidth", availSize.x);
            out.put("availHeight", availSize.y);
            out.put("colorDepth", 24);
            out.put("pixelDepth", 24);
        }
        catch (JSONException e) {
            return this.mDeviceCapabilities.setErrorMessage(e.toString());
        }
        return out;
    }

    private void initDisplayList() {
        Display[] displays;
        for (Display disp : displays = this.mDisplayManager.getDisplays()) {
            this.mDisplayList.put(disp.getDisplayId(), (Object)disp);
        }
    }

    private void notifyAndSaveConnectedDisplay(Display disp) {
        if (disp == null) {
            return;
        }
        JSONObject out = new JSONObject();
        try {
            out.put("reply", (Object)"connectDisplay");
            out.put("eventName", (Object)"displayconnect");
            out.put("data", (Object)this.convertDisplayToJSON(disp));
            this.mDeviceCapabilities.broadcastMessage(out.toString());
            this.mDisplayList.put(disp.getDisplayId(), (Object)disp);
        }
        catch (JSONException e) {
            this.mDeviceCapabilities.printErrorMessage(e);
        }
    }

    private void notifyAndRemoveDisconnectedDisplay(Display disp) {
        JSONObject out = new JSONObject();
        try {
            out.put("reply", (Object)"disconnectDisplay");
            out.put("eventName", (Object)"displaydisconnect");
            out.put("data", (Object)this.convertDisplayToJSON(disp));
            this.mDeviceCapabilities.broadcastMessage(out.toString());
            this.mDisplayList.remove(disp.getDisplayId());
        }
        catch (JSONException e) {
            this.mDeviceCapabilities.printErrorMessage(e);
        }
    }

    public void onResume() {
        Display[] displays;
        for (Display disp : displays = this.mDisplayManager.getDisplays()) {
            Display foundDisplay = (Display)this.mDisplayList.get(disp.getDisplayId());
            if (foundDisplay == null) {
                this.notifyAndSaveConnectedDisplay(disp);
                continue;
            }
            this.mDisplayList.put(disp.getDisplayId(), (Object)disp);
        }
        for (int i = 0; i < this.mDisplayList.size(); ++i) {
            boolean found = false;
            for (Display disp : displays) {
                if (((Display)this.mDisplayList.valueAt(i)).getDisplayId() != disp.getDisplayId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.notifyAndRemoveDisconnectedDisplay((Display)this.mDisplayList.valueAt(i));
        }
        this.mDisplayManager.registerDisplayListener(this.mDisplayListener);
    }

    public void onPause() {
        this.mDisplayManager.unregisterDisplayListener(this.mDisplayListener);
    }

    public void onDestroy() {
    }
}

