/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.contacts;

import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.OperationApplicationException;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.RemoteException;
import android.provider.ContactsContract;
import android.util.Log;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.XWalkExtension;
import org.xwalk.core.internal.extension.XWalkExtensionContext;
import org.xwalk.core.internal.extension.api.contacts.ContactEventListener;
import org.xwalk.core.internal.extension.api.contacts.ContactFinder;
import org.xwalk.core.internal.extension.api.contacts.ContactSaver;

public class Contacts
extends XWalkExtension {
    public static final String JS_API_PATH = "jsapi/contacts_api.js";
    private static final String TAG = "Contacts";
    private static final String NAME = "xwalk.experimental.contacts";
    private final ContactEventListener mObserver;
    private final ContentResolver mResolver;

    public Contacts(String jsApiContent, XWalkExtensionContext context) {
        super(NAME, jsApiContent, context);
        this.mResolver = context.getContext().getContentResolver();
        this.mObserver = new ContactEventListener(new Handler(), this, this.mResolver);
        this.mResolver.registerContentObserver(ContactsContract.Contacts.CONTENT_URI, true, (ContentObserver)this.mObserver);
    }

    public void onMessage(int instanceID, String message) {
        if (message.isEmpty()) {
            return;
        }
        try {
            JSONObject jsonInput = new JSONObject(message);
            String cmd = jsonInput.getString("cmd");
            if (cmd.equals("addEventListener")) {
                this.mObserver.startListening();
                return;
            }
            JSONObject jsonOutput = new JSONObject();
            jsonOutput.put("asyncCallId", (Object)jsonInput.getString("asyncCallId"));
            if (cmd.equals("save")) {
                ContactSaver saver = new ContactSaver(this.mResolver);
                jsonOutput.put("data", (Object)saver.save(jsonInput.getString("contact")));
            } else if (cmd.equals("find")) {
                ContactFinder finder = new ContactFinder(this.mResolver);
                String options = jsonInput.has("options") ? jsonInput.getString("options") : null;
                JSONArray results = finder.find(options);
                jsonOutput.put("data", (Object)results);
            } else if (cmd.equals("remove")) {
                ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
                String[] args = new String[]{jsonInput.getString("contactId")};
                ops.add(ContentProviderOperation.newDelete((Uri)ContactsContract.RawContacts.CONTENT_URI).withSelection("contact_id=?", args).build());
                try {
                    this.mResolver.applyBatch("com.android.contacts", ops);
                }
                catch (Exception e) {
                    if (e instanceof RemoteException || e instanceof OperationApplicationException || e instanceof SecurityException) {
                        Log.e((String)TAG, (String)("onMessage - Failed to apply batch: " + e.toString()));
                        return;
                    }
                    throw new RuntimeException(e);
                }
            } else if (cmd.equals("clear")) {
                this.handleClear();
            } else {
                Log.e((String)TAG, (String)("Unexpected message received: " + message));
                return;
            }
            this.postMessage(instanceID, jsonOutput.toString());
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    public void onResume() {
        this.mObserver.onResume();
        this.mResolver.registerContentObserver(ContactsContract.Contacts.CONTENT_URI, true, (ContentObserver)this.mObserver);
    }

    public void onPause() {
        this.mResolver.unregisterContentObserver((ContentObserver)this.mObserver);
    }

    public void onDestroy() {
        this.mResolver.unregisterContentObserver((ContentObserver)this.mObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClear() {
        Cursor c = null;
        try {
            c = this.mResolver.query(ContactsContract.Contacts.CONTENT_URI, null, null, null, null);
            while (c.moveToNext()) {
                String key = c.getString(c.getColumnIndex("lookup"));
                Uri uri = Uri.withAppendedPath((Uri)ContactsContract.Contacts.CONTENT_LOOKUP_URI, (String)key);
                this.mResolver.delete(uri, null, null);
            }
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("handleClear - failed to query: " + e.toString()));
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }
}

