/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.contacts;

import android.annotation.TargetApi;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.ContactsContract;
import android.util.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactUtils {
    private static final String TAG = "ContactUtils";
    public ContentResolver mResolver;

    public ContactUtils(ContentResolver resolver) {
        this.mResolver = resolver;
    }

    public static <K, V> K getKeyFromValue(Map<K, V> map, V value) {
        K key = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (value == null || !value.equals(entry.getValue())) continue;
            key = entry.getKey();
            break;
        }
        return key;
    }

    public static String makeQuestionMarkList(Set<String> strings) {
        String ret = "";
        for (int i = 0; i < strings.size(); ++i) {
            ret = ret + "?,";
        }
        return ret.substring(0, ret.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasID(String id2) {
        if (id2 == null) {
            return false;
        }
        Cursor c = null;
        try {
            c = this.mResolver.query(ContactsContract.Contacts.CONTENT_URI, null, "_id = ?", new String[]{id2}, null);
            boolean bl = c.getCount() != 0;
            return bl;
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("hasID: " + e.toString()));
            boolean bl = false;
            return bl;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRawId(String id2) {
        Cursor c = null;
        try {
            c = this.mResolver.query(ContactsContract.RawContacts.CONTENT_URI, new String[]{"_id"}, "contact_id=?", new String[]{id2}, null);
            if (c.moveToFirst()) {
                String string2 = c.getString(0);
                return string2;
            }
            String string3 = null;
            return string3;
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("getRawId: " + e.toString()));
            String string4 = null;
            return string4;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(String rawId) {
        Cursor c = null;
        try {
            c = this.mResolver.query(ContactsContract.RawContacts.CONTENT_URI, new String[]{"contact_id"}, "_id=?", new String[]{rawId}, null);
            if (c.moveToFirst()) {
                String string2 = c.getString(0);
                return string2;
            }
            String string3 = null;
            return string3;
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("getId: " + e.toString()));
            String string4 = null;
            return string4;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public String getLastUpdated(long contactId) {
        String[] projection = new String[]{"contact_last_updated_timestamp"};
        Uri uri = ContentUris.withAppendedId((Uri)ContactsContract.Contacts.CONTENT_URI, (long)contactId);
        Cursor cursor = this.mResolver.query(uri, projection, null, null, null);
        try {
            if (cursor.moveToNext()) {
                String string2 = this.timeConvertToJS(cursor.getLong(0));
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCurrentRawIds() {
        Cursor c = null;
        try {
            c = this.mResolver.query(ContactsContract.RawContacts.CONTENT_URI, new String[]{"_id"}, null, null, null);
            HashSet<String> rawIds = new HashSet<String>();
            while (c.moveToNext()) {
                rawIds.add(c.getString(0));
            }
            HashSet<String> hashSet = rawIds;
            return hashSet;
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("getCurrentRawIds: " + e.toString()));
            Set<String> set = null;
            return set;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDefaultAccountNameAndType() {
        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.RawContacts.CONTENT_URI).withValue("account_name", null).withValue("account_type", null).build());
        ContentProviderResult[] results = null;
        try {
            results = this.mResolver.applyBatch("com.android.contacts", ops);
        }
        catch (Exception e) {
            if (e instanceof RemoteException || e instanceof OperationApplicationException || e instanceof SecurityException) {
                Log.e((String)TAG, (String)("getDefaultAccountNameAndType - Failed to apply batch: " + e.toString()));
                return null;
            }
            throw new RuntimeException(e);
        }
        Uri rawContactUri = null;
        long rawContactId = 0L;
        for (ContentProviderResult result : results) {
            rawContactUri = result.uri;
            rawContactId = ContentUris.parseId((Uri)rawContactUri);
        }
        Cursor c = null;
        String accountType = "";
        String accountName = "";
        try {
            c = this.mResolver.query(ContactsContract.RawContacts.CONTENT_URI, new String[]{"account_type", "account_name"}, "_id=?", new String[]{String.valueOf(rawContactId)}, null);
            if (c.moveToFirst() && !c.isAfterLast()) {
                accountType = c.getString(c.getColumnIndex("account_type"));
                accountName = c.getString(c.getColumnIndex("account_name"));
            }
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("getDefaultAccountNameAndType: " + e.toString()));
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        this.mResolver.delete(rawContactUri, null, null);
        return new String[]{accountName, accountType};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupId(String groupTitle) {
        String selection = "deleted=? and group_visible=?";
        Cursor c = null;
        try {
            c = this.mResolver.query(ContactsContract.Groups.CONTENT_URI, null, "deleted=? and group_visible=?", new String[]{"0", "1"}, null);
            c.moveToFirst();
            for (int i = 0; i < c.getCount(); ++i) {
                String title = c.getString(c.getColumnIndex("title"));
                if (title.equals(groupTitle)) {
                    String string2 = c.getString(c.getColumnIndex("_id"));
                    return string2;
                }
                c.moveToNext();
            }
            String i = null;
            return i;
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("getGroupId: " + e.toString()));
            String string3 = null;
            return string3;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupTitle(String groupId) {
        String selection = "deleted=? and group_visible=?";
        Cursor c = null;
        try {
            c = this.mResolver.query(ContactsContract.Groups.CONTENT_URI, null, "deleted=? and group_visible=?", new String[]{"0", "1"}, null);
            c.moveToFirst();
            for (int i = 0; i < c.getCount(); ++i) {
                String id2 = c.getString(c.getColumnIndex("_id"));
                if (id2.equals(groupId)) {
                    String string2 = c.getString(c.getColumnIndex("title"));
                    return string2;
                }
                c.moveToNext();
            }
            String i = null;
            return i;
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("getGroupTitle: " + e.toString()));
            String string3 = null;
            return string3;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    public String getEnsuredGroupId(String groupTitle) {
        String groupId = this.getGroupId(groupTitle);
        if (groupId == null) {
            this.newGroup(groupTitle);
            groupId = this.getGroupId(groupTitle);
            if (groupId == null) {
                return null;
            }
        }
        return groupId;
    }

    public void newGroup(String groupTitle) {
        String[] accountNameType = this.getDefaultAccountNameAndType();
        ArrayList<ContentProviderOperation> o = new ArrayList<ContentProviderOperation>();
        o.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Groups.CONTENT_URI).withValue("title", (Object)groupTitle).withValue("group_visible", (Object)true).withValue("account_name", (Object)accountNameType[0]).withValue("account_type", (Object)accountNameType[1]).build());
        try {
            this.mResolver.applyBatch("com.android.contacts", o);
        }
        catch (Exception e) {
            if (e instanceof RemoteException || e instanceof OperationApplicationException || e instanceof SecurityException) {
                Log.e((String)TAG, (String)("newGroup - Failed to create new contact group: " + e.toString()));
            }
            throw new RuntimeException(e);
        }
    }

    public void cleanByMimeType(String id2, String mimeType) {
        this.mResolver.delete(ContactsContract.Data.CONTENT_URI, String.format("%s = ? AND %s = ?", "contact_id", "mimetype"), new String[]{id2, mimeType});
    }

    public String dateTrim(String string2) {
        String date = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            date = df.format(df.parse(string2));
        }
        catch (ParseException e) {
            Log.e((String)TAG, (String)("dateFormat - parse failed: " + e.toString()));
        }
        return date;
    }

    private String timeConvertToJS(long seconds) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.getDefault());
        return df.format(new Date(seconds));
    }
}

