/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.internal.extension.XWalkExtension;
import org.xwalk.core.internal.extension.XWalkExtensionBridge;
import org.xwalk.core.internal.extension.XWalkExtensionBridgeFactory;
import org.xwalk.core.internal.extension.XWalkExtensionContext;
import org.xwalk.core.internal.extension.XWalkExtensionContextWrapper;
import org.xwalk.core.internal.extension.api.contacts.Contacts;
import org.xwalk.core.internal.extension.api.device_capabilities.DeviceCapabilities;
import org.xwalk.core.internal.extension.api.launchscreen.LaunchScreenExtension;
import org.xwalk.core.internal.extension.api.messaging.Messaging;
import org.xwalk.core.internal.extension.api.presentation.PresentationExtension;

public class XWalkExtensionManager
implements XWalkExtensionContext {
    private static final String TAG = "XWalkExtensionManager";
    private static final String EXTENSION_CONFIG_FILE = "extensions-config.json";
    private static final String EXTENSION_CONTEXT_CLIENT_CLASS_NAME = "org.xwalk.app.runtime.extension.XWalkExtensionContextClient";
    private final Context mContext;
    private final Activity mActivity;
    private final HashMap<String, XWalkExtensionBridge> mExtensions = new HashMap();
    private boolean mLoadExternalExtensions;

    public XWalkExtensionManager(Context context, Activity activity) {
        this.mContext = context;
        this.mActivity = activity;
        this.mLoadExternalExtensions = true;
    }

    public void registerExtension(XWalkExtension extension) {
        if (this.mExtensions.get(extension.getExtensionName()) != null) {
            Log.e((String)TAG, (String)(extension.getExtensionName() + "is already registered!"));
            return;
        }
        XWalkExtensionBridge bridge = XWalkExtensionBridgeFactory.createInstance(extension);
        this.mExtensions.put(extension.getExtensionName(), bridge);
    }

    public void unregisterExtension(String name) {
        XWalkExtensionBridge bridge = this.mExtensions.get(name);
        if (bridge != null) {
            this.mExtensions.remove(name);
            bridge.onDestroy();
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public void postMessage(XWalkExtension extension, int instanceID, String message) {
        XWalkExtensionBridge bridge = this.mExtensions.get(extension.getExtensionName());
        if (bridge != null) {
            bridge.postMessage(instanceID, message);
        }
    }

    public void broadcastMessage(XWalkExtension extension, String message) {
        XWalkExtensionBridge bridge = this.mExtensions.get(extension.getExtensionName());
        if (bridge != null) {
            bridge.broadcastMessage(message);
        }
    }

    public void onResume() {
        for (XWalkExtensionBridge extension : this.mExtensions.values()) {
            extension.onResume();
        }
    }

    public void onPause() {
        for (XWalkExtensionBridge extension : this.mExtensions.values()) {
            extension.onPause();
        }
    }

    public void onDestroy() {
        for (XWalkExtensionBridge extension : this.mExtensions.values()) {
            extension.onDestroy();
        }
        this.mExtensions.clear();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        for (XWalkExtensionBridge extension : this.mExtensions.values()) {
            extension.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void loadExtensions() {
        this.loadInternalExtensions();
        this.loadExternalExtensions();
    }

    public void setAllowExternalExtensions(boolean load) {
        this.mLoadExternalExtensions = load;
    }

    private void loadInternalExtensions() {
        String jsApiContent = "";
        try {
            jsApiContent = this.getExtensionJSFileContent(this.mContext, "jsapi/presentation_api.js", true);
            new PresentationExtension(jsApiContent, this);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to read JS API file: jsapi/presentation_api.js");
        }
        jsApiContent = "";
        try {
            jsApiContent = this.getExtensionJSFileContent(this.mContext, "jsapi/launch_screen_api.js", true);
            new LaunchScreenExtension(jsApiContent, this);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to read JS API file: jsapi/launch_screen_api.js");
        }
        jsApiContent = "";
        try {
            jsApiContent = this.getExtensionJSFileContent(this.mContext, "jsapi/contacts_api.js", true);
            new Contacts(jsApiContent, this);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to read JS API file: jsapi/contacts_api.js");
        }
        jsApiContent = "";
        try {
            jsApiContent = this.getExtensionJSFileContent(this.mContext, "jsapi/device_capabilities_api.js", true);
            new DeviceCapabilities(jsApiContent, this);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to read JS API file: jsapi/device_capabilities_api.js");
        }
        jsApiContent = "";
        try {
            jsApiContent = this.getExtensionJSFileContent(this.mContext, "jsapi/messaging_api.js", true);
            new Messaging(jsApiContent, this);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to read JS API file: jsapi/messaging_api.js");
        }
    }

    private void loadExternalExtensions() {
        String configFileContent;
        if (!this.mLoadExternalExtensions) {
            return;
        }
        try {
            configFileContent = this.getExtensionJSFileContent((Context)this.mActivity, EXTENSION_CONFIG_FILE, false);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to read extensions-config.json");
            return;
        }
        XWalkExtensionContextWrapper contextWrapper = new XWalkExtensionContextWrapper(this);
        Object contextClient = this.createExtensionContextClient(contextWrapper);
        try {
            JSONArray jsonFeatures = new JSONArray(configFileContent);
            int extensionCount = jsonFeatures.length();
            for (int i = 0; i < extensionCount; ++i) {
                String jsApi;
                JSONObject jsonObject = jsonFeatures.getJSONObject(i);
                String name = jsonObject.getString("name");
                String className = jsonObject.getString("class");
                String jsApiFile = jsonObject.getString("jsapi");
                try {
                    jsApi = this.getExtensionJSFileContent((Context)this.mActivity, jsApiFile, false);
                }
                catch (IOException e) {
                    Log.w((String)TAG, (String)("Failed to read the file " + jsApiFile));
                    return;
                }
                if (name == null || className == null || jsApi == null) continue;
                this.createExternalExtension(name, className, jsApi, contextClient, contextWrapper);
            }
        }
        catch (JSONException e) {
            Log.w((String)TAG, (String)"Failed to parse extensions-config.json");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExtensionJSFileContent(Context context, String fileName, boolean fromRaw) throws IOException {
        String result = "";
        InputStream inputStream = null;
        try {
            String resName;
            Resources resource;
            int resId;
            if (fromRaw && (resId = (resource = context.getResources()).getIdentifier(resName = new File(fileName).getName().split("\\.")[0], "raw", context.getPackageName())) > 0) {
                try {
                    inputStream = resource.openRawResource(resId);
                }
                catch (Resources.NotFoundException e) {
                    Log.w((String)TAG, (String)("Inputstream failed to open for R.raw." + resName + ", try to find it in assets"));
                }
            }
            if (inputStream == null) {
                AssetManager assetManager = context.getAssets();
                inputStream = assetManager.open(fileName);
            }
            int size = inputStream.available();
            byte[] buffer = new byte[size];
            inputStream.read(buffer);
            result = new String(buffer);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return result;
    }

    private Object createExtensionContextClient(XWalkExtensionContextWrapper contextWrapper) {
        Activity activity = contextWrapper.getActivity();
        try {
            Class<?> clazz = activity.getClassLoader().loadClass(EXTENSION_CONTEXT_CLIENT_CLASS_NAME);
            Constructor<?> constructor = clazz.getConstructor(Activity.class, Object.class);
            return constructor.newInstance(activity, contextWrapper);
        }
        catch (ClassNotFoundException e) {
            XWalkExtensionManager.handleException(e);
        }
        catch (IllegalAccessException e) {
            XWalkExtensionManager.handleException(e);
        }
        catch (InstantiationException e) {
            XWalkExtensionManager.handleException(e);
        }
        catch (InvocationTargetException e) {
            XWalkExtensionManager.handleException(e);
        }
        catch (NoSuchMethodException e) {
            XWalkExtensionManager.handleException(e);
        }
        return null;
    }

    private void createExternalExtension(String name, String className, String jsApi, Object contextClient, XWalkExtensionContextWrapper contextWrapper) {
        Activity activity = contextWrapper.getActivity();
        try {
            Class<?> clazz = activity.getClassLoader().loadClass(className);
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class, contextClient.getClass());
            constructor.newInstance(name, jsApi, contextClient);
        }
        catch (ClassNotFoundException e) {
            XWalkExtensionManager.handleException(e);
        }
        catch (IllegalAccessException e) {
            XWalkExtensionManager.handleException(e);
        }
        catch (InstantiationException e) {
            XWalkExtensionManager.handleException(e);
        }
        catch (InvocationTargetException e) {
            XWalkExtensionManager.handleException(e);
        }
        catch (NoSuchMethodException e) {
            XWalkExtensionManager.handleException(e);
        }
    }

    private static void handleException(Exception e) {
        Log.e((String)TAG, (String)("Error in calling methods of external extensions. " + e.toString()));
    }
}

