/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension;

import android.content.Intent;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.xwalk.core.internal.extension.XWalkExtension;
import org.xwalk.core.internal.extension.XWalkExtensionContextWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XWalkExtensionClientImpl
extends XWalkExtension {
    private static final String TAG = XWalkExtensionClientImpl.class.getName();
    private Object mExtensionClient;
    private Method mOnMessage;
    private Method mOnSyncMessage;
    private Method mOnResume;
    private Method mOnPause;
    private Method mOnDestroy;
    private Method mOnActivityResult;

    public XWalkExtensionClientImpl(String name, String jsApi, XWalkExtensionContextWrapper context, Object extensionClient) {
        super(name, jsApi, context);
        this.mExtensionClient = extensionClient;
        this.mOnMessage = this.lookupMethod("onMessage", Integer.TYPE, String.class);
        this.mOnSyncMessage = this.lookupMethod("onSyncMessage", Integer.TYPE, String.class);
        this.mOnResume = this.lookupMethod("onResume", new Class[0]);
        this.mOnPause = this.lookupMethod("onPause", new Class[0]);
        this.mOnDestroy = this.lookupMethod("onDestroy", new Class[0]);
        this.mOnActivityResult = this.lookupMethod("onActivityResult", Integer.TYPE, Integer.TYPE, Intent.class);
    }

    @Override
    public void onMessage(int extensionInstanceID, String message) {
        XWalkExtensionClientImpl.invokeMethod(this.mOnMessage, this.mExtensionClient, extensionInstanceID, message);
    }

    @Override
    public String onSyncMessage(int extensionInstanceID, String message) {
        return (String)XWalkExtensionClientImpl.invokeMethod(this.mOnSyncMessage, this.mExtensionClient, extensionInstanceID, message);
    }

    @Override
    public void onResume() {
        XWalkExtensionClientImpl.invokeMethod(this.mOnResume, this.mExtensionClient, new Object[0]);
    }

    @Override
    public void onPause() {
        XWalkExtensionClientImpl.invokeMethod(this.mOnPause, this.mExtensionClient, new Object[0]);
    }

    @Override
    public void onDestroy() {
        XWalkExtensionClientImpl.invokeMethod(this.mOnDestroy, this.mExtensionClient, new Object[0]);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        XWalkExtensionClientImpl.invokeMethod(this.mOnActivityResult, this.mExtensionClient, requestCode, resultCode, data);
    }

    private Method lookupMethod(String method, Class<?> ... parameters) {
        Class<?> clientClass = this.mExtensionClient.getClass();
        try {
            return clientClass.getMethod(method, parameters);
        }
        catch (NoSuchMethodException e) {
            XWalkExtensionClientImpl.handleException(e);
            return null;
        }
    }

    private static Object invokeMethod(Method method, Object instance, Object ... parameters) {
        Object result = null;
        if (method != null) {
            try {
                result = method.invoke(instance, parameters);
            }
            catch (IllegalArgumentException e) {
                XWalkExtensionClientImpl.handleException(e);
            }
            catch (IllegalAccessException e) {
                XWalkExtensionClientImpl.handleException(e);
            }
            catch (InvocationTargetException e) {
                XWalkExtensionClientImpl.handleException(e);
            }
            catch (NullPointerException e) {
                XWalkExtensionClientImpl.handleException(e);
            }
        }
        return result;
    }

    private static void handleException(Exception e) {
        Log.e((String)TAG, (String)("Error in calling methods of external extensions. " + e.toString()));
        e.printStackTrace();
    }
}

