/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension;

import android.content.Intent;
import org.xwalk.core.internal.extension.XWalkExtensionContext;

public abstract class XWalkExtension {
    protected String mName;
    protected String mJsApi;
    protected String[] mEntryPoints;
    protected XWalkExtensionContext mExtensionContext;

    public XWalkExtension(String name, String jsApi, XWalkExtensionContext context) {
        this.mName = name;
        this.mJsApi = jsApi;
        this.mEntryPoints = null;
        this.mExtensionContext = context;
        this.mExtensionContext.registerExtension(this);
    }

    public XWalkExtension(String name, String jsApi, String[] entryPoints, XWalkExtensionContext context) {
        this.mName = name;
        this.mJsApi = jsApi;
        this.mEntryPoints = entryPoints;
        this.mExtensionContext = context;
        this.mExtensionContext.registerExtension(this);
    }

    public String getExtensionName() {
        return this.mName;
    }

    public String getJsApi() {
        return this.mJsApi;
    }

    public String[] getEntryPoints() {
        return this.mEntryPoints;
    }

    public abstract void onMessage(int var1, String var2);

    public String onSyncMessage(int instanceID, String message) {
        return null;
    }

    public final void postMessage(int instanceID, String message) {
        this.mExtensionContext.postMessage(this, instanceID, message);
    }

    public final void broadcastMessage(String message) {
        this.mExtensionContext.broadcastMessage(this, message);
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onDestroy() {
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }
}

