/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ApplicationErrorReport;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Looper;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.widget.FrameLayout;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.CommandLine;
import org.xwalk.core.internal.DownloadListener;
import org.xwalk.core.internal.R;
import org.xwalk.core.internal.XWalkClient;
import org.xwalk.core.internal.XWalkContent;
import org.xwalk.core.internal.XWalkDownloadListenerImpl;
import org.xwalk.core.internal.XWalkInternalResources;
import org.xwalk.core.internal.XWalkNavigationHandler;
import org.xwalk.core.internal.XWalkNavigationHandlerImpl;
import org.xwalk.core.internal.XWalkNavigationHistoryInternal;
import org.xwalk.core.internal.XWalkNotificationService;
import org.xwalk.core.internal.XWalkNotificationServiceImpl;
import org.xwalk.core.internal.XWalkResourceClientInternal;
import org.xwalk.core.internal.XWalkSettings;
import org.xwalk.core.internal.XWalkUIClientInternal;
import org.xwalk.core.internal.XWalkViewDelegate;
import org.xwalk.core.internal.XWalkWebChromeClient;
import org.xwalk.core.internal.extension.XWalkExtensionManager;
import org.xwalk.core.internal.extension.XWalkPathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWalkViewInternal
extends FrameLayout {
    static final String PLAYSTORE_DETAIL_URI = "market://details?id=";
    private XWalkContent mContent;
    private Activity mActivity;
    private Context mContext;
    private XWalkExtensionManager mExtensionManager;
    private boolean mIsHidden;
    private XWalkActivityStateListener mActivityStateListener;
    public static final int RELOAD_NORMAL = 0;
    public static final int RELOAD_IGNORE_CACHE = 1;

    public XWalkViewInternal(Context context, AttributeSet attrs) {
        super(context, attrs);
        XWalkViewInternal.checkThreadSafety();
        this.mContext = context;
        this.init(context, attrs);
    }

    public XWalkViewInternal(Context context, Activity activity) {
        super(context, null);
        XWalkViewInternal.checkThreadSafety();
        this.mActivity = activity;
        this.mContext = context;
        this.init(context, null);
    }

    public Activity getActivity() {
        if (this.mActivity != null) {
            return this.mActivity;
        }
        if (this.getContext() instanceof Activity) {
            return (Activity)this.getContext();
        }
        assert (false);
        return null;
    }

    public Context getViewContext() {
        return this.mContext;
    }

    private void init(Context context, AttributeSet attrs) {
        XWalkInternalResources.resetIds(context);
        try {
            XWalkViewDelegate.init(this);
            this.mActivityStateListener = new XWalkActivityStateListener(this);
            ApplicationStatus.registerStateListenerForActivity(this.mActivityStateListener, this.getActivity());
        }
        catch (Throwable e) {
            Throwable linkError = e;
            while (true) {
                if (linkError == null) {
                    throw new RuntimeException(e);
                }
                if (linkError instanceof UnsatisfiedLinkError) break;
                if (linkError.getCause() == null || linkError.getCause().equals(linkError)) {
                    throw new RuntimeException(e);
                }
                linkError = linkError.getCause();
            }
            final UnsatisfiedLinkError err = (UnsatisfiedLinkError)linkError;
            final Activity activity = this.getActivity();
            final String packageName = context.getPackageName();
            String missingArch = XWalkViewDelegate.isRunningOnIA() ? "Intel" : "ARM";
            String message = context.getString(R.string.cpu_arch_mismatch_message, new Object[]{missingArch});
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
            builder.setTitle(R.string.cpu_arch_mismatch_title).setMessage((CharSequence)message).setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    activity.finish();
                }
            }).setPositiveButton(R.string.goto_store_button_label, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)(XWalkViewInternal.PLAYSTORE_DETAIL_URI + packageName))));
                    activity.finish();
                }
            }).setNeutralButton(R.string.report_feedback_button_label, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ApplicationErrorReport report = new ApplicationErrorReport();
                    report.type = 1;
                    report.packageName = report.processName = packageName;
                    ApplicationErrorReport.CrashInfo crash = new ApplicationErrorReport.CrashInfo();
                    crash.exceptionClassName = err.getClass().getSimpleName();
                    crash.exceptionMessage = "CPU architecture mismatch";
                    StringWriter writer = new StringWriter();
                    PrintWriter print = new PrintWriter(writer);
                    err.printStackTrace(print);
                    crash.stackTrace = writer.toString();
                    StackTraceElement stack = err.getStackTrace()[0];
                    crash.throwClassName = stack.getClassName();
                    crash.throwFileName = stack.getFileName();
                    crash.throwLineNumber = stack.getLineNumber();
                    crash.throwMethodName = stack.getMethodName();
                    report.crashInfo = crash;
                    report.systemApp = false;
                    report.time = System.currentTimeMillis();
                    Intent intent = new Intent("android.intent.action.APP_ERROR");
                    intent.putExtra("android.intent.extra.BUG_REPORT", (Parcelable)report);
                    activity.startActivity(intent);
                    activity.finish();
                }
            });
            builder.create().show();
            return;
        }
        this.initXWalkContent(context, attrs);
    }

    private void initXWalkContent(Context context, AttributeSet attrs) {
        File extCacheDir;
        this.mIsHidden = false;
        this.mContent = new XWalkContent(context, attrs, this);
        this.addView((View)this.mContent, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.setXWalkClient(new XWalkClient(this));
        this.setXWalkWebChromeClient(new XWalkWebChromeClient(this));
        this.setUIClient(new XWalkUIClientInternal(this));
        this.setResourceClient(new XWalkResourceClientInternal(this));
        this.setDownloadListener(new XWalkDownloadListenerImpl(context));
        this.setNavigationHandler(new XWalkNavigationHandlerImpl(context));
        this.setNotificationService(new XWalkNotificationServiceImpl(context, this));
        if (!CommandLine.getInstance().hasSwitch("disable-xwalk-extensions")) {
            this.mExtensionManager = new XWalkExtensionManager(context, this.getActivity());
            this.mExtensionManager.loadExtensions();
        }
        XWalkPathHelper.initialize();
        XWalkPathHelper.setCacheDirectory(this.mContext.getApplicationContext().getCacheDir().getPath());
        String state = Environment.getExternalStorageState();
        if (("mounted".equals(state) || "mounted_ro".equals(state)) && null != (extCacheDir = this.mContext.getApplicationContext().getExternalCacheDir())) {
            XWalkPathHelper.setExternalCacheDirectory(extCacheDir.getPath());
        }
    }

    public void load(String url, String content) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.loadUrl(url, content);
    }

    public void loadAppFromManifest(String url, String content) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.loadAppFromManifest(url, content);
    }

    public void reload(int mode) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.reload(mode);
    }

    public void stopLoading() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.stopLoading();
    }

    public String getUrl() {
        if (this.mContent == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.getUrl();
    }

    public String getTitle() {
        if (this.mContent == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.getTitle();
    }

    public String getOriginalUrl() {
        if (this.mContent == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.getOriginalUrl();
    }

    public XWalkNavigationHistoryInternal getNavigationHistory() {
        if (this.mContent == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.getNavigationHistory();
    }

    public void addJavascriptInterface(Object object, String name) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.addJavascriptInterface(object, name);
    }

    public void evaluateJavascript(String script, ValueCallback<String> callback) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.evaluateJavascript(script, callback);
    }

    public void clearCache(boolean includeDiskFiles) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.clearCache(includeDiskFiles);
    }

    public boolean hasEnteredFullscreen() {
        if (this.mContent == null) {
            return false;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.hasEnteredFullscreen();
    }

    public void leaveFullscreen() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.exitFullscreen();
    }

    public void pauseTimers() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.pauseTimers();
    }

    public void resumeTimers() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.resumeTimers();
    }

    public void onHide() {
        if (this.mContent == null || this.mIsHidden) {
            return;
        }
        if (null != this.mExtensionManager) {
            this.mExtensionManager.onPause();
        }
        this.mContent.onPause();
        this.mIsHidden = true;
    }

    public void onShow() {
        if (this.mContent == null || !this.mIsHidden) {
            return;
        }
        if (null != this.mExtensionManager) {
            this.mExtensionManager.onResume();
        }
        this.mContent.onResume();
        this.mIsHidden = false;
    }

    public void onDestroy() {
        this.destroy();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mContent == null) {
            return;
        }
        if (null != this.mExtensionManager) {
            this.mExtensionManager.onActivityResult(requestCode, resultCode, data);
        }
        this.mContent.onActivityResult(requestCode, resultCode, data);
    }

    public boolean onNewIntent(Intent intent) {
        if (this.mContent == null) {
            return false;
        }
        return this.mContent.onNewIntent(intent);
    }

    public boolean saveState(Bundle outState) {
        if (this.mContent == null) {
            return false;
        }
        this.mContent.saveState(outState);
        return true;
    }

    public boolean restoreState(Bundle inState) {
        if (this.mContent == null) {
            return false;
        }
        return this.mContent.restoreState(inState) != null;
    }

    public String getAPIVersion() {
        return "2.1";
    }

    public String getXWalkVersion() {
        if (this.mContent == null) {
            return null;
        }
        return this.mContent.getXWalkVersion();
    }

    public void setUIClient(XWalkUIClientInternal client) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setUIClient(client);
    }

    public void setResourceClient(XWalkResourceClientInternal client) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setResourceClient(client);
    }

    public XWalkSettings getSettings() {
        if (this.mContent == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.getSettings();
    }

    public void setNetworkAvailable(boolean networkUp) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setNetworkAvailable(networkUp);
    }

    public String enableRemoteDebugging(int allowedUid) {
        if (this.mContent == null) {
            return null;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.enableRemoteDebugging(allowedUid);
    }

    public int getContentID() {
        if (this.mContent == null) {
            return -1;
        }
        return this.mContent.getRoutingID();
    }

    boolean canGoBack() {
        if (this.mContent == null) {
            return false;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.canGoBack();
    }

    void goBack() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.goBack();
    }

    boolean canGoForward() {
        if (this.mContent == null) {
            return false;
        }
        XWalkViewInternal.checkThreadSafety();
        return this.mContent.canGoForward();
    }

    void goForward() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.goForward();
    }

    void clearHistory() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.clearHistory();
    }

    void destroy() {
        if (this.mContent == null) {
            return;
        }
        ApplicationStatus.unregisterActivityStateListener(this.mActivityStateListener);
        this.mActivityStateListener = null;
        if (null != this.mExtensionManager) {
            this.mExtensionManager.onDestroy();
        }
        this.mContent.destroy();
        this.disableRemoteDebugging();
    }

    String enableRemoteDebugging() {
        return this.enableRemoteDebugging(this.mContext.getApplicationInfo().uid);
    }

    void disableRemoteDebugging() {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.disableRemoteDebugging();
    }

    private static void checkThreadSafety() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            Throwable throwable = new Throwable("Warning: A XWalkViewInternal method was called on thread '" + Thread.currentThread().getName() + "'. " + "All XWalkViewInternal methods must be called on the UI thread. ");
            throw new RuntimeException(throwable);
        }
    }

    boolean isOwnerActivityRunning() {
        int status = ApplicationStatus.getStateForActivity(this.getActivity());
        return status != 6;
    }

    void navigateTo(int offset) {
        if (this.mContent == null) {
            return;
        }
        this.mContent.navigateTo(offset);
    }

    void setOverlayVideoMode(boolean enabled) {
        this.mContent.setOverlayVideoMode(enabled);
    }

    public void setXWalkClient(XWalkClient client) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setXWalkClient(client);
    }

    public void setXWalkWebChromeClient(XWalkWebChromeClient client) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setXWalkWebChromeClient(client);
    }

    public void setDownloadListener(DownloadListener listener) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setDownloadListener(listener);
    }

    public void setNavigationHandler(XWalkNavigationHandler handler) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setNavigationHandler(handler);
    }

    public void setNotificationService(XWalkNotificationService service) {
        if (this.mContent == null) {
            return;
        }
        XWalkViewInternal.checkThreadSafety();
        this.mContent.setNotificationService(service);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getAction() == 1 && event.getKeyCode() == 4) {
            if (this.hasEnteredFullscreen()) {
                this.leaveFullscreen();
                return true;
            }
            if (this.canGoBack()) {
                this.goBack();
                return true;
            }
        }
        return super.dispatchKeyEvent(event);
    }

    private void onActivityStateChange(Activity activity, int newState) {
        assert (this.getActivity() == activity);
        switch (newState) {
            case 2: {
                this.onShow();
                break;
            }
            case 4: {
                this.pauseTimers();
                break;
            }
            case 3: {
                this.resumeTimers();
                break;
            }
            case 6: {
                this.onDestroy();
                break;
            }
            case 5: {
                this.onHide();
                break;
            }
        }
    }

    private class XWalkActivityStateListener
    implements ApplicationStatus.ActivityStateListener {
        WeakReference<XWalkViewInternal> mXWalkViewRef;

        XWalkActivityStateListener(XWalkViewInternal view) {
            this.mXWalkViewRef = new WeakReference<XWalkViewInternal>(view);
        }

        public void onActivityStateChange(Activity activity, int newState) {
            XWalkViewInternal view = (XWalkViewInternal)((Object)this.mXWalkViewRef.get());
            if (view == null) {
                return;
            }
            view.onActivityStateChange(activity, newState);
        }
    }
}

