/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.chromium.base.ApplicationStatusManager;
import org.chromium.base.CommandLine;
import org.chromium.base.JNINamespace;
import org.chromium.base.PathUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.base.library_loader.ProcessInitException;
import org.chromium.content.browser.BrowserStartupController;
import org.chromium.content.browser.DeviceUtils;
import org.chromium.content.browser.ResourceExtractor;
import org.chromium.net.NetworkChangeNotifier;
import org.xwalk.core.internal.XWalkViewInternal;

@JNINamespace(value="xwalk")
class XWalkViewDelegate {
    private static boolean sInitialized = false;
    private static boolean sRunningOnIA = true;
    private static final String PRIVATE_DATA_DIRECTORY_SUFFIX = "xwalkcore";
    private static final String[] MANDATORY_PAKS = new String[]{"xwalk.pak", "en-US.pak", "icudtl.dat"};
    private static final String[] MANDATORY_LIBRARIES = new String[]{"libxwalkcore.so"};
    private static final String TAG = "XWalkViewDelegate";
    private static final String XWALK_RESOURCES_LIST_RES_NAME = "xwalk_resources_list";
    private static final String COMMAND_LINE_FILE = "xwalk-command-line";

    XWalkViewDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readCommandLine(Context context) {
        InputStreamReader reader = null;
        try {
            int length;
            InputStream input = context.getAssets().open(COMMAND_LINE_FILE, 3);
            int size = 1024;
            char[] buffer = new char[size];
            StringBuilder builder = new StringBuilder();
            reader = new InputStreamReader(input, "UTF-8");
            while ((length = reader.read(buffer, 0, size)) != -1) {
                builder.append(buffer, 0, length);
            }
            String[] stringArray = CommandLine.tokenizeQuotedAruments(builder.toString().toCharArray());
            return stringArray;
        }
        catch (IOException e) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Unable to close file reader.", (Throwable)e);
            }
        }
    }

    public static void init(XWalkViewInternal xwalkView) throws UnsatisfiedLinkError {
        if (sInitialized) {
            return;
        }
        ApplicationStatusManager.init(xwalkView.getActivity().getApplication());
        NetworkChangeNotifier.init((Context)xwalkView.getActivity());
        NetworkChangeNotifier.setAutoDetectConnectivityState(true);
        ApplicationStatusManager.informActivityStarted(xwalkView.getActivity());
        final Context context = xwalkView.getViewContext();
        if (!CommandLine.isInitialized()) {
            CommandLine.init(XWalkViewDelegate.readCommandLine(context.getApplicationContext()));
        }
        if (Build.VERSION.SDK_INT < 17 && !context.getApplicationContext().getPackageName().equals(context.getPackageName())) {
            for (String library : MANDATORY_LIBRARIES) {
                System.load("/data/data/" + context.getPackageName() + "/lib/" + library);
            }
        }
        XWalkViewDelegate.loadLibrary(context);
        DeviceUtils.addDeviceSpecificUserAgentSwitch(context);
        if (sRunningOnIA && !XWalkViewDelegate.nativeIsLibraryBuiltForIA()) {
            throw new UnsatisfiedLinkError();
        }
        ResourceExtractor.setMandatoryPaksToExtract(MANDATORY_PAKS);
        final int resourcesListResId = context.getResources().getIdentifier(XWALK_RESOURCES_LIST_RES_NAME, "array", context.getPackageName());
        if (resourcesListResId != 0) {
            ResourceExtractor.setResourceIntercepter(new ResourceExtractor.ResourceIntercepter(){

                @Override
                public Set<String> getInterceptableResourceList() {
                    try {
                        String[] resources;
                        HashSet<String> resourcesList = new HashSet<String>();
                        for (String resource : resources = context.getResources().getStringArray(resourcesListResId)) {
                            resourcesList.add(resource);
                        }
                        return resourcesList;
                    }
                    catch (Resources.NotFoundException e) {
                        Log.w((String)XWalkViewDelegate.TAG, (String)"R.array.xwalk_resources_list can't be found.");
                        return null;
                    }
                }

                @Override
                public InputStream interceptLoadingForResource(String resource) {
                    String resourceName = resource.split("\\.")[0];
                    int resId = context.getResources().getIdentifier(resourceName, "raw", context.getPackageName());
                    try {
                        if (resId != 0) {
                            return context.getResources().openRawResource(resId);
                        }
                    }
                    catch (Resources.NotFoundException e) {
                        Log.w((String)XWalkViewDelegate.TAG, (String)("R.raw." + resourceName + " can't be found."));
                    }
                    return null;
                }
            });
        }
        ResourceExtractor.setExtractImplicitLocaleForTesting(false);
        ResourceExtractor.get(context);
        XWalkViewDelegate.startBrowserProcess(context);
        sInitialized = true;
    }

    private static void loadLibrary(Context context) {
        PathUtils.setPrivateDataDirectorySuffix(PRIVATE_DATA_DIRECTORY_SUFFIX);
        try {
            LibraryLoader.loadNow(context, true);
        }
        catch (ProcessInitException e) {
            throw new RuntimeException("Cannot load Crosswalk Core", e);
        }
    }

    private static void startBrowserProcess(final Context context) {
        ThreadUtils.runOnUiThreadBlocking(new Runnable(){

            public void run() {
                try {
                    LibraryLoader.ensureInitialized();
                }
                catch (ProcessInitException e) {
                    throw new RuntimeException("Cannot initialize Crosswalk Core", e);
                }
                try {
                    BrowserStartupController.get(context).startBrowserProcessesSync(0);
                }
                catch (ProcessInitException e) {
                    throw new RuntimeException("Cannot initialize Crosswalk Core", e);
                }
            }
        });
    }

    public static boolean isRunningOnIA() {
        return sRunningOnIA;
    }

    private static native boolean nativeIsLibraryBuiltForIA();

    static {
        sRunningOnIA = Build.CPU_ABI.equalsIgnoreCase("x86");
    }
}

