/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Build;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.ValueCallback;
import android.widget.EditText;
import org.xwalk.core.internal.R;
import org.xwalk.core.internal.XWalkJavascriptResultInternal;
import org.xwalk.core.internal.XWalkViewInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWalkUIClientInternal {
    private static String mJSAlertTitle;
    private static String mJSConfirmTitle;
    private static String mJSPromptTitle;
    private static String mOKButton;
    private static String mCancelButton;
    private Context mContext;
    private AlertDialog mDialog;
    private EditText mPromptText;
    private int mSystemUiFlag;
    private View mDecorView;
    private XWalkViewInternal mXWalkView;
    private boolean mOriginalFullscreen;
    private boolean mOriginalForceNotFullscreen;

    public XWalkUIClientInternal(XWalkViewInternal view) {
        this.mContext = view.getContext();
        this.mDecorView = view.getActivity().getWindow().getDecorView();
        if (Build.VERSION.SDK_INT >= 19) {
            this.mSystemUiFlag = 1792;
        }
        this.mXWalkView = view;
        this.initResources();
    }

    private void initResources() {
        if (mJSAlertTitle != null) {
            return;
        }
        mJSAlertTitle = this.mContext.getString(R.string.js_alert_title);
        mJSConfirmTitle = this.mContext.getString(R.string.js_confirm_title);
        mJSPromptTitle = this.mContext.getString(R.string.js_prompt_title);
        mOKButton = this.mContext.getString(17039370);
        mCancelButton = this.mContext.getString(0x1040000);
    }

    public void onRequestFocus(XWalkViewInternal view) {
    }

    public void onJavascriptCloseWindow(XWalkViewInternal view) {
        if (view != null && view.getActivity() != null) {
            view.getActivity().finish();
        }
    }

    public boolean onJavascriptModalDialog(XWalkViewInternal view, JavascriptMessageTypeInternal type, String url, String message, String defaultValue, XWalkJavascriptResultInternal result) {
        switch (type) {
            case JAVASCRIPT_ALERT: {
                return this.onJsAlert(view, url, message, result);
            }
            case JAVASCRIPT_CONFIRM: {
                return this.onJsConfirm(view, url, message, result);
            }
            case JAVASCRIPT_PROMPT: {
                return this.onJsPrompt(view, url, message, defaultValue, result);
            }
            case JAVASCRIPT_BEFOREUNLOAD: {
                return this.onJsConfirm(view, url, message, result);
            }
        }
        assert (false);
        return false;
    }

    public void onFullscreenToggled(XWalkViewInternal view, boolean enterFullscreen) {
        Activity activity = view.getActivity();
        if (enterFullscreen) {
            if ((activity.getWindow().getAttributes().flags & 0x800) != 0) {
                this.mOriginalForceNotFullscreen = true;
                activity.getWindow().clearFlags(2048);
            } else {
                this.mOriginalForceNotFullscreen = false;
            }
            if (Build.VERSION.SDK_INT >= 19) {
                this.mSystemUiFlag = this.mDecorView.getSystemUiVisibility();
                this.mDecorView.setSystemUiVisibility(5894);
            } else if ((activity.getWindow().getAttributes().flags & 0x400) != 0) {
                this.mOriginalFullscreen = true;
            } else {
                this.mOriginalFullscreen = false;
                activity.getWindow().addFlags(1024);
            }
        } else {
            if (this.mOriginalForceNotFullscreen) {
                activity.getWindow().addFlags(2048);
            }
            if (Build.VERSION.SDK_INT >= 19) {
                this.mDecorView.setSystemUiVisibility(this.mSystemUiFlag);
            } else if (!this.mOriginalFullscreen) {
                activity.getWindow().clearFlags(1024);
            }
        }
    }

    public void openFileChooser(XWalkViewInternal view, ValueCallback<Uri> uploadFile, String acceptType, String capture) {
        uploadFile.onReceiveValue(null);
    }

    public void onScaleChanged(XWalkViewInternal view, float oldScale, float newScale) {
    }

    public boolean shouldOverrideKeyEvent(XWalkViewInternal view, KeyEvent event) {
        return false;
    }

    public void onUnhandledKeyEvent(XWalkViewInternal view, KeyEvent event) {
    }

    public void onReceivedTitle(XWalkViewInternal view, String title) {
    }

    public void onPageLoadStarted(XWalkViewInternal view, String url) {
    }

    public void onPageLoadStopped(XWalkViewInternal view, String url, LoadStatusInternal status) {
    }

    private boolean onJsAlert(XWalkViewInternal view, String url, String message, XWalkJavascriptResultInternal result) {
        final XWalkJavascriptResultInternal fResult = result;
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this.mContext);
        dialogBuilder.setTitle((CharSequence)mJSAlertTitle).setMessage((CharSequence)message).setCancelable(true).setPositiveButton((CharSequence)mOKButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                fResult.confirm();
                dialog.dismiss();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                fResult.cancel();
            }
        });
        this.mDialog = dialogBuilder.create();
        this.mDialog.show();
        return false;
    }

    private boolean onJsConfirm(XWalkViewInternal view, String url, String message, XWalkJavascriptResultInternal result) {
        final XWalkJavascriptResultInternal fResult = result;
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this.mContext);
        dialogBuilder.setTitle((CharSequence)mJSConfirmTitle).setMessage((CharSequence)message).setCancelable(true).setPositiveButton((CharSequence)mOKButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                fResult.confirm();
                dialog.dismiss();
            }
        }).setNegativeButton((CharSequence)mCancelButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                fResult.cancel();
            }
        });
        this.mDialog = dialogBuilder.create();
        this.mDialog.show();
        return false;
    }

    private boolean onJsPrompt(XWalkViewInternal view, String url, String message, String defaultValue, XWalkJavascriptResultInternal result) {
        final XWalkJavascriptResultInternal fResult = result;
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this.mContext);
        dialogBuilder.setTitle((CharSequence)mJSPromptTitle).setMessage((CharSequence)message).setPositiveButton((CharSequence)mOKButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                fResult.confirmWithResult(XWalkUIClientInternal.this.mPromptText.getText().toString());
                dialog.dismiss();
            }
        }).setNegativeButton((CharSequence)mCancelButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                fResult.cancel();
            }
        });
        this.mPromptText = new EditText(this.mContext);
        this.mPromptText.setVisibility(0);
        this.mPromptText.setText((CharSequence)defaultValue);
        this.mPromptText.selectAll();
        dialogBuilder.setView((View)this.mPromptText);
        this.mDialog = dialogBuilder.create();
        this.mDialog.show();
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoadStatusInternal {
        FINISHED,
        FAILED,
        CANCELLED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JavascriptMessageTypeInternal {
        JAVASCRIPT_ALERT,
        JAVASCRIPT_CONFIRM,
        JAVASCRIPT_PROMPT,
        JAVASCRIPT_BEFOREUNLOAD;

    }
}

