/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;

@JNINamespace(value="xwalk")
public class XWalkSettings {
    private static final String TAG = "XWalkSettings";
    private final Object mXWalkSettingsLock = new Object();
    private final Context mContext;
    private boolean mAllowScriptsToCloseWindows = true;
    private boolean mLoadsImagesAutomatically = true;
    private boolean mImagesEnabled = true;
    private boolean mJavaScriptEnabled = true;
    private boolean mAllowUniversalAccessFromFileURLs = false;
    private boolean mAllowFileAccessFromFileURLs = false;
    private boolean mJavaScriptCanOpenWindowsAutomatically = true;
    private int mCacheMode = -1;
    private boolean mSupportMultipleWindows = true;
    private boolean mAppCacheEnabled = true;
    private boolean mDomStorageEnabled = true;
    private boolean mDatabaseEnabled = true;
    private boolean mUseWideViewport = false;
    private boolean mMediaPlaybackRequiresUserGesture = false;
    private String mDefaultVideoPosterURL;
    private boolean mBlockNetworkLoads;
    private boolean mAllowContentUrlAccess = true;
    private boolean mAllowFileUrlAccess = true;
    private boolean mShouldFocusFirstNode = true;
    private boolean mGeolocationEnabled = true;
    private String mUserAgent;
    private static final Object sGlobalContentSettingsLock = new Object();
    private static boolean sAppCachePathIsSet = false;
    private long mNativeXWalkSettings = 0L;
    private boolean mIsUpdateWebkitPrefsMessagePending = false;
    private final EventHandler mEventHandler;
    private static final int MINIMUM_FONT_SIZE = 1;
    private static final int MAXIMUM_FONT_SIZE = 72;

    public XWalkSettings(Context context, long nativeWebContents, boolean isAccessFromFileURLsGrantedByDefault) {
        ThreadUtils.assertOnUiThread();
        this.mContext = context;
        boolean bl = this.mBlockNetworkLoads = this.mContext.checkPermission("android.permission.INTERNET", Process.myPid(), Process.myUid()) != 0;
        if (isAccessFromFileURLsGrantedByDefault) {
            this.mAllowUniversalAccessFromFileURLs = true;
            this.mAllowFileAccessFromFileURLs = true;
        }
        this.mUserAgent = LazyDefaultUserAgent.sInstance;
        this.mEventHandler = new EventHandler();
        this.setWebContents(nativeWebContents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWebContents(long nativeWebContents) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mNativeXWalkSettings != 0L) {
                this.nativeDestroy(this.mNativeXWalkSettings);
                assert (this.mNativeXWalkSettings == 0L);
            }
            if (nativeWebContents != 0L) {
                this.mEventHandler.bindUiThread();
                this.mNativeXWalkSettings = this.nativeInit(nativeWebContents);
                this.nativeUpdateEverythingLocked(this.mNativeXWalkSettings);
            }
        }
    }

    @CalledByNative
    private void nativeXWalkSettingsGone(long nativeXWalkSettings) {
        assert (this.mNativeXWalkSettings != 0L && this.mNativeXWalkSettings == nativeXWalkSettings);
        this.mNativeXWalkSettings = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowScriptsToCloseWindows(boolean allow) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAllowScriptsToCloseWindows != allow) {
                this.mAllowScriptsToCloseWindows = allow;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllowScriptsToCloseWindows() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mAllowScriptsToCloseWindows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheMode(int mode) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mCacheMode != mode) {
                this.mCacheMode = mode;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCacheMode() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mCacheMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockNetworkLoads(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (!flag && this.mContext.checkPermission("android.permission.INTERNET", Process.myPid(), Process.myUid()) != 0) {
                throw new SecurityException("Permission denied - application missing INTERNET permission");
            }
            this.mBlockNetworkLoads = flag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBlockNetworkLoads() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mBlockNetworkLoads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowFileAccess(boolean allow) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAllowFileUrlAccess != allow) {
                this.mAllowFileUrlAccess = allow;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllowFileAccess() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mAllowFileUrlAccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowContentAccess(boolean allow) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAllowContentUrlAccess != allow) {
                this.mAllowContentUrlAccess = allow;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllowContentAccess() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mAllowContentUrlAccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeolocationEnabled(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mGeolocationEnabled != flag) {
                this.mGeolocationEnabled = flag;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getGeolocationEnabled() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mGeolocationEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaScriptEnabled(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mJavaScriptEnabled != flag) {
                this.mJavaScriptEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowUniversalAccessFromFileURLs(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAllowUniversalAccessFromFileURLs != flag) {
                this.mAllowUniversalAccessFromFileURLs = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowFileAccessFromFileURLs(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAllowFileAccessFromFileURLs != flag) {
                this.mAllowFileAccessFromFileURLs = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadsImagesAutomatically(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mLoadsImagesAutomatically != flag) {
                this.mLoadsImagesAutomatically = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getLoadsImagesAutomatically() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mLoadsImagesAutomatically;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImagesEnabled(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mImagesEnabled != flag) {
                this.mImagesEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getImagesEnabled() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mImagesEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJavaScriptEnabled() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mJavaScriptEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllowUniversalAccessFromFileURLs() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mAllowUniversalAccessFromFileURLs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllowFileAccessFromFileURLs() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mAllowFileAccessFromFileURLs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaScriptCanOpenWindowsAutomatically(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mJavaScriptCanOpenWindowsAutomatically != flag) {
                this.mJavaScriptCanOpenWindowsAutomatically = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJavaScriptCanOpenWindowsAutomatically() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mJavaScriptCanOpenWindowsAutomatically;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSupportMultipleWindows(boolean support) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mSupportMultipleWindows != support) {
                this.mSupportMultipleWindows = support;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportMultipleWindows() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mSupportMultipleWindows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseWideViewPort(boolean use) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mUseWideViewport != use) {
                this.mUseWideViewport = use;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUseWideViewPort() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mUseWideViewport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppCacheEnabled(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mAppCacheEnabled != flag) {
                this.mAppCacheEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppCachePath(String path) {
        boolean needToSync = false;
        Object object = sGlobalContentSettingsLock;
        synchronized (object) {
            if (!sAppCachePathIsSet && path != null && !path.isEmpty()) {
                sAppCachePathIsSet = true;
                needToSync = true;
            }
        }
        if (needToSync) {
            object = this.mXWalkSettingsLock;
            synchronized (object) {
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    @CalledByNative
    private boolean getAppCacheEnabled() {
        return this.mAppCacheEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDomStorageEnabled(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mDomStorageEnabled != flag) {
                this.mDomStorageEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDomStorageEnabled() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mDomStorageEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDatabaseEnabled(boolean flag) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mDatabaseEnabled != flag) {
                this.mDatabaseEnabled = flag;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDatabaseEnabled() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mDatabaseEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaPlaybackRequiresUserGesture(boolean require) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mMediaPlaybackRequiresUserGesture != require) {
                this.mMediaPlaybackRequiresUserGesture = require;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMediaPlaybackRequiresUserGesture() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mMediaPlaybackRequiresUserGesture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultVideoPosterURL(String url) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            if (this.mDefaultVideoPosterURL != null && !this.mDefaultVideoPosterURL.equals(url) || this.mDefaultVideoPosterURL == null && url != null) {
                this.mDefaultVideoPosterURL = url;
                this.mEventHandler.updateWebkitPreferencesLocked();
            }
        }
    }

    public static String getDefaultUserAgent() {
        return LazyDefaultUserAgent.sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserAgentString(String ua) {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            String oldUserAgent = this.mUserAgent;
            this.mUserAgent = ua == null || ua.length() == 0 ? LazyDefaultUserAgent.sInstance : ua;
            if (!oldUserAgent.equals(this.mUserAgent)) {
                this.mEventHandler.maybeRunOnUiThreadBlocking(new Runnable(){

                    public void run() {
                        if (XWalkSettings.this.mNativeXWalkSettings != 0L) {
                            XWalkSettings.this.nativeUpdateUserAgent(XWalkSettings.this.mNativeXWalkSettings);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserAgentString() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mUserAgent;
        }
    }

    @CalledByNative
    private String getUserAgentLocked() {
        return this.mUserAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultVideoPosterURL() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            return this.mDefaultVideoPosterURL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void updateEverything() {
        Object object = this.mXWalkSettingsLock;
        synchronized (object) {
            this.nativeUpdateEverythingLocked(this.mNativeXWalkSettings);
        }
    }

    private void updateWebkitPreferencesOnUiThread() {
        if (this.mNativeXWalkSettings != 0L) {
            ThreadUtils.assertOnUiThread();
            this.nativeUpdateWebkitPreferences(this.mNativeXWalkSettings);
        }
    }

    private native long nativeInit(long var1);

    private native void nativeDestroy(long var1);

    private static native String nativeGetDefaultUserAgent();

    private native void nativeUpdateEverythingLocked(long var1);

    private native void nativeUpdateUserAgent(long var1);

    private native void nativeUpdateWebkitPreferences(long var1);

    static /* synthetic */ String access$000() {
        return XWalkSettings.nativeGetDefaultUserAgent();
    }

    private class EventHandler {
        private static final int UPDATE_WEBKIT_PREFERENCES = 0;
        private Handler mHandler;

        EventHandler() {
        }

        void bindUiThread() {
            if (this.mHandler != null) {
                return;
            }
            this.mHandler = new Handler(ThreadUtils.getUiThreadLooper()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            Object object = XWalkSettings.this.mXWalkSettingsLock;
                            synchronized (object) {
                                XWalkSettings.this.updateWebkitPreferencesOnUiThread();
                                XWalkSettings.this.mIsUpdateWebkitPrefsMessagePending = false;
                                XWalkSettings.this.mXWalkSettingsLock.notifyAll();
                                break;
                            }
                        }
                    }
                }
            };
        }

        void maybeRunOnUiThreadBlocking(Runnable r) {
            if (this.mHandler != null) {
                ThreadUtils.runOnUiThreadBlocking(r);
            }
        }

        private void updateWebkitPreferencesLocked() {
            assert (Thread.holdsLock(XWalkSettings.this.mXWalkSettingsLock));
            if (XWalkSettings.this.mNativeXWalkSettings == 0L) {
                return;
            }
            if (this.mHandler == null) {
                return;
            }
            if (ThreadUtils.runningOnUiThread()) {
                XWalkSettings.this.updateWebkitPreferencesOnUiThread();
            } else {
                if (XWalkSettings.this.mIsUpdateWebkitPrefsMessagePending) {
                    return;
                }
                XWalkSettings.this.mIsUpdateWebkitPrefsMessagePending = true;
                this.mHandler.sendMessage(Message.obtain(null, (int)0));
                try {
                    while (XWalkSettings.this.mIsUpdateWebkitPrefsMessagePending) {
                        XWalkSettings.this.mXWalkSettingsLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    static class LazyDefaultUserAgent {
        private static final String sInstance = XWalkSettings.access$000();

        LazyDefaultUserAgent() {
        }
    }
}

