/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class XWalkPreferencesInternal {
    private static HashMap<String, Boolean> sPrefMap = new HashMap();
    private static ArrayList<WeakReference<KeyValueChangeListener>> sListeners = new ArrayList();
    private static ReferenceQueue<KeyValueChangeListener> sRefQueue = new ReferenceQueue();
    public static final String REMOTE_DEBUGGING = "remote-debugging";
    public static final String ANIMATABLE_XWALK_VIEW = "animatable-xwalk-view";
    static final String ENABLE_JAVASCRIPT = "enable-javascript";
    static final String JAVASCRIPT_CAN_OPEN_WINDOW = "javascript-can-open-window";
    static final String ALLOW_UNIVERSAL_ACCESS_FROM_FILE = "allow-universal-access-from-file";
    static final String SUPPORT_MULTIPLE_WINDOWS = "support-multiple-windows";

    public static synchronized void setValue(String key, boolean enabled) throws RuntimeException {
        XWalkPreferencesInternal.checkKey(key);
        if (key == ANIMATABLE_XWALK_VIEW && !sListeners.isEmpty()) {
            throw new RuntimeException("Warning: the preference key " + key + " can not be set if the preference is already loaded by Crosswalk");
        }
        if (sPrefMap.get(key) != enabled) {
            sPrefMap.put(key, new Boolean(enabled));
            XWalkPreferencesInternal.onKeyValueChanged(key, enabled);
        }
    }

    public static synchronized boolean getValue(String key) throws RuntimeException {
        XWalkPreferencesInternal.checkKey(key);
        return sPrefMap.get(key);
    }

    static synchronized void load(KeyValueChangeListener listener) {
        for (Map.Entry<String, Boolean> entry : sPrefMap.entrySet()) {
            listener.onKeyValueChanged(entry.getKey(), entry.getValue());
        }
        XWalkPreferencesInternal.registerListener(listener);
    }

    static synchronized void unload(KeyValueChangeListener listener) {
        XWalkPreferencesInternal.unregisterListener(listener);
    }

    private static synchronized void registerListener(KeyValueChangeListener listener) {
        XWalkPreferencesInternal.removeEnqueuedReference();
        WeakReference<KeyValueChangeListener> weakListener = new WeakReference<KeyValueChangeListener>(listener, sRefQueue);
        sListeners.add(weakListener);
    }

    private static synchronized void unregisterListener(KeyValueChangeListener listener) {
        XWalkPreferencesInternal.removeEnqueuedReference();
        for (WeakReference<KeyValueChangeListener> weakListener : sListeners) {
            if (weakListener.get() != listener) continue;
            sListeners.remove(weakListener);
            break;
        }
    }

    private static void onKeyValueChanged(String key, boolean enabled) {
        for (WeakReference<KeyValueChangeListener> weakListener : sListeners) {
            KeyValueChangeListener listener = (KeyValueChangeListener)weakListener.get();
            if (listener == null) continue;
            listener.onKeyValueChanged(key, enabled);
        }
    }

    private static void checkKey(String key) throws RuntimeException {
        XWalkPreferencesInternal.removeEnqueuedReference();
        if (!sPrefMap.containsKey(key)) {
            throw new RuntimeException("Warning: the preference key " + key + " is not supported by Crosswalk.");
        }
    }

    private static void removeEnqueuedReference() {
        WeakReference toRemove;
        while ((toRemove = (WeakReference)sRefQueue.poll()) != null) {
            sListeners.remove(toRemove);
        }
    }

    static {
        sPrefMap.put(REMOTE_DEBUGGING, Boolean.FALSE);
        sPrefMap.put(ANIMATABLE_XWALK_VIEW, Boolean.FALSE);
        sPrefMap.put(ENABLE_JAVASCRIPT, Boolean.TRUE);
        sPrefMap.put(JAVASCRIPT_CAN_OPEN_WINDOW, Boolean.TRUE);
        sPrefMap.put(ALLOW_UNIVERSAL_ACCESS_FROM_FILE, Boolean.FALSE);
        sPrefMap.put(SUPPORT_MULTIPLE_WINDOWS, Boolean.TRUE);
    }

    static interface KeyValueChangeListener {
        public void onKeyValueChanged(String var1, boolean var2);
    }
}

